/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;
import misc.OsHelper;
import misc.StringUtils;

public class GenerateAmplicon {
    public static void main(String[] args) throws Exception {
        File primerFile = new File(args[0]);
        File fasta = new File(args[1]);
        String sequence = GenerateAmplicon.getSequenceFromFasta(fasta);
        StringBuilder newData = new StringBuilder();
        String[] lines = FileManager.readTextFile(primerFile).split("\n");
        String[] data = null;
        String fPrimer = null;
        String rPrimer = null;
        String maskedSeq = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            newData.append(line.trim());
            data = line.split(",");
            fPrimer = data[1].trim();
            rPrimer = data[3].trim();
            int start = sequence.indexOf(fPrimer);
            int end = sequence.indexOf(StringUtils.revCompSeq(rPrimer), sequence.indexOf(fPrimer));
            if (start > 0 && end > 0) {
                newData.append(",").append(start).append(",").append(end + rPrimer.length());
                newData.append(",").append(sequence.substring(start, end + rPrimer.length()));
                maskedSeq = GenerateAmplicon.getMaskedSeq(sequence.substring(start, end + rPrimer.length()));
                newData.append(",").append(maskedSeq);
                System.out.println(String.valueOf(data[0]) + " " + data[2]);
            }
            newData.append("\n");
            ++n2;
        }
        FileManager.writeTextFile(primerFile, newData.toString(), true);
    }

    private static String getMaskedSeq(String sequence) throws Exception {
        File tmpFile = File.createTempFile("abc", "seq");
        FileManager.writeTextFile(tmpFile, ">\n" + sequence, true);
        OsHelper.excuteCommand("/genome/bin_common/RepeatMasker " + tmpFile.getAbsolutePath());
        return GenerateAmplicon.getSequenceFromFasta(new File(tmpFile + ".masked"));
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString().toUpperCase();
    }
}

