/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class FormatSnpDetectorOutput {
    public static void main(String[] args) throws Exception {
        File amp_list = new File(args[0]);
        File outpuRoot = new File(args[1]);
        File seqDir = new File(args[2]);
        String[] amps = FileManager.readTextFile(amp_list).split("\n");
        File output = null;
        File newOutput = null;
        File backbone = null;
        File contigOut = null;
        File editDir = null;
        String backboneSequence = null;
        int i = 0;
        while (i < amps.length) {
            System.out.println(amps[i]);
            editDir = new File(new File(outpuRoot, amps[i]), "edit_dir");
            output = new File(editDir, "goodSNPgenotype.txt");
            newOutput = new File(editDir, "formatedGoodSNPgenotype.txt");
            contigOut = new File(editDir, "contig.out");
            if (!output.exists()) {
                System.out.println("no good snp");
            } else {
                backbone = new File(seqDir, amps[i]);
                backboneSequence = FormatSnpDetectorOutput.getBackboneSequence(backbone);
                boolean isRevComp = FormatSnpDetectorOutput.checkDirection(contigOut, backboneSequence);
                ArrayList<Integer> positions = new ArrayList<Integer>();
                HashMap<String, Map> callMap = new HashMap<String, Map>();
                FormatSnpDetectorOutput.parseOutput(output, positions, callMap, backboneSequence.length(), isRevComp);
                List<String[]> flankings = FormatSnpDetectorOutput.cutFlanking(backboneSequence, positions);
                FormatSnpDetectorOutput.writeOutput(newOutput, positions, flankings, callMap);
            }
            ++i;
        }
    }

    public static String revCompSeq(String seq) {
        String ret = "";
        String base = "";
        int i = seq.length() - 1;
        while (i >= 0) {
            base = "Aa".indexOf(seq.charAt(i)) > -1 ? "T" : ("Tt".indexOf(seq.charAt(i)) > -1 ? "A" : ("Cc".indexOf(seq.charAt(i)) > -1 ? "G" : ("Gg".indexOf(seq.charAt(i)) > -1 ? "C" : ("Nn".indexOf(seq.charAt(i)) > -1 ? "N" : ("Ww".indexOf(seq.charAt(i)) > -1 ? "W" : (".".indexOf(seq.charAt(i)) > -1 ? "." : String.valueOf(seq.charAt(i))))))));
            ret = String.valueOf(ret) + base;
            --i;
        }
        return ret;
    }

    private static boolean checkDirection(File contigOut, String backboneSequence) {
        boolean isRevComp = false;
        String[] data = FileManager.readTextFile(contigOut).split("\n");
        int index = 4;
        if (data.length > 1) {
            String flanking;
            if (!data[1].trim().startsWith("SNP")) {
                index = 3;
            }
            if (backboneSequence.indexOf(flanking = data[1].trim().split("\\s+")[index].split("\\(")[0]) > -1) {
                return false;
            }
            if (backboneSequence.indexOf(FormatSnpDetectorOutput.revCompSeq(flanking)) > -1) {
                return true;
            }
            System.out.println("unknow format " + flanking);
        } else {
            System.out.print("uunknow direction");
        }
        System.out.print(isRevComp);
        return isRevComp;
    }

    public static void parseOutput(File output, List<Integer> positions, Map<String, Map> callMap, int seqLength, boolean isRevComp) {
        String[] data = FileManager.readTextFile(output).split("\n");
        Integer pos = null;
        String cellLine = null;
        String read = null;
        int i = 0;
        while (i < data.length) {
            String[] items = data[i].trim().split("\\s+");
            pos = items[1].charAt(items[1].length() - 1) == '*' ? new Integer(items[1].substring(0, items[1].length() - 1)) : new Integer(items[1]);
            pos = isRevComp ? seqLength - pos + 1 : pos;
            if (!positions.contains(pos)) {
                positions.add(pos);
            }
            cellLine = items[2];
            read = FormatSnpDetectorOutput.formatRead(items[3], isRevComp);
            if (!callMap.containsKey(cellLine)) {
                callMap.put(cellLine, new HashMap());
            }
            callMap.get(cellLine).put(pos, read);
            ++i;
        }
        boolean validSnp = false;
        Map cMap2 = null;
        String call = null;
        String acall = null;
        Iterator<Integer> it = positions.iterator();
        while (it.hasNext()) {
            pos = it.next();
            call = null;
            validSnp = false;
            for (Map cMap2 : callMap.values()) {
                if (!cMap2.containsKey(pos)) continue;
                acall = (String)cMap2.get(pos);
                if (call == null && !acall.equals("N")) {
                    call = acall;
                    continue;
                }
                if (call == null || acall.equals("N") || FormatSnpDetectorOutput.isSameCall(call, acall)) continue;
                validSnp = true;
                break;
            }
            if (validSnp) continue;
            it.remove();
        }
    }

    public static boolean isSameCall(String a, String b) {
        if (a.length() != b.length()) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a.length() == b.length() && a.length() == 1) {
            return false;
        }
        return a.length() == b.length() && a.length() == 3 && a.charAt(0) == b.charAt(2) && a.charAt(2) == b.charAt(0);
    }

    public static String formatRead(String entry, boolean isRevComp) {
        String read = entry.substring(entry.length() - 3, entry.length());
        if (read.trim().indexOf(">") == -1) {
            return "N";
        }
        if (read.charAt(0) == '-' && read.charAt(2) == '-') {
            return "N";
        }
        if (read.charAt(0) == '-' || read.charAt(2) == '-') {
            System.out.println("format this call !!!" + entry);
        }
        if (read.charAt(0) == read.charAt(2)) {
            return isRevComp ? FormatSnpDetectorOutput.revCompSeq(read.substring(0, 1)) : read.substring(0, 1);
        }
        return isRevComp ? FormatSnpDetectorOutput.revCompSeq(String.valueOf(read.charAt(0)) + "/" + read.charAt(2)) : String.valueOf(read.charAt(0)) + "/" + read.charAt(2);
    }

    private static String getBackboneSequence(File backbone) {
        StringBuilder builder = new StringBuilder();
        String[] data = FileManager.readTextFile(backbone).split("\n");
        int i = 1;
        while (i < data.length) {
            builder.append(data[i].trim());
            ++i;
        }
        return builder.toString();
    }

    public static List<String[]> cutFlanking(String seq, List<Integer> positions) {
        ArrayList<String[]> list = new ArrayList<String[]>();
        String leftFlank = null;
        String rightFlank = null;
        for (Integer pos : positions) {
            leftFlank = seq.substring(pos - 21, pos - 1);
            rightFlank = seq.substring(pos, pos + 20);
            String[] flanks = new String[]{leftFlank, rightFlank};
            list.add(flanks);
        }
        return list;
    }

    public static void writeOutput(File output, List<Integer> positions, List<String[]> flankings, Map<String, Map> callMap) {
        StringBuilder builder = new StringBuilder();
        builder.append("BackbonePosition");
        for (Integer pos : positions) {
            builder.append("\t").append(pos);
        }
        builder.append("\n");
        builder.append("5_end_flanking");
        for (String[] flanks : flankings) {
            builder.append("\t").append(flanks[0]);
        }
        builder.append("\n");
        builder.append("3_end_flanking");
        for (String[] flanks : flankings) {
            builder.append("\t").append(flanks[1]);
        }
        builder.append("\n");
        String cellLine2 = null;
        String call = null;
        Map posCallMap = null;
        for (String cellLine2 : callMap.keySet()) {
            builder.append(cellLine2);
            posCallMap = callMap.get(cellLine2);
            Iterator<Integer> pit = positions.iterator();
            while (pit.hasNext()) {
                call = (String)posCallMap.get(pit.next());
                builder.append("\t").append(call);
            }
            builder.append("\n");
        }
        FileManager.writeTextFile(output, builder.toString().trim(), true);
    }
}

