/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.FileManager;

public class FixSequenceWithQuality {
    private static int MIN_Q = 45;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File qualityFile = new File(args[1]);
        File outputFile = new File(args[2]);
        String sequence = FixSequenceWithQuality.getSequenceFromFasta(fastaFile);
        String[] quality = FixSequenceWithQuality.getQualityFromQuality(qualityFile);
        StringBuilder fastaBuilder = new StringBuilder();
        fastaBuilder.append(FileManager.readTextFile(fastaFile).split("\n")[0].trim()).append("\n");
        StringBuilder builder = new StringBuilder();
        int i = 0;
        while (i < quality.length) {
            int thisQ = new Integer(quality[i]);
            if (thisQ > 50) {
                builder.append(sequence.charAt(i));
            } else if (thisQ < 32) {
                builder.append("N");
            } else if (i >= 5 && i < quality.length - 5) {
                boolean leftok = false;
                boolean rightok = false;
                int j = i - 5;
                while (j < i) {
                    if (new Integer(quality[j]) > 50) {
                        leftok = true;
                        break;
                    }
                    ++j;
                }
                j = i + 1;
                while (j < i + 5) {
                    if (new Integer(quality[j]) > 50) {
                        rightok = true;
                        break;
                    }
                    ++j;
                }
                if (leftok && rightok) {
                    builder.append(sequence.charAt(i));
                } else {
                    int leftAveq = 0;
                    int rightAveq = 0;
                    int j2 = i - 2;
                    while (j2 <= i) {
                        leftAveq += new Integer(quality[j2]).intValue();
                        ++j2;
                    }
                    leftAveq = Math.round(leftAveq / 3);
                    j2 = i;
                    while (j2 <= i + 2) {
                        rightAveq += new Integer(quality[j2]).intValue();
                        ++j2;
                    }
                    rightAveq = Math.round(rightAveq / 3);
                    if (leftAveq >= 40 && rightAveq >= 40) {
                        builder.append(sequence.charAt(i));
                    } else {
                        builder.append("N");
                    }
                }
            } else {
                builder.append("N");
            }
            ++i;
        }
        fastaBuilder.append(FixSequenceWithQuality.postFixSequence(builder.toString()));
        FileManager.writeTextFile(outputFile, fastaBuilder.toString(), true);
    }

    private static String postFixSequence(String sequence) {
        StringBuilder builder = new StringBuilder();
        boolean enter = false;
        int start = 0;
        int end = 0;
        int i = 0;
        while (i < sequence.length()) {
            if (sequence.charAt(i) == 'N') {
                if (!enter) {
                    builder.append(sequence.charAt(i));
                } else {
                    int j;
                    end = i;
                    if (FixSequenceWithQuality.isTurnToN(sequence, start, end)) {
                        j = start;
                        while (j < end) {
                            builder.append("N");
                            ++j;
                        }
                    } else {
                        j = start;
                        while (j < end) {
                            builder.append(sequence.charAt(j));
                            ++j;
                        }
                    }
                    builder.append("N");
                    enter = false;
                    start = 0;
                    end = 0;
                }
            } else if (!enter) {
                start = i;
                enter = true;
            }
            ++i;
        }
        return builder.toString();
    }

    private static boolean passCheck(String sequence, int start, int end, int offset, int cutoff) {
        int leftcount = 0;
        int rightcount = 0;
        int i = start - offset;
        while (i < start) {
            if (sequence.charAt(i) == 'N') {
                ++leftcount;
            }
            ++i;
        }
        i = end;
        while (i < end + offset) {
            if (sequence.charAt(i) == 'N') {
                ++rightcount;
            }
            ++i;
        }
        return leftcount >= cutoff && rightcount >= cutoff;
    }

    private static boolean isTurnToN(String sequence, int start, int end) {
        if (end - start >= 8) {
            return false;
        }
        if (FixSequenceWithQuality.passCheck(sequence, start, end, 20, 10)) {
            return true;
        }
        return end - start < 5 && FixSequenceWithQuality.passCheck(sequence, start, end, 10, 5);
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }

    private static String[] getQualityFromQuality(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim()).append(" ");
            ++i;
        }
        return seq.toString().trim().split("\\s+");
    }
}

