/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class FilterName {
    public static void main(String[] args) throws Exception {
        File report = new File(args[0]);
        File sample = new File(args[1]);
        File output = new File(args[2]);
        List<String> names = FilterName.getReportSampleNames(report);
        Map<String, String> patInfo = FilterName.getPatInfo(sample);
        StringBuilder summary = new StringBuilder();
        System.out.println(names.size());
        int unknownCount = 0;
        for (String name : names) {
            if (patInfo.containsKey(name)) {
                summary.append(name).append("\t").append(patInfo.get(name));
                summary.append("\n");
                continue;
            }
            if (name.startsWith("ID")) {
                ++unknownCount;
            }
            System.out.println(name);
        }
        System.out.println(unknownCount);
        FileManager.writeTextFile(output, summary.toString(), true);
    }

    private static Map<String, String> getPatInfo(File sample) {
        String[] lines;
        HashMap<String, String> patInfo = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(sample).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\t");
            if (!patInfo.containsKey(items[0].trim())) {
                patInfo.put(items[0].trim(), items[1].trim());
            } else {
                System.out.println("duplicate " + line.trim());
            }
            ++n2;
        }
        return patInfo;
    }

    private static List<String> getReportSampleNames(File report) {
        String[] lines;
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(report).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("-");
            if (items.length > 3 && items[3].startsWith("ID")) {
                String name = items[3].trim();
                if (!names.contains(name)) {
                    names.add(name);
                }
            } else {
                if (!names.contains(line.trim())) {
                    names.add(line.trim());
                }
                System.out.println(line.trim());
            }
            ++n2;
        }
        return names;
    }
}

