/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import misc.SnpConfig;

public class FileHelper {
    public static String SNP_DATA_DIR = "snp_data_dir";
    public static String ABI_POLY_DIR = "abi_poly_dir";
    public static String POLY_DIR = "poly_dir";
    public static String PHD_DIR = "abi_phd_dir";
    public static String FASTA = "allfasta";
    public static String QUAL = "allfasta.qual";
    public static String FASTA_TRIM = "allfasta_trim";
    public static String QUAL_TRIM = "allfasta_trim.qual";
    public static String SNP_CHROMAT_RAW_DATA = "snp_chromat_raw";
    public static String SNP_CELL_LINE_RAW_DATA = "snp_cell_line_raw";
    public static String SNP_ANALYSIS_DATA = "snp_analysis_data";
    public static String SNP_FILTERED_DATA = "snp_filtered_data";
    public static String SNP_OPTIMIZED_DATA = "snp_optimized_data";
    public static String SNP_FINAL_DATA = "snp_final_data";
    public static String OVERALL_LOG = "overall_log";
    public static String PHRED_LOG = "phred_log";
    public static String CROSS_MATCH_LOG = "cross_match_log";
    public static String SNP_POSITION_LOG = "snp_position_log";
    public static String SNP_MERGE_LOG = "snp_merge_log";
    public static String SNP_ANALYSIS_LOG = "snp_analysis_log";
    public static String SNP_FILTER_LOG = "snp_filter_log";
    public static String SNP_OPTIMIZE_LOG = "snp_optimize_log";

    public static String snpDataDir(String outputRoot, String path) {
        File snpDir;
        File parent = new File(path).getParentFile();
        File file = new File(new File(outputRoot), parent.getName());
        if (!file.isDirectory()) {
            file.mkdir();
        }
        if (!(snpDir = new File(file, SNP_DATA_DIR)).isDirectory()) {
            snpDir.mkdir();
        }
        return snpDir.getAbsolutePath();
    }

    public static String phdDir(String path) {
        File parent = new File(path).getParentFile();
        File file = new File(parent, PHD_DIR);
        return file.getAbsolutePath();
    }

    public static String polyDir(String outputRoot, String path, SnpConfig config) {
        File polyDir;
        File parent = new File(path).getParentFile();
        File file = new File(new File(outputRoot), parent.getName());
        if (!file.isDirectory()) {
            file.mkdir();
        }
        if (!(polyDir = new File(file, POLY_DIR)).isDirectory()) {
            polyDir.mkdir();
        }
        return polyDir.getAbsolutePath();
    }

    public static String fastaFile(String path) {
        File fn = new File(new File(path), FASTA);
        return fn.getAbsolutePath();
    }

    public static String qualFile(String path) {
        File fn = new File(new File(path), QUAL);
        return fn.getAbsolutePath();
    }

    public static String fastaTrimFile(String path) {
        File fn = new File(new File(path), FASTA_TRIM);
        return fn.getAbsolutePath();
    }

    public static String qualTrimFile(String path) {
        File fn = new File(new File(path), QUAL_TRIM);
        return fn.getAbsolutePath();
    }

    public static String snpChromatRawDataFile(String path) {
        File fn = new File(new File(path), SNP_CHROMAT_RAW_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpCellLineRawDataFile(String path) {
        File fn = new File(new File(path), SNP_CELL_LINE_RAW_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpAnalysisDataFile(String path) {
        File fn = new File(new File(path), SNP_ANALYSIS_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpFilteredDataFile(String path) {
        File fn = new File(new File(path), SNP_FILTERED_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpOptimizedDataFile(String path) {
        File fn = new File(new File(path), SNP_OPTIMIZED_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpFinalDataFile(String path) {
        File fn = new File(new File(path), SNP_FINAL_DATA);
        return fn.getAbsolutePath();
    }

    public static String snpOverallLog(String outputRoot, String path) {
        String snpDir = FileHelper.snpDataDir(outputRoot, path);
        File file = new File(new File(snpDir), OVERALL_LOG);
        return file.getAbsolutePath();
    }

    public static String phredLog(String path) {
        File fn = new File(new File(path), PHRED_LOG);
        return fn.getAbsolutePath();
    }

    public static String crossMatchLog(String path) {
        File fn = new File(new File(path), CROSS_MATCH_LOG);
        return fn.getAbsolutePath();
    }

    public static String snpPositionLog(String path) {
        File fn = new File(new File(path), SNP_POSITION_LOG);
        return fn.getAbsolutePath();
    }

    public static String snpMergeLog(String path) {
        File fn = new File(new File(path), SNP_MERGE_LOG);
        return fn.getAbsolutePath();
    }

    public static String snpAnalysisLog(String path) {
        File fn = new File(new File(path), SNP_ANALYSIS_LOG);
        return fn.getAbsolutePath();
    }

    public static String snpFilterLog(String path) {
        File fn = new File(new File(path), SNP_FILTER_LOG);
        return fn.getAbsolutePath();
    }

    public static String snpOptimizeLog(String path) {
        File fn = new File(new File(path), SNP_OPTIMIZE_LOG);
        return fn.getAbsolutePath();
    }
}

