/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FileHandler {
    private BufferedWriter m_fileWriter = null;
    private BufferedReader m_fileReader = null;

    public List readFile(String fn) throws IOException {
        String text;
        ArrayList<String> data = new ArrayList<String>();
        this.m_fileReader = new BufferedReader(new FileReader(fn));
        while ((text = this.m_fileReader.readLine()) != null) {
            data.add(text);
        }
        this.m_fileReader.close();
        return data;
    }

    public String writeFile(String fileName, String dirName, List theList) throws IOException {
        File theDir = new File(dirName);
        if (!theDir.exists()) {
            theDir.mkdirs();
        }
        File theFile = new File(theDir, fileName);
        return this.writeFile(theFile.getAbsolutePath(), theList);
    }

    public String writeFile(String fn, List theList) throws IOException {
        this.m_fileWriter = new BufferedWriter(new FileWriter(fn));
        int i = 0;
        while (i < theList.size()) {
            this.m_fileWriter.write((String)theList.get(i));
            ++i;
        }
        this.m_fileWriter.flush();
        this.m_fileWriter.close();
        return fn;
    }

    public static void fastaCorrect(String fastaFn) throws IOException {
        ArrayList<String> newData = new ArrayList<String>();
        FileHandler handler = new FileHandler();
        List data = handler.readFile(fastaFn);
        int i = 0;
        while (i < data.size()) {
            String line1 = (String)data.get(i);
            if (line1.substring(0, 1).equals(">")) {
                newData.add(String.valueOf(line1) + "\n");
                String seq = "";
                int j = i + 1;
                while (j < data.size()) {
                    String line2 = (String)data.get(j);
                    if (line2.substring(0, 1).equals(">")) break;
                    seq = String.valueOf(seq) + line2.trim();
                    ++j;
                }
                newData.add(String.valueOf(seq) + "\n");
            }
            ++i;
        }
        handler.writeFile(fastaFn, newData);
    }

    public static void qualCorrect(String qualFn) throws IOException {
        ArrayList<String> newData = new ArrayList<String>();
        FileHandler handler = new FileHandler();
        List data = handler.readFile(qualFn);
        int i = 0;
        while (i < data.size()) {
            String line1 = (String)data.get(i);
            if (line1.substring(0, 1).equals(">")) {
                newData.add(String.valueOf(line1) + "\n");
                String seq = "";
                int j = i + 1;
                while (j < data.size()) {
                    String line2 = (String)data.get(j);
                    if (line2.substring(0, 1).equals(">")) break;
                    seq = seq.length() > 0 ? String.valueOf(seq) + " " + line2.trim() : String.valueOf(seq) + line2.trim();
                    ++j;
                }
                newData.add(String.valueOf(seq) + "\n");
            }
            ++i;
        }
        handler.writeFile(qualFn, newData);
    }

    public static List getAllChromatNames(String fn) throws IOException {
        ArrayList<String> newData = new ArrayList<String>();
        FileHandler handler = new FileHandler();
        List data = handler.readFile(fn);
        int i = 0;
        while (i < data.size()) {
            String line = (String)data.get(i);
            if (line.length() > 0 && line.substring(0, 1).equals(">")) {
                newData.add(line.substring(1).split("\\s")[0]);
            }
            ++i;
        }
        return newData;
    }

    public static Map getAllFasta(String fn) throws IOException {
        HashMap<String, String> map = new HashMap<String, String>();
        FileHandler handler = new FileHandler();
        List data = handler.readFile(fn);
        int i = 0;
        while (i < data.size()) {
            String line = (String)data.get(i);
            if (line.length() > 0 && line.substring(0, 1).equals(">")) {
                map.put(line.substring(1).split("\\s")[0], ((String)data.get(i + 1)).trim());
            }
            ++i;
        }
        return map;
    }
}

