/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.TestAmbiguity;

public class DiploidAmbigiutyFinder {
    public static void main(String[] args) throws Exception {
        String type = args[0];
        File fastaAlignmentFile = new File(args[1]);
        File ambiguityFile = new File(args[2]);
        File symbolFile = new File(args[3]);
        File batchFile = new File(args[4]);
        Map<String, String> sequenceMap = TestAmbiguity.parseAlignmentFile(fastaAlignmentFile, type);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        String[] data = FileManager.readTextFile(batchFile).trim().split("\n");
        Map<String, List> symbolMap = DiploidAmbigiutyFinder.parseSymbolFile(symbolFile, type);
        DiploidAmbigiutyFinder.checkDataNames(data, sequenceMap, symbolMap);
        List<Map<String, Integer>> ambiguitiesList = DiploidAmbigiutyFinder.initAmbiguitiesList(ambiguities);
        DiploidAmbigiutyFinder.populateList(data, ambiguitiesList, ambiguityFile);
        DiploidAmbigiutyFinder.findAmbiguities(ambiguitiesList);
    }

    private static void findAmbiguities(List<Map<String, Integer>> ambiguitiesList) {
        for (Map<String, Integer> map : ambiguitiesList) {
            boolean find = false;
            for (String name : map.keySet()) {
                if (map.get(name) <= 0) continue;
                if (!find) {
                    find = true;
                    continue;
                }
                DiploidAmbigiutyFinder.printMap(map);
            }
        }
    }

    private static void printMap(Map<String, Integer> map) {
        System.out.println("find both answer -------------");
        for (String name : map.keySet()) {
            System.out.println(String.valueOf(name) + " " + map.get(name));
        }
    }

    private static void populateList(String[] data, List<Map<String, Integer>> ambiguitiesList, File ambiguityFile) {
        String ambiguities = FileManager.readTextFile(ambiguityFile);
        String name = null;
        String[] hNames = null;
        String aName = null;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            name = line.split("\t")[2].trim();
            if (name.indexOf("+") != -1) {
                if (ambiguities.indexOf(name) < 0 && ambiguities.indexOf(aName = String.valueOf((hNames = name.split("\\+"))[1].trim()) + "+" + hNames[0].trim()) > -1) {
                    name = aName;
                }
                if (ambiguities.indexOf(name) > -1) {
                    DiploidAmbigiutyFinder.updateList(name, ambiguitiesList);
                } else {
                    System.out.println("can't find " + name);
                }
            }
            ++n2;
        }
    }

    private static void updateList(String name, List<Map<String, Integer>> ambiguitiesList) {
        boolean find = false;
        for (Map<String, Integer> map : ambiguitiesList) {
            if (!map.containsKey(name)) continue;
            map.put(name, map.get(name) + 1);
            find = true;
        }
        if (!find) {
            System.out.println("error in finding " + name);
        }
    }

    private static List<Map<String, Integer>> initAmbiguitiesList(String[] ambiguities) {
        ArrayList<Map<String, Integer>> ambiguitiesList = new ArrayList<Map<String, Integer>>();
        HashMap<String, Integer> map = null;
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String ambiguity = stringArray[n2];
            map = new HashMap<String, Integer>();
            String[] stringArray2 = items = ambiguity.split(",");
            int n3 = items.length;
            int n4 = 0;
            while (n4 < n3) {
                String item = stringArray2[n4];
                if (item.trim().length() > 0) {
                    map.put(item.trim(), 0);
                }
                ++n4;
            }
            ambiguitiesList.add(map);
            ++n2;
        }
        return ambiguitiesList;
    }

    private static void checkDataNames(String[] data, Map<String, String> sequenceMap, Map<String, List> symbolMap) {
        String name = null;
        String[] hNames = null;
        String aName = null;
        int i = 1;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            name = line.split("\t")[2];
            String[] stringArray2 = hNames = name.split("\\+");
            int n3 = hNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String hName = stringArray2[n4];
                aName = hName.split("\\*")[1];
                if (!sequenceMap.containsKey(aName) && !symbolMap.containsKey(aName)) {
                    System.out.println("correct name " + aName + " at line " + i);
                }
                ++n4;
            }
            ++i;
            ++n2;
        }
    }

    public static Map<String, List> parseSymbolFile(File symbolFile, String type) {
        HashMap<String, List> symbolMap = new HashMap<String, List>();
        String[] lines = FileManager.readTextFile(symbolFile).split("\n");
        String[] info = null;
        ArrayList<String> list = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            info = line.trim().split(",");
            if (info[0].startsWith(type)) {
                list = new ArrayList<String>();
                int i = 1;
                while (i < info.length) {
                    if (info[i].trim().startsWith(type)) {
                        list.add(info[i].trim().split("\\*")[1]);
                    }
                    ++i;
                }
                symbolMap.put(info[0].trim().split("\\*")[1], list);
            }
            ++n2;
        }
        return symbolMap;
    }
}

