/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class DetectKirGeneContent {
    private static final String N_READ_RESULT = "?";
    private static final String PRESENT_AND_POSITIVE_RESULT = "p+";
    private static final String PRESENT_AND_NEGATIVE_RESULT = "p-";
    private static final String ABSENT_RESULT = "n";
    private static final String PRESENT_RESULT = "p";

    public static void main(String[] args) throws Exception {
        File amp_pos_list = new File(args[0]);
        File outputRoot = new File(args[1]);
        File resultFile = new File(args[2]);
        String[] amp_positions = FileManager.readTextFile(amp_pos_list).split("\n");
        String[] items = null;
        String amplicon_name = null;
        List<String> positions = null;
        File snpFile = null;
        LinkedHashMap<String, Map<String, String>> resultMap = new LinkedHashMap<String, Map<String, String>>();
        ArrayList<String> amplicons = new ArrayList<String>();
        String[] stringArray = amp_positions;
        int n = amp_positions.length;
        int n2 = 0;
        while (n2 < n) {
            String amp_position = stringArray[n2];
            items = amp_position.split("\t");
            amplicon_name = items[0].trim();
            positions = DetectKirGeneContent.getPositions(items[1].trim());
            snpFile = new File(outputRoot, String.valueOf(amplicon_name) + ".txt");
            DetectKirGeneContent.populateResult(resultMap, snpFile, positions);
            amplicons.add(amplicon_name);
            ++n2;
        }
        System.out.println(resultMap.size());
        FileManager.writeTextFile(resultFile, DetectKirGeneContent.formatResult(resultMap, amplicons), true);
    }

    private static String formatResult(Map<String, Map<String, String>> resultMap, List<String> amplicons) {
        StringBuilder content = new StringBuilder();
        StringBuilder header = new StringBuilder();
        header.append("CellLine/Amplicon").append("\t");
        for (String amplicon : amplicons) {
            header.append(amplicon).append("\t");
        }
        content.append(header.toString().trim()).append("\n");
        StringBuilder thisLine = null;
        Map<String, String> amp_result = null;
        for (String cellLine : resultMap.keySet()) {
            thisLine = new StringBuilder();
            thisLine.append(cellLine).append("\t");
            amp_result = resultMap.get(cellLine);
            for (String amplicon : amplicons) {
                if (amp_result.containsKey(amplicon)) {
                    thisLine.append(amp_result.get(amplicon)).append("\t");
                    continue;
                }
                thisLine.append(ABSENT_RESULT).append("\t");
            }
            content.append(thisLine.toString().trim()).append("\n");
        }
        return content.toString();
    }

    private static int findPositionIndex(String header, String poistion) {
        String[] items = header.split("\t");
        int i = 1;
        while (i < items.length) {
            if (items[i].trim().split(":")[0].equals(poistion)) {
                return i;
            }
            ++i;
        }
        System.out.println(String.valueOf(header) + "\n" + poistion);
        return -1;
    }

    private static void populateResult(Map<String, Map<String, String>> resultMap, File snpFile, List<String> positions) {
        String[] data = FileManager.readTextFile(snpFile).split("\n");
        String[] items = null;
        String cellLine = null;
        String allele = null;
        for (String pos : positions) {
            System.out.println(pos);
            if (pos.equals("0")) {
                int i = 3;
                while (i < data.length) {
                    items = data[i].trim().split("\t");
                    cellLine = items[0].trim();
                    if (!resultMap.containsKey(cellLine)) {
                        resultMap.put(cellLine, new HashMap());
                    }
                    int count = 0;
                    int j = 1;
                    while (j < items.length) {
                        if (items[j].charAt(0) != 'N' && ++count >= 2) {
                            resultMap.get(cellLine).put(snpFile.getName().split("\\.")[0], PRESENT_RESULT);
                            break;
                        }
                        resultMap.get(cellLine).put(snpFile.getName().split("\\.")[0], ABSENT_RESULT);
                        ++j;
                    }
                    ++i;
                }
                break;
            }
            allele = pos.split("-")[1].trim();
            int index = DetectKirGeneContent.findPositionIndex(data[0], pos.split("-")[0]);
            int i = 3;
            while (i < data.length) {
                items = data[i].split("\t");
                cellLine = items[0].trim();
                if (!resultMap.containsKey(cellLine)) {
                    resultMap.put(cellLine, new HashMap());
                }
                String answer = "";
                if (resultMap.get(cellLine).containsKey(snpFile.getName().split("\\.")[0])) {
                    answer = resultMap.get(cellLine).get(snpFile.getName().split("\\.")[0]);
                }
                if (snpFile.getName().indexOf("3DS1") > -1 && cellLine.equals("HIP00101") && pos.equals("157-T")) {
                    System.out.println(String.valueOf(items[index]) + " " + allele);
                }
                answer = items[index].charAt(0) == 'N' ? String.valueOf(answer) + N_READ_RESULT : (items[index].indexOf(allele) > -1 ? String.valueOf(answer) + PRESENT_AND_POSITIVE_RESULT : String.valueOf(answer) + PRESENT_AND_NEGATIVE_RESULT);
                resultMap.get(cellLine).put(snpFile.getName().split("\\.")[0], answer);
                ++i;
            }
        }
    }

    private static List<String> getPositions(String data) {
        String[] entries;
        ArrayList<String> positions = new ArrayList<String>();
        if (data.equals("NA")) {
            positions.add("0");
            return positions;
        }
        String[] stringArray = entries = data.split("\\s+");
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            String position = stringArray[n2];
            positions.add(position);
            ++n2;
        }
        return positions;
    }
}

