/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.IOException;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.OsHelper;
import misc.SnpConfig;

public class CustomCrossMatch {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private LogUtil crossMatchLog;
    private SnpConfig snpConfig;

    public CustomCrossMatch(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.crossMatchLog = new LogUtil(FileHelper.CROSS_MATCH_LOG);
        this.snpConfig = new SnpConfig();
    }

    public void runCrossMatch() throws IOException {
        System.out.println("\tcross match...");
        this.crossMatchLog.enter("<Script CustomCrossMatch>\n");
        String snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        String fastaTrimFile = FileHelper.fastaTrimFile(snpDataDir);
        this.crossMatchLog.add("Correct Backbone File Format...\n");
        FileHandler.fastaCorrect(this.backbone);
        String cmd = "/genome/bin/cross_match -gap_init " + this.config.getGapInitPenalty() + " " + fastaTrimFile + " " + this.backbone + " -discrep_lists";
        String data = OsHelper.excuteCommand(cmd);
        this.crossMatchLog.add(String.valueOf(cmd) + "\n");
        this.crossMatchLog.add(data);
        this.crossMatchLog.exit("</Script CustomCrossMatch>\n");
        this.crossMatchLog.write(snpDataDir);
    }
}

