/*
 * Decompiled with CFR 0.152.
 */
package misc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileHandler;
import misc.FileHelper;
import misc.LogUtil;
import misc.SnpCommon;
import misc.SnpConfig;
import misc.StringUtils;

public class CellLineMerge {
    private String chromatDir;
    private String backbone;
    private String outputDir;
    private SnpConfig config;
    private LogUtil log;
    private FileHandler handler;
    private LogUtil snpMergeLog;
    private String snpDataDir;
    private String rawFile;
    private String rawClFile;
    private String polyDir;
    private Map fastaDic;
    private Map qualDic;
    private List cellLineList;
    private List homoClList;
    private List posList;
    private Map chrToClMap;
    private Map callDic;

    public CellLineMerge(String chrDir, String fn, String outDir, SnpConfig conf, LogUtil mainLog) {
        this.chromatDir = chrDir;
        this.backbone = fn;
        this.outputDir = outDir;
        this.config = conf;
        this.log = mainLog;
        this.handler = new FileHandler();
        this.snpMergeLog = new LogUtil(FileHelper.SNP_MERGE_LOG);
        this.cellLineList = new ArrayList();
        this.homoClList = new ArrayList();
        this.posList = new ArrayList();
        this.chrToClMap = new HashMap();
        this.callDic = new HashMap();
    }

    public void MergeCellLine() throws IOException {
        System.out.println("\tMerge Cell Lines...");
        this.snpMergeLog.enter("<Script MergeCellLine>\n");
        this.snpDataDir = FileHelper.snpDataDir(this.outputDir, this.chromatDir);
        this.polyDir = FileHelper.polyDir(this.outputDir, this.chromatDir, this.config);
        this.rawFile = FileHelper.snpChromatRawDataFile(this.snpDataDir);
        this.rawClFile = FileHelper.snpCellLineRawDataFile(this.snpDataDir);
        String fastaFile = FileHelper.fastaFile(this.snpDataDir);
        this.fastaDic = FileHandler.getAllFasta(fastaFile);
        String qualFile = FileHelper.qualFile(this.snpDataDir);
        this.qualDic = FileHandler.getAllFasta(qualFile);
        this.getAllCellLines();
        if (this.config.isHasHomoFile()) {
            this.homoClList = SnpCommon.getHomoCellLines(this.config.getHomoFilePath());
        }
        this.snpMergeLog.add(String.valueOf(this.cellLineList.size()) + " cell lines: [" + StringUtils.listToString(this.cellLineList) + "]\n");
        this.log.add("<INFO>" + this.cellLineList.size() + "cell lines\n");
        this.processRawFile();
        this.GenerateRawClData();
        this.writeRawClFile();
        this.snpMergeLog.exit("</Script MergeCellLine>\n");
        this.snpMergeLog.write(this.snpDataDir);
    }

    public void writeRawClFile() throws IOException {
        ArrayList<String> data = new ArrayList<String>();
        String header = "BackbonePosition";
        int i = 0;
        while (i < this.posList.size()) {
            header = String.valueOf(header) + "\t" + ((Integer)this.posList.get(i)).toString();
            ++i;
        }
        data.add(String.valueOf(header) + "\n");
        Object[] cls = this.callDic.keySet().toArray();
        Arrays.sort(cls);
        int i2 = 0;
        while (i2 < cls.length) {
            String line = (String)cls[i2];
            Map baseMap = (Map)this.callDic.get(cls[i2]);
            int j = 0;
            while (j < this.posList.size()) {
                line = String.valueOf(line) + "\t" + (String)baseMap.get((Integer)this.posList.get(j));
                ++j;
            }
            data.add(String.valueOf(line) + "\n");
            ++i2;
        }
        this.handler.writeFile(this.rawClFile, data);
    }

    public void GenerateRawClData() throws IOException {
        this.snpMergeLog.enter("<Function GenerateRawClData>\n");
        this.snpMergeLog.add("picking best read for each position each cell line...\n");
        for (String cl : this.chrToClMap.keySet()) {
            List list = (List)this.chrToClMap.get(cl);
            HashMap<Integer, String> baseMap = new HashMap<Integer, String>();
            int i = 0;
            while (i < this.posList.size()) {
                String entry;
                Integer pos = (Integer)this.posList.get(i);
                String allele = "X";
                int qual = -1;
                int chrPos = -1;
                String direction = "X";
                String chr = "X";
                for (String data : list) {
                    entry = data.split("\t")[i + 1];
                    String[] items = entry.split("/");
                    if (qual == -1 && new Integer(items[2]) > -1 && !items[0].equals("N")) {
                        qual = new Integer(items[1]);
                        allele = items[3].equals("F") ? items[0] : StringUtils.revCompSeq(items[0]);
                        chrPos = new Integer(items[2]);
                        direction = items[3];
                        chr = data.split("\t")[0];
                        continue;
                    }
                    if (chrPos <= -1 || new Integer(items[2]) <= -1 || items[0].equals("N") || !this.betterRead(qual, chrPos, direction, chr, new Integer(items[1]), new Integer(items[2]), items[3], data.split("\t")[0], cl)) continue;
                    qual = new Integer(items[1]);
                    allele = items[3].equals("F") ? items[0] : StringUtils.revCompSeq(items[0]);
                    chrPos = new Integer(items[2]);
                    direction = items[3];
                    chr = data.split("\t")[0];
                }
                entry = String.valueOf(allele) + "/" + qual + "/" + chrPos + "/" + direction + "/" + chr;
                baseMap.put(pos, entry);
                ++i;
            }
            this.callDic.put(cl, baseMap);
        }
        this.snpMergeLog.exit("</Function GenerateRawClData>\n");
    }

    public boolean betterRead(int qual1, int chrPos1, String direction1, String chr1, int qual2, int chrPos2, String direction2, String chr2, String cl) throws IOException {
        if (qual1 >= this.config.getQualAssureHomo() && qual2 >= this.config.getQualAssureHomo()) {
            return qual1 < qual2;
        }
        if (qual1 >= this.config.getQualAssureHomo()) {
            return false;
        }
        if (qual2 >= this.config.getQualAssureHomo()) {
            return true;
        }
        boolean passQ1 = this.passQualCutOff(qual1, chrPos1, (String)this.qualDic.get(chr1));
        boolean passQ2 = this.passQualCutOff(qual2, chrPos2, (String)this.qualDic.get(chr2));
        boolean secondBetter = this.checkBetterPeak(qual1, chrPos1, direction1, chr1, qual2, chrPos2, direction2, chr2, cl);
        if (qual1 >= this.config.getQualCutoff() && qual2 >= this.config.getQualCutoff()) {
            if (passQ1 && passQ2) {
                return secondBetter;
            }
            if (passQ1) {
                return false;
            }
            if (passQ2) {
                return true;
            }
            return qual2 > qual1;
        }
        return qual2 > qual1;
    }

    public boolean checkBetterPeak(int qual1, int chrPos1, String direction1, String chr1, int qual2, int chrPos2, String direction2, String chr2, String cl) throws IOException {
        String polyFn1 = new File(new File(this.polyDir), String.valueOf(chr1) + ".poly").getAbsolutePath();
        List polyData1 = this.handler.readFile(polyFn1);
        String polyFn2 = new File(new File(this.polyDir), String.valueOf(chr2) + ".poly").getAbsolutePath();
        List polyData2 = this.handler.readFile(polyFn2);
        String[] data1 = ((String)polyData1.get(chrPos1 + 1)).trim().split("\\s+");
        float firstArea1 = new Float(data1[3]).floatValue();
        float firstArea2 = new Float(data1[7]).floatValue();
        String firstRead1 = data1[0];
        String firstRead2 = data1[4];
        String[] data2 = ((String)polyData2.get(chrPos2 + 1)).trim().split("\\s+");
        float secondArea1 = new Float(data2[3]).floatValue();
        float secondArea2 = new Float(data2[7]).floatValue();
        String secondRead1 = data2[0];
        String secondRead2 = data2[4];
        int[] aveQual1 = SnpCommon.getAveQualAround(chrPos1, (String)this.qualDic.get(chr1), 4);
        int[] aveQual2 = SnpCommon.getAveQualAround(chrPos2, (String)this.qualDic.get(chr2), 4);
        if (direction1.equals("R")) {
            firstRead1 = StringUtils.revCompSeq(firstRead1);
            firstRead2 = StringUtils.revCompSeq(firstRead2);
        }
        if (direction2.equals("R")) {
            secondRead1 = StringUtils.revCompSeq(secondRead1);
            secondRead2 = StringUtils.revCompSeq(secondRead2);
        }
        if (this.homoClList.contains(cl)) {
            if (firstRead1.equals(secondRead1)) {
                return firstArea2 > secondArea2;
            }
            return aveQual1[0] + aveQual1[1] <= aveQual2[0] + aveQual2[1];
        }
        if (firstRead2.equals("N") && secondRead2.equals("N")) {
            return qual2 > qual1;
        }
        if (!firstRead2.equals("N") && !secondRead2.equals("N")) {
            if (this.sameReads(firstRead1, firstRead2, secondRead1, secondRead2)) {
                return !(firstArea2 > secondArea2);
            }
            return qual2 > qual1;
        }
        if (!firstRead2.equals("N")) {
            if (qual2 >= this.config.getQualAssure() || (double)secondArea1 > 0.5 && (double)firstArea2 < 0.2) {
                return true;
            }
            if ((double)firstArea2 >= 0.2) {
                return false;
            }
            return qual2 > qual1;
        }
        if (qual1 >= this.config.getQualAssure() || (double)firstArea1 > 0.5 && (double)secondArea2 < 0.2) {
            return false;
        }
        if ((double)secondArea2 >= 0.2) {
            return true;
        }
        return qual2 > qual1;
    }

    public boolean sameReads(String r1, String r2, String s1, String s2) {
        if (r1.equals(s1) && r2.equals(s2)) {
            return true;
        }
        return r1.equals(s2) && r2.equals(s2);
    }

    public boolean passQualCutOff(int qual, int chrPos, String quals) {
        int[] aveQual = SnpCommon.getAveQualAround(chrPos, quals, 4);
        int[] aveQual3 = SnpCommon.getAveQualAround3(chrPos, quals, 4);
        return aveQual[0] > this.config.getQualAroundCutoff() && aveQual[1] > this.config.getQualAroundCutoff() || qual > this.config.getQualAroundCutoffHigh() && (aveQual[0] > this.config.getQualAroundCutoffHigh() || aveQual[1] > this.config.getQualAroundCutoffHigh()) || aveQual[0] > this.config.getQualAssure() || aveQual[1] > this.config.getQualAssure() || aveQual3[0] > this.config.getQualAssure() || aveQual3[1] > this.config.getQualAssure();
    }

    public void processRawFile() throws IOException {
        this.snpMergeLog.enter("<Function ProcessRawFile>\n");
        this.snpMergeLog.add("Read raw file ... \n");
        List data = this.handler.readFile(this.rawFile);
        this.chromatToCellLineMap(data);
        this.snpMergeLog.exit("</Function ProcessRawFile>\n");
    }

    public void chromatToCellLineMap(List data) throws IOException {
        String chr;
        List<String> list;
        for (String cl : this.cellLineList) {
            list = new ArrayList();
            this.chrToClMap.put(cl, list);
        }
        String[] pos = ((String)data.get(0)).split("\t");
        int i = 1;
        while (i < pos.length) {
            this.posList.add(new Integer(pos[i]));
            ++i;
        }
        i = 1;
        while (i < data.size()) {
            String cl;
            String line = (String)data.get(i);
            chr = line.split("\t")[0];
            cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
            list = (List)this.chrToClMap.get(cl);
            list.add(line);
            ++i;
        }
        this.snpMergeLog.add("chromat to cell line map: \n");
        for (String cl : this.cellLineList) {
            this.snpMergeLog.add("\t" + cl + " : ");
            list = (List)this.chrToClMap.get(cl);
            for (String line : list) {
                chr = line.split("\t")[0];
                this.snpMergeLog.add(String.valueOf(chr) + ",");
            }
            this.snpMergeLog.add("\n");
        }
    }

    public void getAllCellLines() {
        for (String chr : this.fastaDic.keySet()) {
            String cl = chr.split(this.config.getDelimeter())[this.config.getCellLinePos()];
            if (this.cellLineList.contains(cl)) continue;
            this.cellLineList.add(cl);
        }
    }
}

