/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kirTyping.GeneCopy;
import kirTyping.ResolveGeneContent;
import misc.FileManager;

public class ResolveGeneContentByRatio {
    private static final String _2DS3 = "2DS3";
    private static final String _2DS5 = "2DS5";
    private static final String _2DS35_005_2DS1_2DS3_CSV = "2DS35-005-2DS1-2DS3.txt";
    private static final String KIR_2DL2_N1_CSV = "KIR-2DL2-N1.txt";
    private static final String _2DL3_006_CSV = "2DL3-006.txt";
    private static final String _2DL2_001_2DP1_CSV = "2DL2-001-2DP1.txt";
    private static final String _2DP1_CSV = "2DP1.txt";
    private static final String _2DS2_3DL2_CSV = "2DS2-3DL2.txt";
    private static final String _2DL5_CSV = "2DL5.txt";
    private static final String _2DS23_2DP1_CSV = "2DS23-2DP1.txt";
    private static final String _2DL2_001_2DS2_CSV = "2DL2-001-2DS2.txt";
    private static final String _2DS1_4_002_CSV = "2DS1-4-002.txt";
    private static final String _3DL1_005_CSV = "3DL1-005.txt";
    private static final String _2DL23_CSV = "2DL23.txt";
    private static final String UNKNOWN_RESULT = "?";
    private static final String[] GENES = new String[]{"2DL1", "2DL2", "2DL3", "2DL4", "2DL5", "2DP1", "2DS1", "2DS2", "2DS4", "2DS3", "2DS5", "2DS3/5", "3DL1", "3DS1", "3DP1", "3DL2", "3DL3"};
    private static final Object _2DS35_005_2DS3_2DS5_CSV = "2DS35-005-2DS3-2DS5.txt";

    public static void main(String[] args) throws Exception {
        File cellLineTypeFile = new File(args[0]);
        File geneContentFile = new File(args[1]);
        File ambiguityFile = new File(args[2]);
        File symbolFile = new File(args[3]);
        File geneCopyDir = new File(args[4]);
        File resultFile = new File(args[5]);
        boolean filterMutation = new Boolean(args[6]);
        boolean merge = new Boolean(args[7]);
        Map<String, String> geneContentMap = ResolveGeneContent.parseGeneContent(geneContentFile);
        Map<String, String> geneSymbolMap = ResolveGeneContent.parseGeneSymbol(symbolFile);
        String[] ambiguities = FileManager.readTextFile(ambiguityFile).split("\n");
        String[] cellLineTypes = FileManager.readTextFile(cellLineTypeFile).split("\n");
        Map<String, Map<String, String>> geneCopies = ResolveGeneContentByRatio.parseGeneCopies(geneCopyDir);
        StringBuilder builder = new StringBuilder();
        ResolveGeneContentByRatio.constructHeader(builder);
        String[] stringArray = cellLineTypes;
        int n = cellLineTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\t");
            System.out.println("------------" + items[0].trim());
            if (items[1].trim().equalsIgnoreCase("Unknown")) {
                builder.append(line.trim()).append("\t").append("\n");
            } else if (items[2].trim().equalsIgnoreCase("FALSE")) {
                builder.append(items[0].trim()).append("\t").append(items[1].trim()).append("\t").append("0").append("\t").append(items[1].trim()).append("\t");
                HashMap<String, GeneCopy> copy2DS35 = new HashMap<String, GeneCopy>();
                ResolveGeneContentByRatio.constructGeneCopies(items[1].trim(), geneContentMap, geneSymbolMap, builder, copy2DS35);
                builder.append("\n");
            } else {
                builder.append(items[0].trim()).append("\t");
                ResolveGeneContentByRatio.constructGeneCopiesByRatio(items[0].trim(), items[1].trim(), geneContentMap, geneSymbolMap, geneCopies, ambiguities, merge, filterMutation, builder);
                builder.append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(resultFile, builder.toString(), true);
    }

    private static void constructGeneCopiesByRatio(String cellLine, String type, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, Map<String, Map<String, String>> geneCopies, String[] ambiguities, boolean merge, boolean filterMutation, StringBuilder builder) {
        String level2DL12DS12DS4Info = null;
        String level2Info = null;
        String level3Info = null;
        String level2DL232DP1Info = null;
        String level2DP1Info = null;
        String level2DL23Info = null;
        String level2DS23DL2Info = null;
        String level2DS232DP1Info = null;
        String level2DL232DS2Info = null;
        String level2DS352DL3Info = null;
        String level2DS22DP1Info = null;
        String level2DS12DS3Info = null;
        String level2DS32DS5Info = null;
        String level3DL13DS1Info = null;
        if (geneCopies.containsKey(_2DS1_4_002_CSV)) {
            System.out.println("using 2DS1-4-002 info");
            level2DL12DS12DS4Info = geneCopies.get(_2DS1_4_002_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_3DL1_005_CSV)) {
            System.out.println("using 3DL1-005 info");
            level3DL13DS1Info = geneCopies.get(_3DL1_005_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DL5_CSV)) {
            System.out.println("using 2DL5 info");
            level2Info = geneCopies.get(_2DL5_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DS35_005_2DS1_2DS3_CSV) && geneCopies.containsKey(_2DS35_005_2DS3_2DS5_CSV)) {
            System.out.println("using 2DS35 info");
            level2DS12DS3Info = geneCopies.get(_2DS35_005_2DS1_2DS3_CSV).get(cellLine);
            level2DS32DS5Info = geneCopies.get(_2DS35_005_2DS3_2DS5_CSV).get(cellLine);
            if (level2DS12DS3Info != null) {
                // empty if block
            }
        }
        if (geneCopies.containsKey(_2DL2_001_2DP1_CSV)) {
            level2DL232DP1Info = geneCopies.get(_2DL2_001_2DP1_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DP1_CSV)) {
            System.out.println("using 2DP1 info");
            level2DP1Info = geneCopies.get(_2DP1_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DS2_3DL2_CSV)) {
            System.out.println("using 2DS2:3DL2 info");
            level2DS23DL2Info = geneCopies.get(_2DS2_3DL2_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DL23_CSV)) {
            System.out.println("using 2DL23 info");
            level2DL23Info = geneCopies.get(_2DL23_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DS23_2DP1_CSV)) {
            level2DS232DP1Info = geneCopies.get(_2DS23_2DP1_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DL2_001_2DS2_CSV)) {
            level2DL232DS2Info = geneCopies.get(_2DL2_001_2DS2_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(_2DL3_006_CSV)) {
            level2DS352DL3Info = geneCopies.get(_2DL3_006_CSV).get(cellLine);
        }
        if (geneCopies.containsKey(KIR_2DL2_N1_CSV)) {
            level2DS22DP1Info = geneCopies.get(KIR_2DL2_N1_CSV).get(cellLine);
        }
        String ambiguity = ResolveGeneContentByRatio.getThisAmbiguity(type, ambiguities);
        System.out.println(">>>>" + ambiguity);
        String[] pairs = ambiguity.trim().split("\t");
        HashMap<String, GeneCopy> copy2DS35 = new HashMap<String, GeneCopy>();
        ArrayList<String> possibleTypes = new ArrayList<String>();
        int i = 0;
        while (i < pairs.length) {
            String pair1 = pairs[i];
            Map<String, Integer> map1 = ResolveGeneContentByRatio.getGeneCopyMap(pair1, geneContentMap);
            Map<String, Integer> map2 = ResolveGeneContentByRatio.covertKey(map1, geneSymbolMap);
            boolean isPossible2DL12DS12DS4 = ResolveGeneContentByRatio.isPossibleByLevel1(map2, level2DL12DS12DS4Info);
            boolean isPossible3DL13DS1 = ResolveGeneContentByRatio.isPossibleByLevel3DL13DS1(map2, level3DL13DS1Info);
            boolean isPossible2 = ResolveGeneContentByRatio.isPossibleByLevel2(map2, level2Info);
            boolean isPossible3 = ResolveGeneContentByRatio.isPossibleByLevel3(map2, level3Info);
            boolean isPossible2DS35 = ResolveGeneContentByRatio.isPossibleByLevel2DS35(map2, level2DS12DS3Info, level2DS32DS5Info, level2DS352DL3Info, copy2DS35);
            boolean isPossible2DL232DP1 = ResolveGeneContentByRatio.isPossibleBy2DL232DP1(map2, level2DL232DP1Info);
            boolean isPossible2DP1 = ResolveGeneContentByRatio.isPossibleBy2DP1(map2, level2DP1Info);
            boolean isPossible2DS23DL2 = ResolveGeneContentByRatio.isPossibleBy2DS23DL2(map2, level2DS23DL2Info);
            boolean isPossible2DL23 = ResolveGeneContentByRatio.isPossibleBy2DL23(map2, level2DL23Info);
            boolean isPossible2DS232DP1 = ResolveGeneContentByRatio.isPossibleBy2DS232DP1(map2, level2DS232DP1Info);
            boolean isPossible2DL232DS2 = ResolveGeneContentByRatio.isPossibleBy2DL232DS2(map2, level2DL232DS2Info);
            boolean isPossible2DS352DL3 = ResolveGeneContentByRatio.isPossibleBy2DS352DL3(map2, level2DS352DL3Info);
            boolean isPossible2DS22DP1 = ResolveGeneContentByRatio.isPossibleBy2DS22DP1(map2, level2DS22DP1Info);
            System.out.println(String.valueOf(pair1) + " " + isPossible2DL12DS12DS4 + " " + isPossible2 + " " + isPossible3 + " " + isPossible2DS35 + " " + isPossible2DL232DP1 + " " + isPossible2DL232DS2 + " " + isPossible2DS352DL3 + " " + isPossible2DS22DP1 + " " + isPossible3DL13DS1);
            if (isPossible2DL12DS12DS4 && isPossible2 && isPossible3 && isPossible2DS35 && isPossible2DL232DP1 && isPossible2DL232DS2 && isPossible2DS352DL3 && isPossible2DS22DP1 && isPossible3DL13DS1 && isPossible2DP1 && isPossible2DS23DL2 && isPossible2DL23 && isPossible2DS232DP1) {
                possibleTypes.add(pair1);
            }
            ++i;
        }
        ResolveGeneContentByRatio.appendToOutput(possibleTypes, geneContentMap, geneSymbolMap, merge, filterMutation, copy2DS35, builder);
    }

    private static boolean isPossibleBy2DS22DP1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2dS2 = map2.get("2DS2") == null ? 0 : map2.get("2DS2");
        int num2dP1 = map2.get("2DP1") == null ? 0 : map2.get("2DP1");
        String[] ratio = info.trim().split(":");
        String this2ds2 = ratio[0];
        String this2dP1 = ratio[1];
        if (this2ds2.equals("n") || this2ds2.equals(UNKNOWN_RESULT) || this2dP1.equals("n") || this2dP1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        if (this2dP1.equals("0") || num2dP1 == 0) {
            if (Integer.valueOf(this2ds2) != num2dS2 || Integer.valueOf(this2dP1) != num2dP1) {
                System.out.println("2DS2/2DP1 diff " + info.trim() + " != " + num2dS2 + ":" + num2dP1);
                return false;
            }
            return true;
        }
        double ratio1 = num2dS2 / num2dP1;
        double ratio2 = Double.valueOf(this2ds2) / Double.valueOf(this2dP1);
        if (ratio1 == ratio2 || num2dS2 == Integer.valueOf(this2ds2) && num2dP1 == Integer.valueOf(this2dP1)) {
            System.out.println("2DS2/2DP1 same " + info.trim() + " == " + num2dS2 + ":" + num2dP1);
            return true;
        }
        if (ratio1 >= 2.0 && ratio2 >= 2.0) {
            System.out.println("2DS2/2DP1 same " + info.trim() + " == " + num2dS2 + ":" + num2dP1);
            return true;
        }
        System.out.println("2DS2/2DP1 diff " + info.trim() + " != " + num2dS2 + ":" + num2dP1);
        return false;
    }

    private static boolean isPossibleBy2DS352DL3(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2dS35 = map2.get("2DS3/5") == null ? 0 : map2.get("2DS3/5");
        int num2dl3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        String[] ratio = info.trim().split(":");
        String this2ds35 = ratio[0];
        String this2dl3 = ratio[1];
        if (num2dS35 == 0 || num2dl3 == 0 || this2ds35.equals("0") || this2dl3.equals("0")) {
            return true;
        }
        if (this2ds35.equals("n") || this2ds35.equals(UNKNOWN_RESULT) || this2dl3.equals("n") || this2dl3.equals(UNKNOWN_RESULT)) {
            return true;
        }
        double ratio1 = num2dS35 / num2dl3;
        double ratio2 = Double.valueOf(this2ds35) / Double.valueOf(this2dl3);
        if (ratio1 == ratio2 || num2dS35 == Integer.valueOf(this2ds35) && num2dl3 == Integer.valueOf(this2dl3)) {
            System.out.println("aaaa same " + info.trim() + " == " + num2dS35 + ":" + num2dl3);
            return true;
        }
        System.out.println("2DS3/5:2DL3 diff " + info.trim() + " != " + num2dS35 + ":" + num2dl3);
        return false;
    }

    private static boolean isPossibleBy2DL232DS2(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2ds2 = map2.get("2DS2") == null ? 0 : map2.get("2DS2");
        int num2dl2 = map2.get("2DL2") == null ? 0 : map2.get("2DL2");
        int num2dl3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        int numTotal = num2dl2 + num2dl3;
        String[] ratio = info.trim().split(":");
        String thisSum = ratio[0];
        String this2ds2 = ratio[1];
        if (num2ds2 == 0 || this2ds2.equals("0")) {
            if (!this2ds2.equals(String.valueOf(num2ds2))) {
                System.out.println("false negative site in 2DL2-001 for 2ds2 ");
            }
            return true;
        }
        if (thisSum.equals("n") || thisSum.equals(UNKNOWN_RESULT) || this2ds2.equals("n") || this2ds2.equals(UNKNOWN_RESULT)) {
            return true;
        }
        double ratio1 = numTotal / num2ds2;
        double ratio2 = Double.valueOf(thisSum) / Double.valueOf(this2ds2);
        if (ratio1 == ratio2 || numTotal == Integer.valueOf(thisSum) && num2ds2 == Integer.valueOf(this2ds2)) {
            System.out.println("(2DL2+2DL3):2DS2 same " + info.trim() + " == " + numTotal + ":" + num2ds2);
            return true;
        }
        System.out.println("2DL2+2DL3):2DS2 diff " + info.trim() + " != " + numTotal + ":" + num2ds2);
        return false;
    }

    private static boolean isPossibleBy2DS23DL2(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2DS2 = map2.get("2DS2") == null ? 0 : map2.get("2DS2");
        int num3DL2 = map2.get("3DL2") == null ? 0 : map2.get("3DL2");
        String[] ratio = info.trim().split(":");
        String this2ds2 = ratio[0];
        String this3dl2 = ratio[1];
        if (this2ds2.equals("n") || this2ds2.equals(UNKNOWN_RESULT) || this3dl2.equals("n") || this3dl2.equals(UNKNOWN_RESULT)) {
            return true;
        }
        return num2DS2 == Integer.valueOf(this2ds2) && num3DL2 == Integer.valueOf(this3dl2);
    }

    private static boolean isPossibleBy2DP1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2DP1 = map2.get("2DP1") == null ? 0 : map2.get("2DP1");
        int num3DP1 = map2.get("3DP1") == null ? 0 : map2.get("3DP1");
        String[] ratio = info.trim().split(":");
        String this2dp1 = ratio[0];
        String this3dp1 = ratio[1];
        if (this2dp1.equals("n") || this2dp1.equals(UNKNOWN_RESULT) || this3dp1.equals("n") || this3dp1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        double ratio1 = num2DP1 / num3DP1;
        double ratio2 = Double.valueOf(this2dp1) / Double.valueOf(this3dp1);
        return ratio1 == ratio2 || num2DP1 == Integer.valueOf(this2dp1) && num3DP1 == Integer.valueOf(this3dp1);
    }

    private static boolean isPossibleBy2DL23(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2DL2 = map2.get("2DL2") == null ? 0 : map2.get("2DL2");
        int num2DL3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        String[] ratio = info.trim().split(":");
        String this2dl2 = ratio[0];
        String this2dl3 = ratio[1];
        if (this2dl2.equals("n") || this2dl2.equals(UNKNOWN_RESULT) || this2dl3.equals("n") || this2dl3.equals(UNKNOWN_RESULT)) {
            return true;
        }
        return num2DL2 == Integer.valueOf(this2dl2) && num2DL3 == Integer.valueOf(this2dl3);
    }

    private static boolean isPossibleBy2DS232DP1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2dl2 = map2.get("2DL2") == null ? 0 : map2.get("2DL2");
        int num2dl3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        int num2dp1 = map2.get("2DP1") == null ? 0 : map2.get("2DP1");
        int numTotal = num2dl2 + num2dl3;
        String[] ratio = info.trim().split(":");
        String thisSum = ratio[0];
        String this2dp1 = ratio[1];
        if (num2dp1 == 0 || this2dp1.equals("0")) {
            if (!this2dp1.equals(String.valueOf(num2dp1))) {
                System.out.println("false negative site in 2DL2-001 for 2dp1 ");
            }
            return true;
        }
        if (thisSum.equals("n") || thisSum.equals(UNKNOWN_RESULT) || this2dp1.equals("n") || this2dp1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        double ratio1 = numTotal / num2dp1;
        double ratio2 = Double.valueOf(thisSum) / Double.valueOf(this2dp1);
        if (ratio1 == ratio2 || numTotal == Integer.valueOf(thisSum) && num2dp1 == Integer.valueOf(this2dp1)) {
            System.out.println("(2DL2+2DL3):2DP1 same " + info.trim() + " == " + numTotal + ":" + num2dp1);
            return true;
        }
        System.out.println("(2DL2+2DL3):2DP1 diff " + info.trim() + " != " + numTotal + ":" + num2dp1);
        return false;
    }

    private static boolean isPossibleBy2DL232DP1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2dl2 = map2.get("2DL2") == null ? 0 : map2.get("2DL2");
        int num2dl3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        int num2ds2 = map2.get("2DS2") == null ? 0 : map2.get("2DS2");
        int num2dp1 = map2.get("2DP1") == null ? 0 : map2.get("2DP1");
        int numTotal = num2dl2 + num2dl3 + num2ds2;
        String[] ratio = info.trim().split(":");
        String thisSum = ratio[0];
        String this2dp1 = ratio[1];
        if (num2dp1 == 0 || this2dp1.equals("0")) {
            if (!this2dp1.equals(String.valueOf(num2dp1))) {
                System.out.println("false negative site in 2DL2-001 for 2dp1 ");
            }
            return true;
        }
        if (thisSum.equals("n") || thisSum.equals(UNKNOWN_RESULT) || this2dp1.equals("n") || this2dp1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        double ratio1 = numTotal / num2dp1;
        double ratio2 = Double.valueOf(thisSum) / Double.valueOf(this2dp1);
        if (ratio1 == ratio2 || numTotal == Integer.valueOf(thisSum) && num2dp1 == Integer.valueOf(this2dp1)) {
            System.out.println("(2DL2+2DL3+2DS2):2DP1 same " + info.trim() + " == " + numTotal + ":" + num2dp1);
            return true;
        }
        System.out.println("(2DL2+2DL3+2DS2):2DP1 diff " + info.trim() + " != " + numTotal + ":" + num2dp1);
        return false;
    }

    private static boolean isPossibleByLevel2DS35(Map<String, Integer> map2, String level2DS12DS3Info, String level2DS32DS5Info, String level2DS352DL3Info, Map<String, GeneCopy> copy2DS35) {
        if (level2DS12DS3Info == null || level2DS32DS5Info == null) {
            return true;
        }
        level2DS12DS3Info = level2DS12DS3Info.trim();
        level2DS32DS5Info = level2DS32DS5Info.trim();
        int num2ds35 = map2.get("2DS3/5") == null ? 0 : map2.get("2DS3/5");
        int num2ds1 = map2.get("2DS1") == null ? 0 : map2.get("2DS1");
        int num2dl3 = map2.get("2DL3") == null ? 0 : map2.get("2DL3");
        String[] ratio2DS12DS3 = level2DS12DS3Info.trim().split(":");
        String[] ratio2DS32DS5 = level2DS32DS5Info.trim().split(":");
        String this2ds1 = ratio2DS12DS3[0];
        String this2ds3 = ratio2DS12DS3[1];
        String that2ds3 = ratio2DS32DS5[0];
        String that2ds5 = ratio2DS32DS5[1];
        String this2ds35 = "n";
        String this2dl3 = "n";
        GeneCopy geneCopy = null;
        if (level2DS352DL3Info != null) {
            this2ds35 = level2DS352DL3Info.trim().split(":")[0];
            this2dl3 = level2DS352DL3Info.trim().split(":")[1];
        }
        int firm3 = -1;
        int firm5 = -1;
        if (that2ds3.equals("n")) {
            geneCopy = new GeneCopy(_2DS3);
            geneCopy.setNumCopy(1);
            geneCopy.setFirm(false);
            copy2DS35.put(_2DS3, geneCopy);
        }
        if (that2ds5.equals("n")) {
            geneCopy = new GeneCopy(_2DS5);
            geneCopy.setNumCopy(1);
            geneCopy.setFirm(false);
            copy2DS35.put(_2DS5, geneCopy);
        }
        if (!that2ds3.equals(UNKNOWN_RESULT) && !that2ds3.equals("n")) {
            geneCopy = new GeneCopy(_2DS3);
            geneCopy.setNumCopy(Integer.valueOf(that2ds3));
            geneCopy.setFirm(true);
            copy2DS35.put(_2DS3, geneCopy);
            firm3 = Integer.valueOf(that2ds3);
        }
        if (!that2ds5.equals(UNKNOWN_RESULT) && !that2ds5.equals("n")) {
            geneCopy = new GeneCopy(_2DS5);
            geneCopy.setNumCopy(Integer.valueOf(that2ds5));
            geneCopy.setFirm(true);
            copy2DS35.put(_2DS5, geneCopy);
            firm5 = Integer.valueOf(that2ds5);
        }
        if (firm3 >= 0 & firm5 >= 0) {
            if (num2ds35 != firm3 + firm5) {
                System.out.println("different 2DS35 2DS3=" + firm3 + " 2DS5=" + firm5 + " different than " + num2ds35);
                return false;
            }
            System.out.println("same 2DS35 2DS3=" + firm3 + " 2DS5=" + firm5 + " same as " + num2ds35);
        }
        return true;
    }

    private static void appendToOutput(List<String> possibleTypes, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, boolean merge, boolean filterMutation, Map<String, GeneCopy> copy2DS35, StringBuilder builder) {
        if (filterMutation && possibleTypes.size() > 0) {
            ResolveGeneContentByRatio.filterMutationTypes(possibleTypes);
        }
        int ambiguity = -1;
        if (possibleTypes.size() == 0) {
            builder.append(UNKNOWN_RESULT).append("\t");
            return;
        }
        if (possibleTypes.size() == 1) {
            builder.append(possibleTypes.get(0)).append("\t");
            ambiguity = 0;
        } else {
            for (String type : possibleTypes) {
                builder.append(type).append("/");
            }
            builder.append("\t");
        }
        boolean isAmbCopy = false;
        String copies = null;
        StringBuilder copyBuilder = new StringBuilder();
        String[] stringArray = GENES;
        int n = GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            copies = ResolveGeneContentByRatio.getPossibleCopies(possibleTypes, geneContentMap, geneSymbolMap, gene, copy2DS35);
            copyBuilder.append(copies).append("\t");
            if (copies.indexOf("(") > 0) {
                isAmbCopy = true;
            }
            ++n2;
        }
        if (ambiguity == 0) {
            builder.append(ambiguity).append("\t").append(possibleTypes.get(0)).append("\t").append(copyBuilder.toString().trim());
        } else {
            String mostCommonType = ResolveGeneContentByRatio.getCommonType(possibleTypes);
            if (!isAmbCopy) {
                builder.append(1).append("\t").append(mostCommonType).append("\t").append(copyBuilder.toString().trim());
            } else {
                builder.append(2).append("\t").append(mostCommonType).append("\t").append(merge ? ResolveGeneContentByRatio.buildCopyNumber(mostCommonType, geneContentMap, geneSymbolMap, copy2DS35) : copyBuilder.toString().trim());
            }
        }
    }

    private static void filterMutationTypes(List<String> possibleTypes) {
        String mostCommonType = ResolveGeneContentByRatio.getCommonType(possibleTypes);
        String[] types = mostCommonType.split("/");
        List<String> commonTypes = ResolveGeneContentByRatio.getCommonTypes();
        boolean filterAnyMutation = true;
        if (types.length == 1) {
            String type = types[0];
            String one = type.split("\\+")[0];
            String two = type.split("\\+")[1];
            if (!commonTypes.contains(one) && !commonTypes.contains(two)) {
                filterAnyMutation = false;
            }
        }
        if (filterAnyMutation) {
            Iterator<String> i = possibleTypes.iterator();
            while (i.hasNext()) {
                String type = i.next();
                String one = type.split("\\+")[0];
                String two = type.split("\\+")[1];
                if (commonTypes.contains(one) || commonTypes.contains(two)) continue;
                i.remove();
            }
        }
    }

    private static String buildCopyNumber(String type, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, Map<String, GeneCopy> copy2DS35) {
        String[] ts;
        ArrayList<String> possibleTypes = new ArrayList<String>();
        String[] stringArray = ts = type.split("/");
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            possibleTypes.add(t);
            ++n2;
        }
        StringBuilder copyBuilder = new StringBuilder();
        String[] stringArray2 = GENES;
        int n3 = GENES.length;
        n = 0;
        while (n < n3) {
            String gene = stringArray2[n];
            copyBuilder.append(ResolveGeneContentByRatio.getPossibleCopies(possibleTypes, geneContentMap, geneSymbolMap, gene, copy2DS35)).append("\t");
            ++n;
        }
        return copyBuilder.toString();
    }

    private static List<String> getCommonTypes() {
        ArrayList<String> commonTypes = new ArrayList<String>();
        commonTypes.add("A");
        commonTypes.add("AB");
        commonTypes.add("BA1");
        commonTypes.add("BA2");
        commonTypes.add("B");
        commonTypes.add("Bdel");
        return commonTypes;
    }

    private static String getCommonType(List<String> possibleTypes) {
        List<String> commonTypes = ResolveGeneContentByRatio.getCommonTypes();
        int order = 100;
        String current = null;
        String finalTypes = null;
        for (String type : possibleTypes) {
            String one = type.split("\\+")[0];
            String two = type.split("\\+")[1];
            if (commonTypes.contains(one) && commonTypes.contains(two)) {
                if (finalTypes == null) {
                    finalTypes = type;
                    continue;
                }
                finalTypes = String.valueOf(finalTypes) + "/" + type;
                continue;
            }
            if (commonTypes.contains(one) && commonTypes.indexOf(one) < order) {
                order = commonTypes.indexOf(one);
                current = type;
                continue;
            }
            if (!commonTypes.contains(two) || commonTypes.indexOf(two) >= order) continue;
            order = commonTypes.indexOf(two);
            current = type;
        }
        if (finalTypes != null) {
            return finalTypes;
        }
        if (current == null) {
            return possibleTypes.get(0);
        }
        return current;
    }

    private static String getPossibleCopies(List<String> possibleTypes, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, String gene, Map<String, GeneCopy> copy2DS35) {
        if (gene.equals(_2DS3) && copy2DS35.containsKey(_2DS3)) {
            return String.valueOf(copy2DS35.get(_2DS3).getNumCopy());
        }
        if (gene.equals(_2DS5) && copy2DS35.containsKey(_2DS5)) {
            return String.valueOf(copy2DS35.get(_2DS5).getNumCopy());
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String type : possibleTypes) {
            Map<String, Integer> map1 = ResolveGeneContentByRatio.getGeneCopyMap(type, geneContentMap);
            Map<String, Integer> map2 = ResolveGeneContentByRatio.covertKey(map1, geneSymbolMap);
            int copy = 0;
            if (map2.containsKey(gene)) {
                copy = map2.get(gene);
            }
            if (list.contains(copy)) continue;
            list.add(copy);
        }
        Collections.sort(list);
        if (list.size() == 0) {
            return UNKNOWN_RESULT;
        }
        if (list.size() == 1) {
            return String.valueOf(list.get(0));
        }
        StringBuilder copies = new StringBuilder();
        copies.append(list.get(0));
        int i = 1;
        while (i < list.size()) {
            copies.append("(");
            copies.append(list.get(i));
            copies.append(")");
            ++i;
        }
        return copies.toString();
    }

    private static boolean isPossibleByLevel3(Map<String, Integer> map2, String info) {
        int num2ds4;
        if (info == null) {
            return true;
        }
        info = info.trim();
        int n = num2ds4 = map2.get("2DS4") == null ? 0 : map2.get("2DS4");
        if (info.equalsIgnoreCase("n") || info.equalsIgnoreCase(UNKNOWN_RESULT)) {
            return true;
        }
        if (Integer.valueOf(info) >= 2 && num2ds4 < 2) {
            System.out.println("2ds4 -4-4 diff " + info.trim() + " != " + num2ds4);
            return false;
        }
        System.out.println("2ds4 666 same " + info.trim() + " == " + num2ds4);
        return true;
    }

    private static boolean isPossibleByLevel3DL13DS1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num3DL1 = map2.get("3DL1") == null ? 0 : map2.get("3DL1");
        int num3DS1 = map2.get("3DS1") == null ? 0 : map2.get("3DS1");
        int num3DL2 = map2.get("3DL2") == null ? 0 : map2.get("3DL2");
        String[] ratio = info.trim().split(":");
        String this3dl1 = ratio[0];
        String this3ds1 = ratio[1];
        String this3dl2 = ratio[2];
        if (this3dl1.equals("n") || this3dl1.equals(UNKNOWN_RESULT) || this3ds1.equals("n") || this3ds1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        return this3dl2.equals("n") || this3dl2.equals(UNKNOWN_RESULT) ? num3DL1 == Integer.valueOf(this3dl1) && num3DS1 == Integer.valueOf(this3ds1) : num3DL1 == Integer.valueOf(this3dl1) && num3DS1 == Integer.valueOf(this3ds1) && num3DL2 == Integer.valueOf(this3dl2);
    }

    private static boolean isPossibleByLevel2(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2DL4 = map2.get("2DL4") == null ? 0 : map2.get("2DL4");
        int num3DL5 = map2.get("2DL5") == null ? 0 : map2.get("2DL5");
        String[] ratio = info.trim().split(":");
        String this2dl4 = ratio[0];
        String this2dl5 = ratio[1];
        if (this2dl4.equals("n") || this2dl4.equals(UNKNOWN_RESULT) || this2dl5.equals("n") || this2dl5.equals(UNKNOWN_RESULT) || this2dl4.equals("0") || this2dl5.equals("0")) {
            return true;
        }
        double ratio1 = num2DL4 / num3DL5;
        double ratio2 = Double.valueOf(this2dl4) / Double.valueOf(this2dl5);
        return ratio1 == ratio2 || num2DL4 == Integer.valueOf(this2dl4) && num3DL5 == Integer.valueOf(this2dl5);
    }

    private static boolean isPossibleByLevel1(Map<String, Integer> map2, String info) {
        if (info == null) {
            return true;
        }
        int num2dl1 = map2.get("2DL1") == null ? 0 : map2.get("2DL1");
        int num2ds1 = map2.get("2DS1") == null ? 0 : map2.get("2DS1");
        int num2ds4 = map2.get("2DS4") == null ? 0 : map2.get("2DS4");
        String[] ratio = info.trim().split(":");
        String this2dl1 = ratio[0];
        String this2ds1 = ratio[1];
        String this2ds4 = ratio[2];
        boolean isSame1 = ResolveGeneContentByRatio.isSame(num2dl1, this2dl1);
        boolean isSame2 = ResolveGeneContentByRatio.isSame(num2ds1, this2ds1);
        boolean isSame3 = ResolveGeneContentByRatio.isSame(num2ds4, this2ds4);
        if (isSame1 && isSame2 && isSame3) {
            System.out.println("2DL1/2DS1/2DS4 same " + info.trim() + " == " + num2dl1 + ":" + num2ds1 + ":" + num2ds4);
            return true;
        }
        System.out.println("2DL1/2DS1/2DS4 diff " + info.trim() + " != " + num2dl1 + ":" + num2ds1 + ":" + num2ds4);
        return false;
    }

    private static boolean isSame(int num2dl1, String this2dl1) {
        if (this2dl1.equals("n") || this2dl1.equals(UNKNOWN_RESULT)) {
            return true;
        }
        return Integer.valueOf(this2dl1) == num2dl1;
    }

    private static String getThisAmbiguity(String type, String[] ambiguities) {
        String[] stringArray = ambiguities;
        int n = ambiguities.length;
        int n2 = 0;
        while (n2 < n) {
            String ambiguity = stringArray[n2];
            if (ambiguity.indexOf(String.valueOf(type) + "\t") == 0 || ambiguity.indexOf("\t" + type + "\t") > -1) {
                return ambiguity;
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, Map<String, String>> parseGeneCopies(File geneCopyDir) {
        HashMap<String, Map<String, String>> geneCopies = new HashMap<String, Map<String, String>>();
        File[] fileArray = geneCopyDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            HashMap<String, String> cellLineGenes = new HashMap<String, String>();
            String[] data = FileManager.readTextFile(file).split("\n");
            int i = 1;
            while (i < data.length) {
                String[] items = data[i].split("\\s+");
                if (items[0].trim().length() == 0) break;
                System.out.println(items[0].trim());
                cellLineGenes.put(items[0].trim(), ResolveGeneContentByRatio.formatValue(items));
                ++i;
            }
            geneCopies.put(file.getName(), cellLineGenes);
            ++n2;
        }
        return geneCopies;
    }

    private static String formatValue(String[] items) {
        String info = items[1];
        if (items.length == 2) {
            return info;
        }
        int i = 2;
        while (i < items.length) {
            if (items[i].trim().length() > 0) {
                info = String.valueOf(info) + ":" + items[i];
            }
            ++i;
        }
        return info;
    }

    private static void constructHeader(StringBuilder builder) {
        builder.append("CellLine\tType\tAmbiguity\tMostCommon\t");
        String[] stringArray = GENES;
        int n = GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            builder.append(gene).append("\t");
            ++n2;
        }
        builder.append("\n");
    }

    private static void constructGeneCopies(String type, Map<String, String> geneContentMap, Map<String, String> geneSymbolMap, StringBuilder builder, Map<String, GeneCopy> copy2DS35) {
        Map<String, Integer> map1 = ResolveGeneContentByRatio.getGeneCopyMap(type, geneContentMap);
        Map<String, Integer> map2 = ResolveGeneContentByRatio.covertKey(map1, geneSymbolMap);
        String[] stringArray = GENES;
        int n = GENES.length;
        int n2 = 0;
        while (n2 < n) {
            String gene = stringArray[n2];
            if (map2.containsKey(gene)) {
                builder.append(map2.get(gene)).append("\t");
            } else {
                if (gene.equals(_2DS3) && copy2DS35.containsKey(_2DS3)) {
                    builder.append(copy2DS35.get(_2DS3).getNumCopy());
                } else if (gene.equals(_2DS5) && copy2DS35.containsKey(_2DS5)) {
                    builder.append(copy2DS35.get(_2DS5).getNumCopy());
                } else {
                    builder.append(0);
                }
                builder.append("\t");
            }
            ++n2;
        }
    }

    private static Map<String, Integer> covertKey(Map<String, Integer> map1, Map<String, String> geneSymbolMap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String key : map1.keySet()) {
            map.put(geneSymbolMap.get(key), map1.get(key));
        }
        return map;
    }

    private static Map<String, Integer> getGeneCopyMap(String pair, Map<String, String> geneContentMap) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        String[] haps = pair.trim().split("/")[0].split("\\+");
        String hap1 = geneContentMap.get(haps[0]);
        String hap2 = geneContentMap.get(haps[1]);
        ResolveGeneContentByRatio.collect(hap1, map);
        ResolveGeneContentByRatio.collect(hap2, map);
        return map;
    }

    private static void collect(String hap, Map<String, Integer> map) {
        int i = 0;
        while (i < hap.length()) {
            String gene = String.valueOf(hap.charAt(i));
            if (!map.containsKey(gene)) {
                map.put(gene, 1);
            } else {
                map.put(gene, map.get(gene) + 1);
            }
            ++i;
        }
    }
}

