/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class EncodeHapType {
    private static final Integer START = 3;
    private static final Integer END = 19;

    public static void main(String[] args) throws Exception {
        File hapFile = new File(args[0]);
        File keyFile = new File(args[1]);
        File encodeFile = new File(args[2]);
        String[] haps = FileManager.readTextFile(hapFile).split("\n");
        Map<Integer, String> headers = EncodeHapType.parseHeader(haps[0]);
        Map<String, String> symbols = EncodeHapType.parseSymbol(keyFile);
        StringBuilder output = new StringBuilder();
        int i = 1;
        while (i < haps.length) {
            System.out.println(haps[i]);
            String[] info = haps[i].split(",");
            if (info[0].trim().length() != 0) {
                LinkedHashMap<String, Integer> geneCount = new LinkedHashMap<String, Integer>();
                int j = START - 1;
                while (j < END) {
                    String gene = headers.get(j);
                    int count = EncodeHapType.parseCopies(info[j]);
                    if (!geneCount.containsKey(gene)) {
                        geneCount.put(gene, count);
                    } else {
                        geneCount.put(gene, (Integer)geneCount.get(gene) + count);
                    }
                    ++j;
                }
                output.append(">").append(info[0]).append("\n");
                output.append(EncodeHapType.formatSymbols(geneCount, symbols)).append("\n");
            }
            ++i;
        }
        FileManager.writeTextFile(encodeFile, output.toString(), true);
    }

    private static String formatSymbols(Map<String, Integer> geneCount, Map<String, String> symbols) {
        StringBuilder line = new StringBuilder();
        for (String gene : geneCount.keySet()) {
            int count = geneCount.get(gene);
            if (count == 0) continue;
            int i = 0;
            while (i < count) {
                line.append(symbols.get(gene));
                ++i;
            }
        }
        System.out.println(line.toString());
        return line.toString();
    }

    private static int parseCopies(String value) {
        if (value.trim().length() == 0) {
            return 0;
        }
        return Integer.valueOf(value.trim());
    }

    private static Map<String, String> parseSymbol(File keyFile) {
        String[] lines;
        LinkedHashMap<String, String> symbols = new LinkedHashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(keyFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] info = line.split("\t");
            symbols.put(info[0].trim(), info[1].trim());
            ++n2;
        }
        return symbols;
    }

    private static Map<Integer, String> parseHeader(String header) {
        LinkedHashMap<Integer, String> headers = new LinkedHashMap<Integer, String>();
        String[] info = header.split(",");
        int i = START - 1;
        while (i < END) {
            headers.put(i, info[i]);
            ++i;
        }
        return headers;
    }
}

