/*
 * Decompiled with CFR 0.152.
 */
package kirTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class CompareKeyForGeneContent {
    private static final String N_READ_RESULT = "?";
    private static final char PRESENT_AND_POSITIVE_RESULT = '+';
    private static final char PRESENT_AND_NEGATIVE_RESULT = '-';
    private static final String POSITIVE = "POS";
    private static final String NEGATIVE = "NEG";
    private static final char ABSENT_RESULT = '?';
    private static final String SEPERATOR = "/";

    public static void main(String[] args) throws Exception {
        File snpResultFile = new File(args[0]);
        File keyFile = new File(args[1]);
        File resultFile = new File(args[2]);
        File ambiguityFile = new File(args[3]);
        Map<String, String> snpResultMap = CompareKeyForGeneContent.parseSnpResult(snpResultFile);
        List<List<String>> ambiguityMap = CompareKeyForGeneContent.parseAmbiguityMap(ambiguityFile);
        Map<String, String> keyMap = CompareKeyForGeneContent.parseKey(keyFile);
        StringBuilder builder = new StringBuilder();
        for (String cellLine : snpResultMap.keySet()) {
            if (keyMap.containsKey(snpResultMap.get(cellLine))) {
                boolean isAmb;
                String type = keyMap.get(snpResultMap.get(cellLine));
                boolean bl = isAmb = type.indexOf(SEPERATOR) > 0;
                if (isAmb) {
                    type = CompareKeyForGeneContent.getCommonType(type, ambiguityMap);
                }
                builder.append(cellLine).append("\t").append(type).append("\t").append(isAmb).append("\n");
                continue;
            }
            System.out.println("No key for " + cellLine + " " + snpResultMap.get(cellLine));
            builder.append(cellLine).append("\t").append("Unknown").append("\t").append("Unknown").append("\n");
        }
        FileManager.writeTextFile(resultFile, builder.toString(), true);
    }

    private static String getCommonType(String type, List<List<String>> ambiguityMap) {
        for (List<String> each : ambiguityMap) {
            if (!each.contains(type.split(SEPERATOR)[0])) continue;
            return each.get(0);
        }
        return null;
    }

    private static List<List<String>> parseAmbiguityMap(File ambiguityFile) {
        String[] lines;
        ArrayList<List<String>> list = new ArrayList<List<String>>();
        String[] stringArray = lines = FileManager.readTextFile(ambiguityFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] types;
                ArrayList<String> eachCombined = new ArrayList<String>();
                String[] stringArray2 = types = line.trim().split("\t");
                int n3 = types.length;
                int n4 = 0;
                while (n4 < n3) {
                    String type = stringArray2[n4];
                    eachCombined.add(type);
                    ++n4;
                }
                list.add(eachCombined);
            }
            ++n2;
        }
        return list;
    }

    private static Map<String, String> parseSnpResult(File snpResultFile) {
        LinkedHashMap<String, String> snpResultMap = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(snpResultFile).split("\n");
        LinkedHashMap rawDataMap = new LinkedHashMap();
        String[] header = data[0].trim().split("\\s+");
        int i = 1;
        while (i < data.length) {
            String[] info = data[i].split("\\s+");
            rawDataMap.put(info[0], new HashMap());
            int j = 1;
            while (j < header.length) {
                ((Map)rawDataMap.get(info[0].trim())).put(header[j].trim(), info[j].trim());
                ++j;
            }
            ++i;
        }
        String answer = null;
        for (String cellLine : rawDataMap.keySet()) {
            System.out.println(cellLine);
            answer = CompareKeyForGeneContent.getAnswer((Map)rawDataMap.get(cellLine));
            snpResultMap.put(cellLine, answer);
        }
        return snpResultMap;
    }

    private static String getAnswer(Map<String, String> snpResult) {
        String answer = "";
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL2"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL3"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL4"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DL5"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DP1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DS1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DS2"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.merge(CompareKeyForGeneContent.translate(snpResult.get("2DS3")), CompareKeyForGeneContent.translate(snpResult.get("2DS5")));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("2DS4"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DL1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DL2"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DL3"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DP1"));
        answer = String.valueOf(answer) + CompareKeyForGeneContent.translate(snpResult.get("3DS1"));
        return answer;
    }

    private static String merge(String translate3, String translate5) {
        if (translate3.equals("1") || translate5.equals("1")) {
            return "1";
        }
        if (translate3.equals(String.valueOf('?')) || translate5.equals(String.valueOf('?'))) {
            return String.valueOf('?');
        }
        return "0";
    }

    private static String translate(String info) {
        info.length();
        char symbol = info.charAt(0);
        if (symbol == '+' || symbol == '1' || symbol == '2' || symbol == '3' || symbol == 'n' || info.trim().equals(POSITIVE)) {
            return "1";
        }
        if (symbol == '-' || symbol == '0' || info.trim().equals(NEGATIVE)) {
            return "0";
        }
        if (symbol == '?') {
            return String.valueOf('?');
        }
        System.out.println("Wrong info : " + info + " " + String.valueOf(symbol).equals(POSITIVE));
        return null;
    }

    private static Map<String, String> parseKey(File keyFile) {
        LinkedHashMap<String, String> keyMap = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(keyFile).split("\n");
        String type = null;
        String key = null;
        int i = 1;
        while (i < data.length) {
            String[] info = data[i].split("\\s+");
            type = info[0];
            key = "";
            int j = 1;
            while (j < info.length) {
                key = String.valueOf(key) + (info[j].trim().equals("+") ? "1" : "0");
                ++j;
            }
            if (keyMap.containsKey(key)) {
                keyMap.put(key, String.valueOf((String)keyMap.get(key)) + SEPERATOR + type);
            } else {
                keyMap.put(key, type);
            }
            ++i;
        }
        return keyMap;
    }
}

