/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.util.List;
import java.util.Map;
import kirCountTyping.KirCount;

public class KirGeneExonCountPoint {
    private String genes;
    private String exon;
    private int count;
    private KirCount geneCount;
    private Map<String, List<KirCount>> negativeAllelesCount;
    private Map<String, List<KirCount>> positiveAllelesCount;
    private List<String> unknownNegativeAlleles;
    private List<String> unknownPositiveAlleles;

    public String getGenes() {
        return this.genes;
    }

    public void setGenes(String genes) {
        this.genes = genes;
    }

    public String getExon() {
        return this.exon;
    }

    public void setExon(String exon) {
        this.exon = exon;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public KirCount getGeneCount() {
        return this.geneCount;
    }

    public void setGeneCount(KirCount geneCount) {
        this.geneCount = geneCount;
    }

    public Map<String, List<KirCount>> getNegativeAllelesCount() {
        return this.negativeAllelesCount;
    }

    public void setNegativeAllelesCount(Map<String, List<KirCount>> negativeAllelesCount) {
        this.negativeAllelesCount = negativeAllelesCount;
    }

    public Map<String, List<KirCount>> getPositiveAllelesCount() {
        return this.positiveAllelesCount;
    }

    public void setPositiveAllelesCount(Map<String, List<KirCount>> positiveAllelesCount) {
        this.positiveAllelesCount = positiveAllelesCount;
    }

    public List<String> getUnknownNegativeAlleles() {
        return this.unknownNegativeAlleles;
    }

    public void setUnknownNegativeAlleles(List<String> unknownNegativeAlleles) {
        this.unknownNegativeAlleles = unknownNegativeAlleles;
    }

    public List<String> getUnknownPositiveAlleles() {
        return this.unknownPositiveAlleles;
    }

    public void setUnknownPositiveAlleles(List<String> unknownPositiveAlleles) {
        this.unknownPositiveAlleles = unknownPositiveAlleles;
    }

    public String toString() {
        List<KirCount> counts;
        StringBuilder builder = new StringBuilder();
        builder.append("\t").append(this.getGenes()).append("\t").append("exon").append(this.exon).append("\t").append("count=").append(this.count);
        if (this.getNegativeAllelesCount() != null) {
            builder.append("\tNegativeAlleles:");
            for (String alleleName : this.getNegativeAllelesCount().keySet()) {
                counts = this.getNegativeAllelesCount().get(alleleName);
                builder.append("\t").append(alleleName).append("-").append(counts.size());
            }
        }
        if (this.getPositiveAllelesCount() != null) {
            builder.append("\tPositiveAlleles:");
            for (String alleleName : this.getPositiveAllelesCount().keySet()) {
                counts = this.getPositiveAllelesCount().get(alleleName);
                builder.append("\t").append(alleleName).append("-").append(counts.size());
            }
        }
        if (this.getUnknownNegativeAlleles() != null) {
            builder.append("\tUnknownNegativeAlleles:").append(this.getUnknownNegativeAlleles().toString());
        }
        if (this.getUnknownPositiveAlleles() != null) {
            builder.append("\tUnknownPositiveAlleles:").append(this.getUnknownPositiveAlleles().toString());
        }
        return builder.toString();
    }
}

