/*
 * Decompiled with CFR 0.152.
 */
package kirCountTyping;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kirCountTyping.GeneContentRulesetTyper;
import kirCountTyping.KirConstants;
import kirCountTyping.KirCount;
import kirCountTyping.KirGeneExonCountPoint;
import kirCountTyping.KirGeneExonCountSummary;
import kirCountTyping.KirGeneResult;
import kirCountTyping.KirSample;
import kirCountTyping.KirUtils;
import kirCountTyping.NmerRulesetParser;
import misc.FileManager;

public class KirCountAnalyzer {
    private static void processInput(File kirCountFile, File kirNmerRulesetFile, File kirHaploidRulesetFile) {
        GeneContentRulesetTyper geneContentRulesetTyper = new GeneContentRulesetTyper(kirHaploidRulesetFile);
        String[] lines = FileManager.readTextFile(kirCountFile).split("\n");
        ArrayList<KirSample> samples = new ArrayList<KirSample>();
        int i = 1;
        while (i < lines.length) {
            KirSample sample = KirCountAnalyzer.analyzeOneSampleCount1stLevel(geneContentRulesetTyper, kirNmerRulesetFile, lines, i);
            samples.add(sample);
            ++i;
        }
        KirCountAnalyzer.analyzeOneSampleCount2ndLevel(samples, geneContentRulesetTyper);
        System.out.println(KirCountAnalyzer.writePNresult(samples));
        System.out.println(KirCountAnalyzer.writeGeneCopyResult(samples));
    }

    private static void analyzeOneSampleCount2ndLevel(List<KirSample> samples, GeneContentRulesetTyper geneContentRulesetTyper) {
        for (KirSample sample : samples) {
            List<KirSample> control2DS2samples;
            List<KirSample> controlAAsamples;
            System.out.println("analyzeOneSampleCount2ndLevel " + sample.getName());
            List<KirSample> control2DL5samples = KirUtils.collect2DL5samples(samples);
            if (control2DL5samples.size() > 0) {
                KirCountAnalyzer.analyzeOneSample2DL5Copy(geneContentRulesetTyper, sample, control2DL5samples);
            }
            if ((controlAAsamples = KirUtils.collectAAsamples(samples)).size() > 0) {
                KirCountAnalyzer.analyzeOneSample2DP3DPCopy(geneContentRulesetTyper, sample, controlAAsamples);
            }
            if ((control2DS2samples = KirUtils.collect2DS2samples(samples)).size() <= 0) continue;
            KirCountAnalyzer.analyzeOneSample2DS2Copy(geneContentRulesetTyper, sample, control2DS2samples);
        }
    }

    public static String writeGeneCopyResult(List<KirSample> samples) {
        StringBuilder builder = new StringBuilder();
        builder.append("CellLine").append("\t").append("TypeLocalName").append("\t").append("TypeOfficalName").append("\t").append("Ambiguity").append("\t").append("MostCommonLocalName").append("\t").append("MostCommonOfficalName").append("\t");
        builder.append("2DL1").append("\t").append("2DL2").append("\t").append("2DL3").append("\t").append("2DL4").append("\t").append("2DL5").append("\t").append("2DP1").append("\t");
        builder.append("2DS1").append("\t").append("2DS2").append("\t").append("2DS3").append("\t").append("2DS4").append("\t").append("2DS5").append("\t");
        builder.append("3DL1").append("\t").append("3DL2").append("\t").append("3DL3").append("\t").append("3DP1").append("\t").append("3DS1").append("\n");
        for (KirSample sample : samples) {
            builder.append(sample.getName());
            if (sample.getMostCommonType() == null) {
                builder.append("\t").append("unknown");
                builder.append("\n");
                continue;
            }
            builder.append("\t").append(KirUtils.joinName(sample.getAmbiguityType(), true));
            builder.append("\t").append(KirUtils.joinName(sample.getAmbiguityType(), false));
            builder.append("\t").append(KirUtils.getAmbiguityStatus(sample));
            builder.append("\t").append(KirUtils.joinName(sample.getMostCommonType(), true));
            builder.append("\t").append(KirUtils.joinName(sample.getMostCommonType(), false));
            String[] stringArray = KirConstants.KIR_GENES;
            int n = KirConstants.KIR_GENES.length;
            int n2 = 0;
            while (n2 < n) {
                String gene = stringArray[n2];
                int count = sample.getGeneResult().get(gene).getCopy();
                if (sample.getGeneResult().get(gene).isPresent() && count == 0) {
                    builder.append("\t").append(sample.getGeneResult().get(gene).getPossibleCopies().toString());
                } else {
                    builder.append("\t").append(count);
                }
                ++n2;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String writePNresult(List<KirSample> samples) {
        StringBuilder builder = new StringBuilder();
        builder.append("CellLine").append("\t");
        builder.append("2DL1").append("\t").append("2DL2").append("\t").append("2DL3").append("\t").append("2DL4").append("\t").append("2DL5").append("\t").append("2DP1").append("\t");
        builder.append("2DS1").append("\t").append("2DS2").append("\t").append("2DS3").append("\t").append("2DS4").append("\t").append("2DS5").append("\t");
        builder.append("3DL1").append("\t").append("3DL2").append("\t").append("3DL3").append("\t").append("3DP1").append("\t").append("3DS1").append("\n");
        for (KirSample sample : samples) {
            builder.append(sample.getName());
            String[] stringArray = KirConstants.KIR_GENES;
            int n = KirConstants.KIR_GENES.length;
            int n2 = 0;
            while (n2 < n) {
                String gene = stringArray[n2];
                builder.append("\t").append(sample.getGeneResult().get(gene).isPresent() ? "+" : "-");
                ++n2;
            }
            builder.append("\n");
        }
        return builder.toString();
    }

    public static KirSample analyzeOneSampleCount1stLevel(GeneContentRulesetTyper geneContentRulesetTyper, File kirRulesetFile, String[] lines, int i) {
        List<KirCount> kirCounts = NmerRulesetParser.readInNmerRulesetFile(kirRulesetFile);
        List<KirGeneExonCountPoint> kirCountsPoints = NmerRulesetParser.correlateCountPositions(kirCounts);
        String sampleName = lines[i].trim().split("\t")[0].trim();
        KirUtils.readInCount(lines[0].trim(), lines[i].trim(), kirCounts);
        KirUtils.calculateCountPoint(kirCountsPoints);
        List<KirGeneExonCountSummary> geneExonSummaries = KirUtils.summarizeCountPoints(kirCountsPoints);
        Map<String, KirGeneResult> KirGeneResults = KirUtils.analyzeGenePresence(geneExonSummaries);
        KirSample sample = new KirSample();
        sample.setName(sampleName);
        sample.setGeneResult(KirGeneResults);
        KirCountAnalyzer.setGeneContentType(sample, geneContentRulesetTyper);
        if (sample.getMostCommonType() == null) {
            return sample;
        }
        KirUtils.determint2DL12DS12DS4Copy(sample);
        KirCountAnalyzer.resetTypeAndGeneCopy(sample, geneContentRulesetTyper);
        KirUtils.determint3DL13DS13DL2Copy(sample);
        KirCountAnalyzer.resetTypeAndGeneCopy(sample, geneContentRulesetTyper);
        if (sample.isResolvedCopy()) {
            System.out.println(">>>>>>>>> " + sample.getName() + " " + sample.getMostCommonType().get(0).getLocalName());
        }
        return sample;
    }

    public static void analyzeOneSample2DP3DPCopy(GeneContentRulesetTyper geneContentRulesetTyper, KirSample sample, List<KirSample> controlAAsamples) {
        if (sample.getMostCommonType() == null) {
            return;
        }
        System.out.println("sample.getMostCommonType() = " + sample.getMostCommonType().get(0).getLocalName());
        KirUtils.determint2DP3DPCopy(sample, controlAAsamples);
        KirCountAnalyzer.resetTypeAndGeneCopy(sample, geneContentRulesetTyper);
    }

    public static void analyzeOneSample2DL5Copy(GeneContentRulesetTyper geneContentRulesetTyper, KirSample sample, List<KirSample> control2DS2samples) {
        if (sample.getMostCommonType() == null) {
            return;
        }
        System.out.println("sample.getMostCommonType() = " + sample.getMostCommonType().get(0).getLocalName());
        KirUtils.determint2DL5Copy(sample, control2DS2samples);
        KirCountAnalyzer.resetTypeAndGeneCopy(sample, geneContentRulesetTyper);
    }

    public static void analyzeOneSample2DS2Copy(GeneContentRulesetTyper geneContentRulesetTyper, KirSample sample, List<KirSample> control2DS2samples) {
        if (sample.getMostCommonType() == null) {
            return;
        }
        System.out.println("sample.getMostCommonType() = " + sample.getMostCommonType().get(0).getLocalName());
        KirUtils.determint2DS2Copy(sample, control2DS2samples);
        KirCountAnalyzer.resetTypeAndGeneCopy(sample, geneContentRulesetTyper);
    }

    public static void resetTypeAndGeneCopy(KirSample sample, GeneContentRulesetTyper geneContentRulesetTyper) {
        geneContentRulesetTyper.typeBasedOnGeneCopy(sample);
        geneContentRulesetTyper.loadPossibleGeneCopies(sample);
        for (String gene : sample.getGeneResult().keySet()) {
            System.out.println("\t" + gene + "\t" + sample.getGeneResult().get(gene).getPossibleCopies().toString());
        }
    }

    public static void setGeneContentType(KirSample sample, GeneContentRulesetTyper geneContentRulesetTyper) {
        geneContentRulesetTyper.typeBasedOnPNresult(sample);
        System.out.println(String.valueOf(sample.getName()) + " : " + (sample.getMostCommonType() == null ? null : sample.getMostCommonType().get(0).getLocalName()));
        if (sample.getMostCommonType() == null) {
            return;
        }
        geneContentRulesetTyper.loadPossibleGeneCopies(sample);
        for (String gene : sample.getGeneResult().keySet()) {
            System.out.println("\t" + gene + "\t" + sample.getGeneResult().get(gene).getPossibleCopies().toString());
        }
    }

    public static void main(String[] args) throws Exception {
        File kirCountFile = new File(args[0]);
        File kirNmerRulesetFile = new File(args[1]);
        File kirHapRulesetFile = new File(args[2]);
        KirCountAnalyzer.processInput(kirCountFile, kirNmerRulesetFile, kirHapRulesetFile);
    }
}

