/*
 * Decompiled with CFR 0.152.
 */
package guid;

import guid.Identifier;
import guid.IdentifierFactory;
import java.io.Serializable;

public final class ObjectId
implements Identifier,
Serializable {
    private static final long serialVersionUID = 8978111673092807429L;
    private String hexadecimalId;

    public ObjectId() {
        this.setDecimalId(IdentifierFactory.createUniqueIdentifier().getId());
    }

    public ObjectId(byte[] binoid) {
        this.setHexadecimalId(IdentifierFactory.stringFromBytes(binoid));
    }

    public ObjectId(String id) {
        if (id.length() == 32) {
            this.setHexadecimalId(id);
        } else {
            this.setHexadecimalId(IdentifierFactory.hexStringFromDecimalString(id));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ObjectId)) {
            return false;
        }
        return this.getId().equalsIgnoreCase(((ObjectId)obj).getId());
    }

    @Override
    public String getId() {
        return this.hexadecimalId;
    }

    public String getDecimalId() {
        return IdentifierFactory.decimalStringFromHexString(this.getHexadecimalId());
    }

    public byte[] getByteArrayId() {
        return IdentifierFactory.bytesFromHexString(this.getHexadecimalId());
    }

    public String getHexadecimalId() {
        return this.hexadecimalId;
    }

    @Override
    public int hashCode() {
        return this.getDecimalId().hashCode();
    }

    @Override
    public String toString() {
        return "ObjectId = " + this.getId();
    }

    private void setDecimalId(String decimalId) {
        this.setHexadecimalId(IdentifierFactory.hexStringFromDecimalString(decimalId));
    }

    private void setHexadecimalId(String hexadecimalId) {
        if (hexadecimalId == null) {
            throw new IllegalArgumentException("Parameter cannot be null");
        }
        if (hexadecimalId.length() != 32) {
            throw new IllegalArgumentException("Invalid length of number");
        }
        this.hexadecimalId = hexadecimalId;
    }
}

