/*
 * Decompiled with CFR 0.152.
 */
package guid;

import guid.Identifier;
import guid.ObjectId;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Random;

public final class IdentifierFactory {
    private static final String ZERO = "0";
    private static final short BYTE_SHIFT = 8;
    private static final String HEX_TOKEN = "0x";
    private static final short HIGH_NIBBLE_MASK = 240;
    private static final long HIGH_TIME_MASK = 0xFFF000000000000L;
    private static final short HIGH_TIME_OFFSET = 48;
    private static long lastTimestamp;
    private static final short LOW_BYTE_MASK = 255;
    private static final short LOW_NIBBLE_MASK = 15;
    private static final long LOW_TIME_MASK = 0xFFFFFFFFL;
    private static byte[] MACAddr;
    private static final short MACADDR_LENGTH = 6;
    private static final int MAX_SEQUENCE_NUMBER = 16384;
    private static final long MID_TIME_MASK = 0xFFFF00000000L;
    private static final short MID_TIME_OFFSET = 32;
    private static final long NANOSECONDS_PER_DAY = 711573504L;
    private static final short OID_LENGTH = 16;
    private static final int RADIX = 16;
    private static Random rand;
    private static int sequenceNumber;
    private static final long TIME_OFFSET = 100627167068160L;
    private static final byte VARIANT = -128;
    private static final byte VERSION = 16;
    private static final String STARTUP_ERROR = "\n\n*************\nEROOR! EROOR!\nThe GeMS system has detected an error. Your \"mac.address\" property is not correctly defined in the \"gems.properties\" configuration file located in the \"conf\" directory.\nIgnore this message at your own risk!\nPeril sure to follow if you don't fix this now!\nRead the\"gems.properties\" file for an explanation on how to fix this.\nUsing a random numer for now.\nERROR! ERROR!\n*************\n\n";

    static {
        rand = new Random(System.currentTimeMillis());
        try {
            MACAddr = IdentifierFactory.bytesFromHexString("001D0905DCDC");
        }
        catch (RuntimeException e) {
            System.err.println(STARTUP_ERROR);
            MACAddr = IdentifierFactory.getDummyMACADDR();
        }
        if (MACAddr.length < 6) {
            System.err.println(STARTUP_ERROR);
            MACAddr = IdentifierFactory.getDummyMACADDR();
        }
        sequenceNumber = rand.nextInt();
        sequenceNumber %= 16384;
    }

    private IdentifierFactory() {
    }

    public static Identifier createUniqueIdentifier() {
        return new ObjectId(IdentifierFactory.createOid());
    }

    public static ObjectId createUniqueIdentifier(byte[] byteArray) {
        return new ObjectId(byteArray);
    }

    public static Identifier createUniqueIdentifier(String identifier) {
        return new ObjectId(identifier);
    }

    public static boolean isIdentifier(String potentialIdentifier) {
        boolean result = false;
        try {
            IdentifierFactory.createUniqueIdentifier(potentialIdentifier);
            result = true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return result;
    }

    public static String decimalStringFromHexString(String hexString) {
        int length;
        if (hexString == null) {
            return null;
        }
        if (hexString.startsWith(HEX_TOKEN)) {
            hexString = hexString.substring(HEX_TOKEN.length());
        }
        if ((length = hexString.length()) == 0) {
            throw new IllegalArgumentException("Not a valid hex string, the length is 0");
        }
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Not a valid hex string, the length is not even number");
        }
        return new BigInteger(hexString, 16).toString();
    }

    public static String hexStringFromDecimalString(String decimal) {
        String hexString = null;
        if (decimal != null && (hexString = new BigInteger(decimal).toString(16)).length() < 33 && hexString.length() % 2 != 0) {
            hexString = ZERO + hexString;
        }
        return hexString;
    }

    public static String stringFromBytes(byte[] byteArray) {
        StringBuffer str = new StringBuffer("");
        int i = 0;
        while (i < byteArray.length) {
            if ((byteArray[i] & 0xF0) > 0) {
                str.append(Integer.toHexString(byteArray[i] & 0xFF));
            } else {
                str.append(ZERO + Integer.toHexString(byteArray[i] & 0xFF));
            }
            ++i;
        }
        return str.toString();
    }

    public static byte[] bytesFromHexString(String hexString) {
        int length;
        if (hexString.startsWith(HEX_TOKEN)) {
            hexString = hexString.substring(HEX_TOKEN.length());
        }
        if ((length = hexString.length() / 2) == 0) {
            throw new IllegalArgumentException("zero length string");
        }
        if (hexString.length() % 2 != 0) {
            throw new IllegalArgumentException("odd length string");
        }
        byte[] tempArray = new byte[length];
        int i = 0;
        while (i < length) {
            try {
                String temp = hexString.substring(i * 2, i * 2 + 2);
                char[] digs = temp.toCharArray();
                int theValue = Character.digit(digs[0], 16) * 16;
                tempArray[i] = (byte)(theValue += Character.digit(digs[1], 16));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("improperly formed hex string");
            }
            ++i;
        }
        return tempArray;
    }

    private static synchronized byte[] createOid() {
        long naughtyBits = 0L;
        byte[] localOid = new byte[16];
        long time = IdentifierFactory.getTime();
        naughtyBits = time & 0xFFFFFFFFL;
        IdentifierFactory.stuffOidWithLong(localOid, naughtyBits, 0, 4);
        naughtyBits = (time & 0xFFFF00000000L) >>> 32;
        IdentifierFactory.stuffOidWithLong(localOid, naughtyBits, 4, 2);
        naughtyBits = (time & 0xFFF000000000000L) >>> 48;
        IdentifierFactory.stuffOidWithLong(localOid, naughtyBits, 6, 2);
        naughtyBits = sequenceNumber;
        IdentifierFactory.stuffOidWithLong(localOid, naughtyBits, 8, 2);
        System.arraycopy(MACAddr, 0, localOid, 10, 6);
        localOid[6] = (byte)(localOid[6] & 0xF);
        localOid[6] = (byte)(localOid[6] | 0x10);
        localOid[8] = (byte)(localOid[8] & 0xF);
        localOid[8] = (byte)(localOid[8] | 0xFFFFFF80);
        return localOid;
    }

    private static byte[] getDummyMACADDR() {
        byte[] dummy = new byte[6];
        rand.nextBytes(dummy);
        dummy[0] = (byte)(dummy[0] | 0xFFFFFF80);
        try {
            InetAddress localhost = InetAddress.getLocalHost();
            byte[] address = localhost.getAddress();
            if (127 != address[0]) {
                dummy[dummy.length - 1] = address[address.length - 1];
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return dummy;
    }

    private static long getTime() {
        long time = 100627167068160L + 1000L * System.currentTimeMillis();
        if (time <= lastTimestamp) {
            IdentifierFactory.incrementSequence();
        } else {
            IdentifierFactory.setTimeStamp(time);
        }
        return time;
    }

    private static void incrementSequence() {
        ++sequenceNumber;
        sequenceNumber %= 16384;
    }

    private static void setTimeStamp(long time) {
        lastTimestamp = time;
    }

    private static void stuffOidWithLong(byte[] tempOid, long l, int arrayPosition, int numBytes) {
        int index = arrayPosition + numBytes - 1;
        do {
            tempOid[index] = (byte)(l & 0xFFL);
            l >>>= 8;
        } while (index-- > arrayPosition);
    }
}

