/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;

public class genePhotographer {
    private static final String PNG = "jpg";
    private static final double MIN_NUMBER = 5.0;
    private static final double MAX_NUMBER = 10.0;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_HEIGHT = 600;
    private static final int IMAGE_SEQUENCE_POSITION = 50;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int IMAGE_AMPLICON_BAR_HEIGHT = 5;
    private static final int INTRON_EXON_BAR_HEIGHT = 5;
    private static final int AMPLICON_SHIFT_UNIT = 10;
    private static final int MARKER_HEIGHT = 8;
    private static final int SNP_MARKER_HEIGHT = 6;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 24;
    private static final int LETTER_WIDTH = 8;
    private static final int MASKED_SEQUENCE_POSITION = 50;
    private static final int INTRON_EXON_POSITION = 75;
    private static final int AMPLICON_POSITION = 150;
    private static final int SNP_POSITION = 125;
    private static final int MASKED_SEQUENCE_NOTE = 50;
    private static final int AMPLICON_NOTE = 90;
    private static final int SNP_NOTE = 70;
    private static final int INTRON_EXON_NOTE = 110;
    private static final int SNP_POINT_WIDTH = 1;
    private static final int IMAGE_UNIT = 100;
    private static final int NORMAL_SEQUENCE_UNIT = 4000;
    private static final int MAX_IMAGE_WIDTH = 65500;
    private static final String ARBO = "Human";
    private static final String CYNO = "CYNO";
    private static final String CHINESE_RHESUS = "Chinese-Rhesus";
    private static final String PIGTAIL_RHESUS = "Pigtail-Rhesus";
    private static final String RHESUS_MACQUE = "Rhesus-Macque";
    private static final int SNP_COUNT_UNIT = 7;
    private static BufferedImage bufferedImage;
    private static Graphics2D graphics2D;
    private static int imageWidth;
    private static boolean useDefault;
    private static double unit;
    private static int num;
    private static int sequenceUnit;

    public static void main(String[] args) throws Exception {
        File fasta = new File(args[0]);
        File repeatFile = new File(args[1]);
        File image = new File(args[2]);
        GeneAnnotationVO geneAnnotationVO = genePhotographer.prepDataForGraph(fasta, repeatFile);
        genePhotographer.generateImage(geneAnnotationVO, image);
    }

    private static GeneAnnotationVO prepDataForGraph(File fasta, File repeatFile) {
        GeneAnnotationVO geneAnnotationVO = new GeneAnnotationVO();
        geneAnnotationVO.setDrawRepeatMask(true);
        geneAnnotationVO.setSequenceLength(genePhotographer.getSequenceLength(fasta));
        geneAnnotationVO.setRepeatMasked(AnnotationPhotographer.getRepeatMasked(repeatFile));
        return geneAnnotationVO;
    }

    private static int getSequenceLength(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder builder = new StringBuilder();
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString().length();
    }

    private static void initializeBufferedImage(GeneAnnotationVO geneAnnotationVO) {
        imageWidth = 1000;
        unit = 100.0;
        useDefault = true;
        num = 0;
        if (geneAnnotationVO.getSequenceLength() < 40000) {
            unit = genePhotographer.getUnit(geneAnnotationVO.getSequenceLength());
            num = new Double((double)geneAnnotationVO.getSequenceLength() / unit).intValue();
        } else {
            System.out.println("3.5");
            imageWidth = geneAnnotationVO.getSequenceLength() * 100 / 4000;
            useDefault = false;
            num = new Double(geneAnnotationVO.getSequenceLength() / 4000).intValue();
            sequenceUnit = 4000;
            System.out.println(imageWidth);
            if (imageWidth > 65500) {
                imageWidth /= 100;
                sequenceUnit = 400000;
                num = new Double(geneAnnotationVO.getSequenceLength() / sequenceUnit).intValue();
            }
        }
        bufferedImage = new BufferedImage(imageWidth, 600, 9);
    }

    private static void initializeGraphics2D(GeneAnnotationVO geneAnnotationVO) {
        graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    private static void drawSequence(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.LIGHT_GRAY);
        graphics2D.draw3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.fill3DRect(0, bufferedImage.getHeight() - 50, bufferedImage.getWidth(), 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, bufferedImage.getHeight() - 50, 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString("1", 1, bufferedImage.getHeight() - 24);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - 50 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, bufferedImage.getHeight() - 24);
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            if (useDefault) {
                x = Math.round(new Float(new Double(imageWidth) / new Double(length) * unit * (double)i).floatValue());
                index = String.valueOf(new Double(unit * (double)i).intValue());
            } else {
                x = 100 * i;
                index = String.valueOf(sequenceUnit * i);
            }
            graphics2D.drawLine(x, bufferedImage.getHeight() - 50, x, bufferedImage.getHeight() - 50 + 10);
            if (i < num || i == num && ((double)length - unit * (double)num >= unit / 2.0 && useDefault || length - sequenceUnit * num >= sequenceUnit / 2 && !useDefault)) {
                graphics2D.drawString(index, x, bufferedImage.getHeight() - 24);
            }
            ++i;
        }
    }

    private static Map<String, Map<Integer, Integer>> initMap() {
        HashMap<String, Map<Integer, Integer>> spicesMap = new HashMap<String, Map<Integer, Integer>>();
        spicesMap.put(ARBO, new HashMap());
        spicesMap.put(CYNO, new HashMap());
        spicesMap.put(RHESUS_MACQUE, new HashMap());
        spicesMap.put(CHINESE_RHESUS, new HashMap());
        spicesMap.put(PIGTAIL_RHESUS, new HashMap());
        return spicesMap;
    }

    private static void generateImage(GeneAnnotationVO geneAnnotationVO, File image) {
        Map<String, Map<Integer, Integer>> spicesMap = genePhotographer.initMap();
        HashMap snpMarker = new HashMap();
        genePhotographer.initializeBufferedImage(geneAnnotationVO);
        genePhotographer.initializeGraphics2D(geneAnnotationVO);
        genePhotographer.drawSequence(geneAnnotationVO);
        if (geneAnnotationVO.isDrawRepeatMask()) {
            genePhotographer.drawRepeatMasker(geneAnnotationVO);
        }
        genePhotographer.writeImageToFile(image);
    }

    public static void drawRepeatMasker(GeneAnnotationVO geneAnnotationVO) {
        int length = geneAnnotationVO.getSequenceLength();
        graphics2D.setColor(Color.DARK_GRAY);
        graphics2D.draw3DRect(30, 50, 50, 10, true);
        graphics2D.fill3DRect(30, 50, 50, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString("RepeatMasked", 90, 60);
        graphics2D.setColor(Color.DARK_GRAY);
        for (SequencePiece sequencePiece : geneAnnotationVO.getRepeatMasked()) {
            int from = sequencePiece.getStart();
            int to = sequencePiece.getEnd();
            int x1 = 0;
            int x2 = 0;
            if (useDefault) {
                x1 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)from).floatValue());
                x2 = Math.round(new Float(new Double(1000.0) / new Double(length) * (double)to).floatValue());
            } else {
                x1 = from * 100 / sequenceUnit;
                x2 = to * 100 / sequenceUnit;
            }
            graphics2D.draw3DRect(x1, bufferedImage.getHeight() - 50, x2 - x1, 10, true);
            graphics2D.fill3DRect(x1, bufferedImage.getHeight() - 50, x2 - x1, 10, true);
        }
    }

    private static void populateMap(File file, Integer position, Map<String, Map<Integer, Integer>> spicesMap) {
        int arbo = 0;
        int cyno = 0;
        int chineseRhesus = 0;
        int pigtailRhesus = 0;
        int rhesusMacque = 0;
        String[] data = FileManager.readTextFile(file).split("\n");
        if (data.length == 10) {
            arbo = genePhotographer.getHtCount(data[5], data[2], "ARBO", file.getName());
            cyno = genePhotographer.getHtCount(data[6], data[2], CYNO, file.getName());
            chineseRhesus = genePhotographer.getHtCount(data[7], data[2], CHINESE_RHESUS, file.getName());
            pigtailRhesus = genePhotographer.getHtCount(data[8], data[2], PIGTAIL_RHESUS, file.getName());
            rhesusMacque = genePhotographer.getHtCount(data[9], data[2], RHESUS_MACQUE, file.getName());
        } else {
            System.out.println("no snp : " + file.getName());
        }
        if (arbo >= 0) {
            spicesMap.get(ARBO).put(position, arbo);
        }
        if (cyno >= 0) {
            spicesMap.get(CYNO).put(position, cyno);
        }
        if (chineseRhesus >= 0) {
            spicesMap.get(CHINESE_RHESUS).put(position, chineseRhesus);
        }
        if (pigtailRhesus >= 0) {
            spicesMap.get(PIGTAIL_RHESUS).put(position, pigtailRhesus);
        }
        if (rhesusMacque >= 0) {
            spicesMap.get(RHESUS_MACQUE).put(position, rhesusMacque);
        }
        System.out.println(String.valueOf(file.getName()) + " : " + position);
        System.out.println("Human : " + arbo);
        System.out.println("CYNO : " + cyno);
        System.out.println("Chinese-Rhesus : " + chineseRhesus);
        System.out.println("Pigtail-Rhesus : " + pigtailRhesus);
        System.out.println("Rhesus-Macque : " + rhesusMacque);
    }

    private static int getHtCount(String data, String conf, String cellLine, String filename) {
        int count = 0;
        String[] calls = data.trim().split(",");
        String[] confs = conf.trim().split(",");
        if (!calls[0].trim().equals(cellLine)) {
            System.out.println("wrong cellline order " + filename);
        }
        boolean allN = true;
        int i = 1;
        while (i < calls.length) {
            int c = new Integer(confs[i].split(":")[1].trim());
            if (!calls[i].trim().startsWith("N")) {
                allN = false;
            }
            if (c >= 15 && calls[i].indexOf("/") > 0) {
                ++count;
            }
            ++i;
        }
        return allN ? -1 : count;
    }

    private static void writeImageToFile(File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName(PNG).next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }

    private static void drawSnpSatistics(Map<String, Map<Integer, Integer>> spicesMap, int length) {
        graphics2D.setColor(Color.ORANGE);
        int offSet = 100;
        Map<Integer, Integer> positionCount = null;
        for (String spice : spicesMap.keySet()) {
            if (spice.equals(ARBO)) {
                graphics2D.setColor(Color.BLACK);
                graphics2D.drawString(ARBO, 10, bufferedImage.getHeight() - offSet + 20);
            } else if (spice.equals(CYNO)) {
                graphics2D.setColor(Color.BLUE);
                graphics2D.drawString(CYNO, 10, bufferedImage.getHeight() - offSet + 20);
            } else if (spice.equals(CHINESE_RHESUS)) {
                graphics2D.setColor(Color.CYAN);
                graphics2D.drawString(CHINESE_RHESUS, 10, bufferedImage.getHeight() - offSet + 20);
            } else if (spice.equals(PIGTAIL_RHESUS)) {
                graphics2D.setColor(Color.GRAY);
                graphics2D.drawString(PIGTAIL_RHESUS, 10, bufferedImage.getHeight() - offSet + 20);
            } else if (spice.equals(RHESUS_MACQUE)) {
                graphics2D.setColor(Color.GREEN);
                graphics2D.drawString(RHESUS_MACQUE, 10, bufferedImage.getHeight() - offSet + 20);
            }
            positionCount = spicesMap.get(spice);
            graphics2D.drawLine(0, bufferedImage.getHeight() - offSet + 3, bufferedImage.getWidth(), bufferedImage.getHeight() - offSet + 3);
            for (Integer pos : positionCount.keySet()) {
                int x = 0;
                x = useDefault ? Math.round(new Float(new Double(1000.0) / new Double(length) * (double)pos.intValue()).floatValue()) : pos * 100 / sequenceUnit;
                int recYStart = bufferedImage.getHeight() - offSet - Math.min(positionCount.get(pos) * 7, 70);
                graphics2D.drawRect(x, recYStart, 1, 6);
                graphics2D.fillRect(x, recYStart, 1, 6);
            }
            offSet = offSet + 70 + 30;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }
}

