/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class proteinReport2 {
    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File outputFile = new File(args[1]);
        File rulesetDir = new File(args[2]);
        String[] lines = FileManager.readTextFile(inputFile).split("\n");
        StringBuilder builder = new StringBuilder();
        LinkedHashMap<String, List<String>> locusNames = new LinkedHashMap<String, List<String>>();
        int i = 1;
        while (i < lines.length) {
            String[] items = lines[i].split(",");
            if (items.length > 6) {
                int j = 6;
                while (j < items.length) {
                    String type = items[j].trim();
                    if (type.length() != 0) {
                        proteinReport2.addNameToMap(type, locusNames);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Map<String, Map<String, String>> mappedNames = proteinReport2.mapTypeNames(locusNames, rulesetDir);
        for (String locus : mappedNames.keySet()) {
            Map<String, String> seqs = mappedNames.get(locus);
            for (String name : seqs.keySet()) {
                builder.append(">").append(name).append("\n");
                builder.append(seqs.get(name)).append("\n");
            }
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static Map<String, Map<String, String>> mapTypeNames(Map<String, List<String>> locusNames, File rulesetDir) {
        LinkedHashMap<String, Map<String, String>> mappedNames = new LinkedHashMap<String, Map<String, String>>();
        for (String locus : locusNames.keySet()) {
            if (!mappedNames.containsKey(locus)) {
                mappedNames.put(locus, new LinkedHashMap());
            }
            List<String> typeNames = locusNames.get(locus);
            File rulesetFile = proteinReport2.getRulesetFile(rulesetDir, locus);
            for (String typeName : typeNames) {
                proteinReport2.putTypeSeq(rulesetFile, typeName, (Map)mappedNames.get(locus));
            }
        }
        return mappedNames;
    }

    private static void putTypeSeq(File rulesetFile, String name, Map<String, String> typeSeq) {
        String[] lines = FileManager.readTextFile(rulesetFile).split("\n");
        String type = name;
        if (name.endsWith("G")) {
            type = name.substring(0, name.length() - 1);
        }
        if (type.startsWith("Cw")) {
            type = type.replace("Cw", "C");
        }
        if (type.equals("C*17:01:01") || type.equals("C*17:01:01:01")) {
            type = "C*17:01:01:02";
        }
        if (type.equals("A*02:16:01")) {
            type = "A*02:16";
        }
        if (type.equals("C*01:03:01")) {
            type = "C*01:03";
        }
        if (type.equals("B*15:12:01")) {
            type = "B*15:12";
        }
        if (type.equals("B*1501")) {
            type = "B*15:01";
        }
        if (type.equals("C*0602")) {
            type = "C*06:02";
        }
        if (type.equals("DQA1*05:ne")) {
            type = "DQA1*05:01";
        }
        if (type.equals("DPB1*19:01:01")) {
            type = "DPB1*19:01";
        }
        if (type.equals("DQB1*03:03")) {
            type = "DQB1*03:03:02:01";
        }
        if (type.equals("DRB1*09")) {
            type = "DRB1*09:01:02";
        }
        if (type.equals("DRB3*0101")) {
            type = "DRB3*01:01:02:01";
        }
        if (type.equals("DRB1*09:01")) {
            type = "DRB1*09:01:02";
        }
        if (type.equals("DRB4*01:03:01:0")) {
            type = "DRB4*01:03:01:01";
        }
        if (type.equals("DPA1*02:02:01")) {
            type = "DPA1*02:02:02";
        }
        if (type.equals("DPB1*28:01P")) {
            type = "DPB1*28:01";
        }
        if (type.equals("DPB1*02:01")) {
            type = "DPB1*02:01:02:01";
        }
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && (line.substring(1).equals(type) || line.substring(1).equals(String.valueOf(type) + ":01") || line.substring(1).equals(String.valueOf(type) + ":01:01") || line.substring(1).equals(String.valueOf(type) + ":01:01:01"))) {
                String header = name;
                String seq = lines[i + 1].trim();
                typeSeq.put(header, seq);
                return;
            }
            ++i;
        }
        System.out.println("no seq for " + type);
    }

    private static void addNameToMap(String type, Map<String, List<String>> locusNames) {
        String name = type.split("\\*")[0];
        if (name.equals("Cw")) {
            name = "C";
        } else if (name.startsWith("DRB")) {
            name = "DRB";
        }
        if (!locusNames.containsKey(name)) {
            locusNames.put(name, new ArrayList());
        }
        if (!locusNames.get(name).contains(type)) {
            locusNames.get(name).add(type);
        }
    }

    private static String getTypeSeq(File rulesetFile, String name) {
        String[] lines = FileManager.readTextFile(rulesetFile).split("\n");
        String type = name;
        if (type.equals("C*17:01:01")) {
            type = "C*17:01:01:02";
        }
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && (line.substring(1).equals(type) || line.substring(1).equals(String.valueOf(type) + ":01") || line.substring(1).equals(String.valueOf(type) + ":01:01"))) {
                return lines[i + 1].trim();
            }
            ++i;
        }
        System.out.println("no seq for " + type);
        return "";
    }

    private static File getRulesetFile(File rulesetDir, String locus) {
        if (locus.startsWith("DRB")) {
            return new File(rulesetDir, "DRB1345.fa");
        }
        return new File(rulesetDir, String.valueOf(locus) + ".fa");
    }
}

