/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConsensusSeq;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;

public class extractMajorSequence2 {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File assemblyRoot = new File(args[1]);
        File logFile = new File(args[2]);
        File outFile = new File(args[3]);
        String[] lines = FileManager.readTextFile(input).split("\n");
        StringBuilder out = new StringBuilder();
        StringBuilder log = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            log.append(line.trim());
            if (line.trim().length() != 0) {
                String[] items = line.trim().split(",");
                File fosmidDir = new File(new File(new File(assemblyRoot, items[3].trim()), "temAssemblies"), items[2].trim());
                System.out.println(items[2].trim());
                if (!(fosmidDir.exists() && fosmidDir.isDirectory() || (fosmidDir = new File(new File(new File(assemblyRoot, items[3].trim()), "temAssemblies"), "CII_" + items[2].trim())).exists() && fosmidDir.isDirectory())) {
                    System.out.println("skip " + line + " " + fosmidDir.getAbsolutePath());
                } else {
                    extractMajorSequence2.parseConsense(fosmidDir, items[2].trim(), log, out);
                    log.append("\n");
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(logFile, log.toString(), true);
        FileManager.writeTextFile(outFile, out.toString(), true);
    }

    public static void parseConsense(File assemblyTopDir, String name, StringBuilder log, StringBuilder out) throws Exception {
        File aceFile = extractMajorSequence2.getLatestAceFile(new File(assemblyTopDir, "assembly"));
        if (aceFile == null) {
            System.out.println("assemblyTopDir.getName(), No Ace File");
            log.append(",").append("No Ace File");
            return;
        }
        log.append(",").append(aceFile.getName());
        List<ConsensusSeq> consensusSeqs = extractMajorSequence2.readAceFile(aceFile, log);
        log.append(",");
        int index = 1;
        for (ConsensusSeq consensusSeq : consensusSeqs) {
            log.append(consensusSeq.getSequence().getPadded().length()).append("/");
            out.append(">").append(String.valueOf(name) + "_" + index).append("\n");
            out.append(consensusSeq.getSequence().getPadded()).append("\n");
            ++index;
        }
    }

    private static List<ConsensusSeq> readAceFile(File aceFile, StringBuilder log) {
        ArrayList<ConsensusSeq> sequences = new ArrayList<ConsensusSeq>();
        ArrayList<String> contigs = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(aceFile).split("\n");
        String contig = null;
        log.append(",");
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.startsWith("CO Contig") && Integer.valueOf((items = line.trim().split("\\s+"))[2]) >= 5000) {
                contig = items[1].trim();
                contigs.add(contig);
                log.append(contig).append("/");
            }
            ++n2;
        }
        for (String con : contigs) {
            ConsensusSeq consensusSeq = extractMajorSequence2.getContig(lines, con, log);
            sequences.add(consensusSeq);
        }
        return sequences;
    }

    private static ConsensusSeq getContig(String[] lines, String contig, StringBuilder log) {
        ConsensusSeq consensusSeq = new ConsensusSeq();
        StringBuilder seq = new StringBuilder();
        StringBuilder qualSeq = new StringBuilder();
        boolean inParsingBlock = false;
        int i = 0;
        while (i < lines.length) {
            int j;
            if (lines[i].startsWith("CO " + contig + " ") && !inParsingBlock) {
                System.out.println("> " + contig);
                inParsingBlock = true;
                j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("BQ")) {
                        i = j - 1;
                        break;
                    }
                    seq.append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setPadded(seq.toString().replaceAll("\\*", ""));
            } else if (lines[i].trim().startsWith("BQ") && inParsingBlock) {
                j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("AF")) {
                        i = j - 1;
                        break;
                    }
                    qualSeq.append(" ").append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setQual(qualSeq.toString().trim().split("\\s+"));
            } else if (lines[i].startsWith("CO " + contig + " ") && inParsingBlock) break;
            ++i;
        }
        return consensusSeq;
    }

    public static File getLatestAceFile(File assemblyDir) {
        File[] afns = assemblyDir.listFiles();
        int index = 0;
        String name = null;
        File[] fileArray = afns;
        int n = afns.length;
        int n2 = 0;
        while (n2 < n) {
            int thisIndex;
            String[] items;
            File afn = fileArray[n2];
            if (afn.getName().indexOf(".fasta.screen.ace.") > -1 && (items = afn.getName().split("\\."))[items.length - 1].length() <= 2 && (thisIndex = Integer.valueOf(items[items.length - 1]).intValue()) > index) {
                index = thisIndex;
                name = items[0];
            }
            ++n2;
        }
        if (index == 0) {
            return null;
        }
        File lastestAce = new File(assemblyDir, String.valueOf(name) + ".fasta.screen.ace." + index);
        return lastestAce;
    }
}

