/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.beans.Encoder;
import java.beans.ExceptionListener;
import java.beans.Expression;
import java.beans.PersistenceDelegate;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class XMLUtility {
    private static final String NEW = "new";
    private static final String UTF_8 = "UTF-8";

    public static String toXMLString(Object object) {
        return XMLUtility.encode(object);
    }

    public static void call() {
        System.out.println("herer ");
    }

    public static void toXML(Object object, OutputStream out) {
        XMLUtility.encode(object, out);
    }

    public static <T> T toObject(InputStream in) {
        return XMLUtility.decode(in);
    }

    public static <T> T toUncompressedObject(InputStream in) {
        return XMLUtility.decode(in);
    }

    public static String encode(Object object) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            XMLUtility.encode(object, out);
            return new String(out.toByteArray(), UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Couldn't encode object" + e);
            return null;
        }
    }

    public static void encode(Object object, OutputStream out) {
        XMLEncoder encoder = null;
        encoder = new XMLEncoder(out);
        encoder.setPersistenceDelegate(File.class, XMLUtility.getFilePersistenceDelegate());
        encoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                System.out.println("Couldn't encode object" + e);
            }
        });
        encoder.writeObject(object);
        encoder.flush();
    }

    public static <T> T decode(String xmlString) {
        try {
            byte[] bytes = xmlString.getBytes(UTF_8);
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            return XMLUtility.decode(in);
        }
        catch (UnsupportedEncodingException e) {
            System.out.println("Couldn't decode object" + e);
            return null;
        }
    }

    private static <T> T decode(InputStream in) {
        XMLDecoder decoder = null;
        decoder = new XMLDecoder(in);
        decoder.setExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                System.out.println("Couldn't decode object" + e);
            }
        });
        return (T)decoder.readObject();
    }

    private static PersistenceDelegate getFilePersistenceDelegate() {
        return new PersistenceDelegate(){

            @Override
            protected Expression instantiate(Object oldInstance, Encoder out) {
                return new Expression(oldInstance, oldInstance.getClass(), XMLUtility.NEW, new Object[]{oldInstance.toString()});
            }
        };
    }
}

