/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import misc.FileManager;

public class ValidateResolvedType {
    public static void main(String[] args) throws Exception {
        String[] data;
        File inputFile = new File(args[0]);
        System.out.println("parsing " + inputFile.getName());
        String[] stringArray = data = FileManager.readTextFile(inputFile).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (!line.startsWith("Catalog") && line.trim().length() != 0 && (items = line.split("\t")).length >= 6) {
                ValidateResolvedType.validateThisLine(items, line);
            }
            ++n2;
        }
    }

    private static void validateThisLine(String[] items, String line) {
        String locus = items[1].trim();
        String type1 = items[2].trim();
        String type2 = items[3].trim();
        String resolvedType1 = items[4].trim();
        String resolvedType2 = items[5].trim();
        String resolvedBaseName1 = ValidateResolvedType.correctName(resolvedType1);
        String resolvedBaseName2 = ValidateResolvedType.correctName(resolvedType2);
        if (!(ValidateResolvedType.isSameBaseType(type1, resolvedBaseName1) && ValidateResolvedType.isSameBaseType(type2, resolvedBaseName2) || ValidateResolvedType.isSameBaseType(type1, resolvedBaseName2) && ValidateResolvedType.isSameBaseType(type2, resolvedBaseName1))) {
            System.out.println("Not valid resolving: " + line);
        }
    }

    private static boolean isSameBaseType(String type, String rType) {
        if (type.equals(rType)) {
            return true;
        }
        return rType.indexOf(type) >= 0;
    }

    private static String correctName(String fullName) {
        String name = fullName.split("/")[0];
        String[] fields = name.split(":");
        boolean isEight = false;
        if (fields.length == 4) {
            isEight = true;
        }
        String baseName = name;
        if (isEight) {
            baseName = String.valueOf(fields[0]) + ":" + fields[1] + ":" + fields[2];
        }
        return baseName;
    }

    private static void output(File outFile, Map<String, Map<String, Map<String, Integer>>> eightDigitMap, Map<String, Map<String, Integer>> sixDigitMap, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap) {
        StringBuilder out = new StringBuilder();
        for (String locus : eightDigitMap.keySet()) {
            out.append("locus").append("\t").append(locus).append("\n");
            out.append("8digitResolving\n");
            out.append("TypeGroup").append("\t").append("ResolvedType").append("\t").append("count").append("\t").append("incompleteCoverageTypeCount").append("\t").append("incompleteCoverageSampleName").append("\n");
            Map<String, Map<String, Integer>> baseTypeMap = eightDigitMap.get(locus);
            for (String baseType : baseTypeMap.keySet()) {
                Map<String, Integer> countMap = baseTypeMap.get(baseType);
                for (String resolvedType : countMap.keySet()) {
                    out.append(baseType).append("\t").append(resolvedType).append("\t").append(countMap.get(resolvedType)).append("\t");
                    if (incompleteCountMap.containsKey(resolvedType)) {
                        out.append(incompleteCountMap.get(resolvedType)).append("\t").append(incompleteSampleMap.get(resolvedType).toString()).append("\n");
                        continue;
                    }
                    out.append("").append("\t").append("").append("\n");
                }
            }
            out.append("6digitCount\n");
            out.append("Type").append("\t").append("count\t").append("incompleteCoverageTypeCount").append("\t").append("incompleteCoverageSampleName").append("\n");
            Map<String, Integer> typeMap = sixDigitMap.get(locus);
            for (String baseType : typeMap.keySet()) {
                if (baseType.trim().length() == 0) {
                    out.append("NoResolvingType").append("\t").append(typeMap.get(baseType)).append("\t");
                    if (incompleteCountMap.containsKey(baseType)) {
                        out.append(incompleteCountMap.get(baseType)).append("\t").append(incompleteSampleMap.get(baseType)).append("\n");
                        continue;
                    }
                    out.append("").append("\t").append("").append("\n");
                    continue;
                }
                out.append(baseType).append("\t").append(typeMap.get(baseType)).append("\t");
                if (incompleteCountMap.containsKey(baseType)) {
                    out.append(incompleteCountMap.get(baseType)).append("\t").append(incompleteSampleMap.get(baseType)).append("\n");
                    continue;
                }
                out.append("").append("\t").append("").append("\n");
            }
            out.append("\n");
        }
        System.out.println(out.toString());
        FileManager.writeTextFile(outFile, out.toString(), true);
    }

    private static void parseThisLine(String[] items, Map<String, Map<String, Map<String, Integer>>> eightDigitMap, Map<String, Map<String, Integer>> sixDigitMap, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap, String line) {
        String locus = items[1].trim();
        String type1 = items[2].trim();
        String type2 = items[3].trim();
        String warning1 = "";
        String warning2 = "";
        if (items.length > 4) {
            warning1 = items[4].trim();
        }
        if (items.length > 5) {
            warning2 = items[5].trim();
        }
        if (!eightDigitMap.containsKey(locus)) {
            eightDigitMap.put(locus, new TreeMap());
            sixDigitMap.put(locus, new TreeMap());
        }
        ValidateResolvedType.processType(type1, eightDigitMap.get(locus), sixDigitMap.get(locus), line, 1);
        ValidateResolvedType.processWarning(items[0].trim(), incompleteCountMap, incompleteSampleMap, type1, warning1);
        if (!type1.equals(type2)) {
            ValidateResolvedType.processType(type2, eightDigitMap.get(locus), sixDigitMap.get(locus), line, 2);
            ValidateResolvedType.processWarning(items[0].trim(), incompleteCountMap, incompleteSampleMap, type2, warning2);
        }
    }

    private static void processWarning(String name, Map<String, Integer> incompleteCountMap, Map<String, List<String>> incompleteSampleMap, String type, String warning) {
        if (warning.indexOf("incomplete coverage") > 0) {
            if (!incompleteCountMap.containsKey(type)) {
                incompleteCountMap.put(type, 0);
                incompleteSampleMap.put(type, new ArrayList());
            }
            incompleteCountMap.put(type, incompleteCountMap.get(type) + 1);
            incompleteSampleMap.get(type).add(name.trim());
        }
    }

    private static void processType(String type, Map<String, Map<String, Integer>> eightDigitTypeMap, Map<String, Integer> sixDigitTypeMap, String line, int index) {
        String name = type.split("/")[0];
        String[] fields = name.split(":");
        boolean isEight = false;
        if (fields.length == 4) {
            isEight = true;
        }
        if (isEight) {
            String baseName = String.valueOf(fields[0]) + ":" + fields[1] + ":" + fields[2];
            if (!eightDigitTypeMap.containsKey(baseName)) {
                eightDigitTypeMap.put(baseName, new TreeMap());
            }
            if (!eightDigitTypeMap.get(baseName).containsKey(type)) {
                eightDigitTypeMap.get(baseName).put(type, 0);
            }
            int count = eightDigitTypeMap.get(baseName).get(type) + 1;
            eightDigitTypeMap.get(baseName).put(type, count);
        } else {
            if (type.trim().length() == 0) {
                String[] items = line.split("\t");
                type = items[index + 3].trim();
            }
            if (!sixDigitTypeMap.containsKey(type)) {
                sixDigitTypeMap.put(type, 0);
            }
            int count = sixDigitTypeMap.get(type) + 1;
            sixDigitTypeMap.put(type, count);
        }
    }
}

