/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class Temp {
    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File geneAnnotationFile = new File(args[1]);
        File cdnaFastaFile = new File(args[2]);
        File cdnaAnnotationFile = new File(args[3]);
        Map<String, String> map = Temp.getFastaMap(fastaFile);
        StringBuilder builder = new StringBuilder();
        LinkedHashMap<String, String> cdnaMap = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(geneAnnotationFile).split("\n");
        int i = 1;
        while (i < data.length) {
            String[] items = data[i].split(",");
            String name = items[0].trim();
            String cdnaSeq = Temp.cutSeq(map.get(name), items, builder, name);
            cdnaMap.put(name, cdnaSeq);
            ++i;
        }
        Temp.writeFastaOutput(cdnaMap, cdnaFastaFile);
        FileManager.writeTextFile(cdnaAnnotationFile, builder.toString(), true);
    }

    private static void parseExon(String[] info, String gSeq, StringBuilder seqBuilder, StringBuilder builder) {
        if (info[0].trim().length() > 0) {
            int start = Integer.valueOf(info[0].trim());
            int end = Integer.valueOf(info[1].trim());
            String exon = gSeq.substring(start - 1, end);
            seqBuilder.append(exon);
            int newStart = seqBuilder.indexOf(exon) + 1;
            int newEnd = newStart + exon.length() - 1;
            builder.append(newStart).append(",");
            builder.append(newEnd).append(",");
            builder.append(info[2].trim()).append(",");
        } else {
            builder.append("").append(",");
            builder.append("").append(",");
            builder.append("").append(",");
        }
    }

    private static String cutSeq(String gSeq, String[] items, StringBuilder builder, String name) {
        String tail;
        builder.append(name).append(",");
        StringBuilder seqBuilder = new StringBuilder();
        String[] info = new String[]{items[1], items[2], items[3]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[4], items[5], items[6]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[7], items[8], items[9]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[10], items[11], items[12]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[13], items[14], items[15]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[16], items[17], items[18]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        info = new String[]{items[19], items[20], items[21]};
        Temp.parseExon(info, gSeq, seqBuilder, builder);
        if (info[0].trim().length() > 0 && (tail = gSeq.substring(Integer.valueOf(info[1].trim()))).indexOf("GCCTGA") > 0) {
            seqBuilder.append("GCCTGA");
        }
        builder.append("\n");
        return seqBuilder.toString();
    }

    public static void writeFastaOutput(Map<String, String> cdnaMap, File cdnaFastaFile) {
        StringBuilder seqBuilder = new StringBuilder();
        for (String name : cdnaMap.keySet()) {
            String seq = cdnaMap.get(name);
            seqBuilder.append(">").append(name).append("\n");
            seqBuilder.append(seq).append("\n");
        }
        FileManager.writeTextFile(cdnaFastaFile, seqBuilder.toString(), true);
    }

    public static Map<String, String> getFastaMap(File file) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        String[] data = FileManager.readTextFile(file).split("\n");
        int i = 0;
        while (i < data.length - 1) {
            if (data[i].trim().startsWith(">")) {
                map.put(data[i].split("\\s+")[0].trim().substring(1), data[i + 1].trim());
            }
            ++i;
        }
        System.out.println(map.size());
        return map;
    }
}

