/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class StringSearchCount {
    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File seqFile = new File(args[1]);
        File output = new File(args[2]);
        LinkedHashMap<String, Map<String, Integer>> overallResult = new LinkedHashMap<String, Map<String, Integer>>();
        Object[] fastaFiles = fastaDir.listFiles();
        Arrays.sort(fastaFiles);
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (((File)fastaFile).getName().endsWith(".fa")) {
                StringSearchCount.match((File)fastaFile, seqFile, overallResult);
            }
            ++n2;
        }
        StringSearchCount.writeOutput(overallResult, output);
    }

    private static void writeOutput(Map<String, Map<String, Integer>> overallResult, File output) {
        StringBuilder out = new StringBuilder();
        out.append("Sample,");
        Map<String, Integer> one = null;
        for (String aSample : overallResult.keySet()) {
            one = overallResult.get(aSample);
            if (one != null) break;
        }
        for (String header : one.keySet()) {
            out.append(header).append(",");
        }
        out.append("\n");
        for (String aSample : overallResult.keySet()) {
            out.append(aSample).append(",");
            for (String header : overallResult.get(aSample).keySet()) {
                out.append(overallResult.get(aSample).get(header)).append(",");
            }
            out.append("\n");
        }
        FileManager.writeTextFile(output, out.toString(), true);
    }

    public static void match(File fastaFile, File kirSeqFile, Map<String, Map<String, Integer>> overallResult) {
        String[] lines = FileManager.readTextFile(kirSeqFile).split("\n");
        LinkedHashMap<String, Integer> result = new LinkedHashMap<String, Integer>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String data = stringArray[n2];
            System.out.println(data);
            String[] info = data.trim().split("\\s+");
            System.out.println(info.length);
            if (info.length >= 2) {
                String geneExon = info[0].trim();
                String f = info[1].trim();
                int count1 = 0;
                int count2 = 0;
                String cmd = "grep -o \"" + f + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
                String[] commandArray = new String[]{"bash", "-c", cmd};
                SystemCommand command = new SystemCommand(commandArray, null, true);
                command.makeItSo();
                count1 = Integer.valueOf(command.getStandardOut().trim());
                String fRevcomp = StringSearchCount.revComp(f);
                String cmd2 = "grep -o \"" + fRevcomp + "\" " + fastaFile.getAbsolutePath() + " | wc -l";
                String[] commandArray2 = new String[]{"bash", "-c", cmd2};
                SystemCommand command2 = new SystemCommand(commandArray2, null, true);
                command2.makeItSo();
                count2 = Integer.valueOf(command2.getStandardOut().trim());
                result.put(geneExon, count1 + count2);
            }
            ++n2;
        }
        overallResult.put(StringSearchCount.formatName(fastaFile.getName()), result);
    }

    private static String formatName(String name) {
        String newName = name.substring(0, name.lastIndexOf("-"));
        return newName;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(StringSearchCount.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

