/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.Fosmid;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import misc.FileManager;

public class StatisticSummary {
    public static void main(String[] args) throws Exception {
        File fastaDir = new File(args[0]);
        File topAssemblyRoot = new File(args[1]);
        File velvetDir = new File(args[2]);
        File summaryFile = new File(args[3]);
        Object[] fastaFiles = fastaDir.listFiles();
        Arrays.sort(fastaFiles);
        StringBuilder builder = new StringBuilder();
        ArrayList<Fosmid> fosmids = new ArrayList<Fosmid>();
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (!((File)fastaFile).getName().endsWith("fa")) {
                System.out.println("Skip " + ((File)fastaFile).getName());
            } else {
                System.out.println(((File)fastaFile).getName());
                Fosmid fosmid = new Fosmid();
                fosmid.setName(StatisticSummary.extractName(((File)fastaFile).getName()));
                StatisticSummary.setMiseqFeature((File)fastaFile, fosmid);
                StatisticSummary.setVelvetSize(velvetDir, fosmid);
                StatisticSummary.setAssemblySize(topAssemblyRoot, fosmid);
                fosmids.add(fosmid);
            }
            ++n2;
        }
        StatisticSummary.generateSummary(fosmids, summaryFile);
    }

    private static void setAssemblySize(File topAssemblyRoot, Fosmid fosmid) {
        File[] files;
        File[] fileArray = files = topAssemblyRoot.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fn = fileArray[n2];
            if (fn.getName().equals(fosmid.getName()) && fn.isDirectory()) {
                File[] afns;
                File assemblyDir = new File(fn, "assembly");
                int index = 0;
                File[] fileArray2 = afns = assemblyDir.listFiles();
                int n3 = afns.length;
                int n4 = 0;
                while (n4 < n3) {
                    String[] items;
                    int thisIndex;
                    File afn = fileArray2[n4];
                    if (afn.getName().startsWith(String.valueOf(fosmid.getName()) + ".fasta.screen.ace.") && !afn.getName().endsWith("wrk") && !afn.getName().endsWith("aview") && (thisIndex = Integer.valueOf((items = afn.getName().split("\\."))[items.length - 1]).intValue()) > index) {
                        index = thisIndex;
                    }
                    ++n4;
                }
                if (index == 0) {
                    return;
                }
                File lastestAce = new File(assemblyDir, String.valueOf(fosmid.getName()) + ".fasta.screen.ace." + index);
                StatisticSummary.setAceProperty(lastestAce, fosmid);
                break;
            }
            ++n2;
        }
    }

    private static void setAceProperty(File lastestAce, Fosmid fosmid) {
        String[] lines = FileManager.readTextFile(lastestAce).split("\n");
        int nodeCount = 0;
        int coverage = 0;
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.startsWith("CO Contig") && Integer.valueOf((items = line.trim().split("\\s+"))[2]) >= 500 && Integer.valueOf(items[3]) >= 25) {
                ++nodeCount;
                int size = Integer.valueOf(items[2]);
                coverage += size;
                sizes.add(size);
            }
            ++n2;
        }
        Object[] num = sizes.toArray();
        Arrays.sort(num);
        String thisSize = "";
        int count = 0;
        int i = sizes.size() - 1;
        while (i >= 0) {
            thisSize = String.valueOf(thisSize) + num[i] + "/";
            if (++count >= 5) break;
            --i;
        }
        fosmid.setPhredContigCount(nodeCount);
        fosmid.setPhredOverallSize(coverage);
        fosmid.setPhredContigSizes(thisSize);
    }

    private static void setVelvetSize(File velvetDir, Fosmid fosmid) {
        File[] files;
        File[] fileArray = files = velvetDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File fn = fileArray[n2];
            if (fn.getName().startsWith(fosmid.getName()) && fn.getName().endsWith("contigs.fa")) {
                String[] lines = FileManager.readTextFile(fn).split("\n");
                int nodeCount = 0;
                int coverage = 0;
                String[] stringArray = lines;
                int n3 = lines.length;
                int n4 = 0;
                while (n4 < n3) {
                    String line = stringArray[n4];
                    if (line.startsWith(">")) {
                        ++nodeCount;
                        int size = Integer.valueOf(line.split("_")[3]);
                        coverage += size;
                    }
                    ++n4;
                }
                fosmid.setVelvetContigCount(nodeCount);
                fosmid.setVelvetOverallSize(coverage);
                break;
            }
            ++n2;
        }
    }

    private static void setMiseqFeature(File fastaFile, Fosmid fosmid) {
        String content = FileManager.readTextFile(fastaFile);
        String header = null;
        if (content.length() >= 7) {
            header = content.substring(0, 7);
            int size = content.split(header).length - 1;
            fosmid.setReadCount(size);
            return;
        }
        fosmid.setReadCount(0);
    }

    private static String extractName(String name) {
        String item = name.split("\\.")[0];
        return item.substring(0, item.length() - 3);
    }

    private static void generateSummary(List<Fosmid> fosmids, File summaryFile) {
        StringBuilder builder = new StringBuilder();
        builder.append("FosmidName\t").append("PhredContigs>=500bpN>=25\t").append("PhredOverallSize\t").append("PhredIndivitualContigSize\t").append("VelvetContigs>=500bp\t").append("VelvetOverallSize\t").append("MiSeqReadCount\n");
        for (Fosmid fosmid : fosmids) {
            builder.append(fosmid.getName()).append("\t");
            builder.append(fosmid.getPhredContigCount()).append("\t");
            builder.append(fosmid.getPhredOverallSize()).append("\t");
            builder.append(fosmid.getPhredContigSizes()).append("\t");
            builder.append(fosmid.getVelvetContigCount()).append("\t");
            builder.append(fosmid.getVelvetOverallSize()).append("\t");
            builder.append(fosmid.getReadCount()).append("\n");
        }
        FileManager.writeTextFile(summaryFile, builder.toString(), true);
    }
}

