/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ScreenVectorSeq {
    static int buffer = 25;

    public static void main(String[] args) throws Exception {
        File root = new File(args[0]);
        File destRoot = new File(args[1]);
        File[] files = root.listFiles();
        StringBuilder log = new StringBuilder();
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            File genbankFile;
            File file = fileArray[n2];
            if (file.getName().endsWith(".fa") && (genbankFile = new File(root, String.valueOf(name = file.getName().substring(0, file.getName().length() - 3)) + "-HitTable.csv")).exists()) {
                System.out.println(">>>>>>>>>>>>>>>>>>>" + file.getName());
                Map<String, List<MatchUnit>> records = ScreenVectorSeq.screenVectors(file, root);
                ScreenVectorSeq.fixSequence(records, file, root, destRoot, log);
            }
            ++n2;
        }
        File logFile = new File(destRoot, "vectors.log");
        FileManager.writeTextFile(logFile, log.toString(), true);
    }

    private static void fixSequence(Map<String, List<MatchUnit>> records, File fasta, File root, File destRoot, StringBuilder log) {
        Map<String, String> fastas = ScreenVectorSeq.getSequences(fasta);
        HashMap<String, String> newfastas = new HashMap<String, String>();
        for (String fosmid : fastas.keySet()) {
            if (records.containsKey(fosmid)) {
                newfastas.put(fosmid, ScreenVectorSeq.fixSeq(fastas.get(fosmid), records.get(fosmid), log, fosmid));
                continue;
            }
            newfastas.put(fosmid, fastas.get(fosmid));
        }
        ScreenVectorSeq.writeOutput(newfastas, destRoot, fasta.getName());
    }

    private static void writeOutput(Map<String, String> newfastas, File destRoot, String name) {
        File out = new File(destRoot, name);
        StringBuilder seq = new StringBuilder();
        Object[] fosmids = newfastas.keySet().toArray();
        Arrays.sort(fosmids);
        Object[] objectArray = fosmids;
        int n = fosmids.length;
        int n2 = 0;
        while (n2 < n) {
            Object fosmid = objectArray[n2];
            if (newfastas.get((String)fosmid).trim().length() <= 200) {
                System.out.println("short seq " + (String)fosmid);
            } else {
                seq.append(">").append((String)fosmid).append("\n");
                seq.append(newfastas.get((String)fosmid)).append("\n");
            }
            ++n2;
        }
        FileManager.writeTextFile(out, seq.toString(), true);
    }

    private static String fixSeq(String fasta, List<MatchUnit> list, StringBuilder log, String fosmid) {
        String newFasta = fasta;
        for (MatchUnit unit : list) {
            int start = unit.getMatchStart();
            int end = unit.getMatchEnd();
            if (start <= 50) {
                start = 1;
            }
            if (fasta.length() - 50 <= end) {
                end = fasta.length();
            }
            newFasta = String.valueOf(newFasta.substring(0, start - 1)) + ScreenVectorSeq.getX(end - start + 1) + newFasta.substring(end);
            log.append(">").append(fosmid).append("-").append(start).append(end).append("\n");
            log.append(fasta.substring(start - 1, end)).append("\n");
            System.out.println("fix " + fosmid);
        }
        return newFasta.replaceAll("X", "");
    }

    private static String getX(int count) {
        String ret = "";
        int i = 0;
        while (i < count) {
            ret = String.valueOf(ret) + "N";
            ++i;
        }
        return ret;
    }

    private static Map<String, List<MatchUnit>> screenVectors(File fasta, File root) {
        String name = fasta.getName().substring(0, fasta.getName().length() - 3);
        File genbankFile = new File(root, String.valueOf(name) + "-HitTable.csv");
        Map<String, String> fastas = ScreenVectorSeq.getSequences(fasta);
        Map<String, List<MatchUnit>> records = ScreenVectorSeq.parseHitTable(genbankFile, fastas);
        for (String fosmid : records.keySet()) {
            System.out.println("------------" + fosmid);
            for (MatchUnit unit : records.get(fosmid)) {
                System.out.println(String.valueOf(unit.getMatchStart()) + " " + unit.getMatchEnd());
            }
        }
        return records;
    }

    private static Map<String, List<MatchUnit>> parseHitTable(File genbankFile, Map<String, String> fastas) {
        LinkedHashMap<String, List<MatchUnit>> records = new LinkedHashMap<String, List<MatchUnit>>();
        String[] lines = FileManager.readTextFile(genbankFile).split("\n");
        Map<String, List<MatchUnit>> allRecords = ScreenVectorSeq.getAllRecord(lines);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split(",");
            if (items.length < 12) {
                System.out.println("skip " + line);
            } else {
                String name = items[0].trim();
                int size = Integer.valueOf(items[3]);
                int start = Integer.valueOf(items[6]);
                int end = Integer.valueOf(items[7]);
                int misMatch1 = Integer.valueOf(items[4]);
                int misMatch2 = Integer.valueOf(items[5]);
                if (start > end) {
                    int swap = end;
                    end = start;
                    start = swap;
                }
                boolean isTerminal = ScreenVectorSeq.checkPosition(start, end, fastas.get(name).length());
                boolean isMatch = false;
                if (isTerminal && size >= 16) {
                    isMatch = true;
                } else if (!isTerminal && size - misMatch1 - misMatch2 >= 23) {
                    isMatch = true;
                }
                if (isMatch) {
                    ScreenVectorSeq.addToRecords(records, name, isMatch, start, end);
                }
            }
            ++n2;
        }
        return records;
    }

    private static Map<String, List<MatchUnit>> getAllRecord(String[] lines) {
        LinkedHashMap<String, List<MatchUnit>> records = new LinkedHashMap<String, List<MatchUnit>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.split(",");
            if (items.length < 12) {
                System.out.println("skip " + line);
            } else {
                int end;
                String name = items[0].trim();
                int start = Integer.valueOf(items[6]);
                if (start > (end = Integer.valueOf(items[7]).intValue())) {
                    int swap = end;
                    end = start;
                    start = swap;
                }
                if (!records.containsKey(name)) {
                    records.put(name, new ArrayList());
                }
                MatchUnit newMatch = new MatchUnit(start, end);
                ((List)records.get(name)).add(newMatch);
            }
            ++n2;
        }
        return records;
    }

    private static void addToRecords(Map<String, List<MatchUnit>> records, String name, boolean isMatch, int start, int end) {
        if (!records.containsKey(name)) {
            records.put(name, new ArrayList());
            MatchUnit newMatch = new MatchUnit(start, end);
            records.get(name).add(newMatch);
            return;
        }
        boolean doAdd = false;
        for (MatchUnit unit : records.get(name)) {
            if (start == unit.getMatchStart() && end == unit.getMatchEnd()) {
                doAdd = false;
                break;
            }
            if (start <= unit.getMatchStart() && end >= unit.getMatchStart()) {
                unit.setMatchStart(start);
                unit.setMatchEnd(Math.max(end, unit.getMatchEnd()));
                doAdd = false;
                break;
            }
            if (start <= unit.getMatchEnd() && end >= unit.getMatchEnd()) {
                unit.setMatchStart(Math.min(start, unit.getMatchStart()));
                unit.setMatchEnd(end);
                doAdd = false;
                break;
            }
            if (start >= unit.getMatchStart() && end <= unit.getMatchEnd()) {
                doAdd = false;
                break;
            }
            doAdd = true;
        }
        if (doAdd) {
            MatchUnit newMatch = new MatchUnit(start, end);
            records.get(name).add(newMatch);
        }
    }

    private static boolean checkPosition(int start, int end, int size) {
        if (start <= 100) {
            return true;
        }
        return size - 100 < end;
    }

    private static Map<String, String> getSequences(File fastaFile) {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = ScreenVectorSeq.getSeq(i + 1, lines);
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static String getSeq(int index, String[] lines) {
        StringBuilder seq = new StringBuilder();
        int i = index;
        while (i < lines.length) {
            if (lines[i].startsWith(">")) {
                return seq.toString();
            }
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }
}

