/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;
import misc.OsHelper;
import misc.StringUtils;
import misc.SystemCommand;

public class PickPrimerNewMethod {
    private static int SIZE = 2000;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File primerFile = new File(args[1]);
        int offset = new Integer(args[2]);
        File inputFile = File.createTempFile("input", ".txt");
        File tmpFile = File.createTempFile("output", ".txt");
        String sequence = PickPrimerNewMethod.getSequenceFromFasta(fastaFile);
        StringBuffer outputPrimers = new StringBuffer();
        outputPrimers.append("Downstream Primer_3\tUpstream Primer_5\tDownstream Primer End\tUpstream Primer Start\tDownstream Primer Tm\tUpstream Primer Tm\tAmplicon Size between\n");
        int count = sequence.length() / SIZE;
        int i = 0;
        while (i < count) {
            int start = i * SIZE + 1;
            StringBuffer buffer = new StringBuffer();
            buffer.append("PRIMER_SEQUENCE_ID=mySequence\n");
            buffer.append("SEQUENCE=").append(sequence).append("\n");
            buffer.append("INCLUDED_REGION=").append(start).append(",").append(SIZE).append("\n");
            buffer.append("PRIMER_PRODUCT_SIZE_RANGE=158-163 152-168\n");
            buffer.append("PRIMER_OPT_SIZE=21\n");
            buffer.append("PRIMER_MIN_SIZE=18\n");
            buffer.append("PRIMER_MAX_SIZE=22\n");
            buffer.append("PRIMER_OPT_TM=58.0\n");
            buffer.append("PRIMER_MIN_TM=45.0\n");
            buffer.append("PRIMER_MAX_TM=65.0\n");
            buffer.append("PRIMER_MAX_DIFF_TM=20\n");
            buffer.append("PRIMER_DNA_CONC=0.25\n");
            buffer.append("PRIMER_SALT_CONC=50.0\n");
            buffer.append("PRIMER_SELF_ANY=5\n");
            buffer.append("PRIMER_SELF_END=5\n");
            buffer.append("PRIMER_MAX_POLY_X=7\n");
            buffer.append("PRIMER_NUM_RETURN=2\n");
            buffer.append("PRIMER_FIRST_BASE_INDEX=1\n");
            buffer.append("PRIMER_MAX_END_STABILITY=20\n");
            buffer.append("=\n");
            System.out.println(inputFile.getAbsolutePath());
            FileManager.writeTextFile(inputFile, buffer.toString(), true);
            String cmd = "/genome/bin/primer3_core < " + inputFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
            String[] acmd = new String[]{"/bin/sh", "-c", cmd};
            SystemCommand systemCommand = new SystemCommand(acmd, inputFile.getParentFile(), false);
            systemCommand.makeItSo();
            OsHelper.excuteCommand(cmd);
            System.out.println(cmd);
            outputPrimers.append(PickPrimerNewMethod.parseOutput(FileManager.readTextFile(tmpFile), offset));
            ++i;
        }
        FileManager.writeTextFile(primerFile, outputPrimers.toString(), true);
    }

    private static String parseOutput(String output, int offset) {
        StringBuffer buffer = new StringBuffer();
        String[] data = output.trim().split("\n");
        boolean find = false;
        int leftLength = 0;
        int rightLength = 0;
        int productSize = 0;
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String seq;
            String info = stringArray[n2];
            if (info.startsWith("PRIMER_LEFT_SEQUENCE=")) {
                System.out.println("find primer");
                seq = info.split("=")[1].trim();
                leftLength = seq.length();
                buffer.append(seq);
            }
            if (info.startsWith("PRIMER_RIGHT_SEQUENCE=")) {
                seq = StringUtils.revCompSeq(info.split("=")[1].trim());
                rightLength = seq.length();
                buffer.append("\t").append(seq);
            }
            if (info.startsWith("PRIMER_LEFT=")) {
                buffer.append("\t").append(new Integer(info.split("=")[1].split(",")[0].trim()) + leftLength + offset);
            }
            if (info.startsWith("PRIMER_RIGHT=")) {
                buffer.append("\t").append(new Integer(info.split("=")[1].split(",")[0].trim()) - rightLength + offset);
            }
            if (info.startsWith("PRIMER_LEFT_TM=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_RIGHT_TM=")) {
                buffer.append("\t").append(info.split("=")[1].trim());
            }
            if (info.startsWith("PRIMER_PRODUCT_SIZE=")) {
                productSize = new Integer(info.split("=")[1].trim());
                buffer.append("\t").append(productSize - rightLength - leftLength).append("\n");
            }
            ++n2;
        }
        return buffer.toString();
    }

    private static String getSequenceFromFasta(File fasta) {
        String[] lines = FileManager.readTextFile(fasta).split("\n");
        StringBuilder seq = new StringBuilder();
        int i = 1;
        while (i < lines.length) {
            seq.append(lines[i].trim());
            ++i;
        }
        return seq.toString();
    }
}

