/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchParameters;
import fileOperation.ParseFastaByHapType8;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Arrays;

public class ParseFastaByHapTypeWraper8 {
    public static void main(String[] args) throws Exception {
        File fastaFileRoot = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputRoot = new File(args[2]);
        File outputFile = new File(args[3]);
        double mismatchAllowed = new Double(args[4]);
        int misPenalty = new Integer(args[5]);
        int matchMinScore = new Integer(args[6]);
        int readSize = new Integer(args[7]);
        boolean alignType = new Boolean(args[8]);
        boolean isPrimerMaskOff = new Boolean(args[9]);
        boolean drawImage = new Boolean(args[10]);
        boolean useUnique = new Boolean(args[11]);
        StringBuilder result = new StringBuilder();
        result.append("Sample\t").append("locus\t").append("Hap Type\t").append("#Pairs Support Match\t").append("#Pairs Perfect Match\t").append("#Positions w >=10x Coverage\t").append("Positions w >50% mismatch\t").append("#Pairs Completely Cover Exon\t").append("#Bridge Reads\t").append("index\n");
        ParseFastaByHapTypeWraper8.appendToFile(result, outputFile);
        MatchParameters mp = new MatchParameters();
        mp.setMismatchAllowed(mismatchAllowed);
        mp.setMatchMinScore(matchMinScore);
        mp.setMisPenalty(misPenalty);
        mp.setReadSize(readSize);
        mp.setAlignType(alignType);
        mp.setPrimerMaskOff(isPrimerMaskOff);
        mp.setDrawImage(drawImage);
        mp.setUseHash(useUnique);
        Object[] fastaFiles = fastaFileRoot.listFiles();
        Arrays.sort(fastaFiles);
        Object[] objectArray = fastaFiles;
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            Object fastaFile = objectArray[n2];
            if (((File)fastaFile).getName().endsWith(".fa")) {
                System.out.println(">>>>>>>>>>>>>>>>>>>Typing for " + ParseFastaByHapTypeWraper8.getSampleName((File)fastaFile) + "<<<<<<<<<<<<<<<<<<");
                System.out.println("memory usage start one fasta: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                result = new StringBuilder();
                ParseFastaByHapType8.startType((File)fastaFile, hapTypeRoot, new File(outputRoot, String.valueOf(ParseFastaByHapTypeWraper8.getSampleName((File)fastaFile)) + ".txt"), outputRoot, ParseFastaByHapTypeWraper8.getSampleName((File)fastaFile), result, mp);
                ParseFastaByHapTypeWraper8.appendToFile(result, outputFile);
                System.out.println("memory usage finish one fasta: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
            }
            ++n2;
        }
        System.out.println("Typing Done");
    }

    private static String getSampleName(File fastaFile) {
        String[] items = fastaFile.getName().split("-");
        String del = items[items.length - 1];
        return fastaFile.getName().substring(0, fastaFile.getName().length() - del.length() - 1);
    }

    private static void appendToFile(StringBuilder result, File targetFile) throws Exception {
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(result.toString());
        writer.close();
    }
}

