/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.AlleleDropOffLog;
import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.Discrepancy;
import fileOperation.MatchParameters;
import fileOperation.MatchStatistics;
import fileOperation.OneMatch;
import fileOperation.SummarizeTypingResult;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.FileImageOutputStream;
import misc.FileManager;
import misc.StringUtils;
import misc.SystemCommand;

public class ParseFastaByHapType7 {
    private static final int PRIMER_SIZE = 18;
    private static final int MIN_HIT = 10;
    static String LABEL = "000000";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int COVERAGE_CUTOFF = 10;
    static int IMAGE_TO_DRAW = 10;
    private static final int IMAGE_HEIGHT = 1000;
    private static final int IMAGE_SEQUENCE_POSITION = 450;
    private static final int IMAGE_WIDTH = 1000;
    private static final int IMAGE_SEQUENCE_BAR_HEIGHT = 10;
    private static final int INDEX_SPACE = 16;
    private static final int INDEX_POSITION = 424;
    private static final int LETTER_WIDTH = 8;
    private static final int DEEPTH_HEIGHT = 400;
    private static final int LABEL_POSITION = 650;
    private static final int AMPLICON_TO_DRAW = 100;
    private static final int AMPLICON_HEIGHT = 400;
    private static String DRB1_07_SPECIFIC = "TTCCTGTGGCAGGG";
    private static String DPB1_DROP_SPECIFIC = "GTG.ACCAGTT";
    private static String DPB1_DROP_CASE1 = "GTGTACCAGTT";
    private static String DPB1_DROP_CASE2 = "GTGCACCAGTT";
    private static String DPB1_DROP_CASE3 = "GTGGACCAGTT";
    private static String DPB1_DROP_STABLE = "CCAGTT";
    private static String DPB1_DROP_GROUP1 = "CGTGTACCAGTT";
    private static String DPB1_DROP_GROUP2 = "CGTGCACCAGTT";
    private static String DPB1_DROP_SPECIAL1 = "AGTGTACCAGTT";
    private static String DPB1_DROP_SPECIAL2 = "CGTGGACCAGTT";
    private static final int COUNT_CUTOFF = 25;
    private static final int DRB1_07_STABLE_SIZE = 22;
    private static String DRB1_07_SPECIFIC2 = "AAGTATAAGTGTCATTT";
    private static String DRB1_07_SPECIFIC3 = "TTCAACGGG";
    private static final int DRB1_07_STABLE_SIZE_EXTENSION = 47;
    private static final String[] DRB1_07_SPECIFIC23_EXCLUDING = new String[]{"DRB1*07:22", "DRB1*07:01:02", "DRB1*07:21"};
    private static final int RESULT_NUM_OUTPUT = 20;
    private static final int MIN_PAIRS_COMPLETE_COVERAGE_COUNT = 5;
    private static final boolean INCLUDE_BRIDGE_READS = true;
    private static final int EXON_BOUNDARY = 270;
    private static final int PARTITION_SIZE = 10000;
    private static final boolean INGNORE_MISMATCH_AT_PRIMER_SITE = true;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputFile = new File(args[2]);
        File outputImageDir = new File(args[3]);
        String name = new String(args[4]);
        double mismatchAllowed = new Double(args[5]);
        int misPenalty = new Integer(args[6]);
        int matchMinScore = new Integer(args[7]);
        int readSize = new Integer(args[8]);
        boolean alignType = new Boolean(args[9]);
        boolean isPrimerMaskOff = new Boolean(args[10]);
        boolean drawImage = new Boolean(args[11]);
        MatchParameters mp = new MatchParameters();
        mp.setMismatchAllowed(mismatchAllowed);
        mp.setMatchMinScore(matchMinScore);
        mp.setMisPenalty(misPenalty);
        mp.setReadSize(readSize);
        mp.setAlignType(alignType);
        mp.setPrimerMaskOff(isPrimerMaskOff);
        mp.setDrawImage(drawImage);
        StringBuilder result = new StringBuilder();
        long startTime = System.currentTimeMillis();
        ParseFastaByHapType7.startType(fastaFile, hapTypeRoot, outputFile, outputImageDir, name, result, mp);
        System.out.println(result.toString());
    }

    public static void startType(File fastaFile, File hapTypeRoot, File outputFile, File outputImageDir, String name, StringBuilder resultSummary, MatchParameters mp) throws Exception {
        File[] hapFiles;
        System.out.println("memory usage 000: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
        HashMap<String, String> inputSequences = new HashMap<String, String>();
        File newFasta = ParseFastaByHapType7.getSequenceFromFastaAndMaskPrimer(fastaFile, inputSequences, mp.isPrimerMaskOff());
        StringBuilder builder = new StringBuilder();
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                long startTime = System.currentTimeMillis();
                System.out.println("memory usage start haptype: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                AlleleDropOffLog alleleDropOffLog = new AlleleDropOffLog();
                if (hapFile.getName().startsWith("DPB1-exon2") || hapFile.getName().startsWith("DRB1345-exon2")) {
                    ParseFastaByHapType7.populateAlleleDropOffLog(inputSequences, alleleDropOffLog, hapFile.getName());
                }
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HAP_AMB_TXT);
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapType7.populateHapAmbNames(hapNames, hapAmbFile);
                }
                builder.append("\n---------").append(hapFile.getName());
                resultSummary.append("\n");
                File tmpFile = ParseFastaByHapType7.organizeFastaByHap(hapNames, hapFile);
                tmpFile.deleteOnExit();
                Map<String, String> sequences = SummarizeTypingResult.organizeSequenceFromFasta(hapNames, hapFile);
                ArrayList<String> DPBdropTypes = new ArrayList<String>();
                ArrayList<String> DPBdropGroup1Types = new ArrayList<String>();
                ArrayList<String> DPBdropGroup2Types = new ArrayList<String>();
                if (alleleDropOffLog.isDPBdropPresent()) {
                    ParseFastaByHapType7.gatherDPB1DropTypes(sequences, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types);
                }
                int exonSize = FileManager.readTextFile(tmpFile).split("\n")[1].trim().length();
                builder.append(" exon size=").append(exonSize).append("\n");
                builder.append("Hap Type\t").append("#Pairs Support Match\t").append("#Pairs Perfect Match\t").append("Average Amplicon Size\t").append("#Positions w >=8x Coverage\t").append("Positions w >30% mismatch\t").append("#Pairs Completely Cover Exon\t").append("index\n");
                File outputImage = new File(outputImageDir, String.valueOf(name) + "-" + hapFile.getName().split("\\.")[0] + ".jpg");
                System.out.println("memory usage 1 before cross_match: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                Map<String, Map<String, OneMatch>> result = ParseFastaByHapType7.getCrossMatchRecords(newFasta, tmpFile, mp, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, inputSequences, hapFile.getName());
                System.out.println("memory usage 2 after cross_match: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
                boolean needMoreTyping = ParseFastaByHapType7.output(result, hapFile, 0, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name, inputSequences, sequences, mp, alleleDropOffLog);
                if (needMoreTyping) {
                    builder.append("******* further typing based on single direction match \n");
                    ParseFastaByHapType7.output(result, hapFile, 1, builder, exonSize, outputImage, resultSummary, hapFile.getName(), name, inputSequences, sequences, mp, alleleDropOffLog);
                }
                ParseFastaByHapType7.logMethodTime("Done this type ...", System.currentTimeMillis() - startTime);
                System.out.println("memory usage end haptype: " + (double)Runtime.getRuntime().totalMemory() / 1.073741824E9);
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static void populateAlleleDropOffLog(Map<String, String> sequences, AlleleDropOffLog alleleDropOffLog, String hapName) {
        String sequence = null;
        for (String read : sequences.keySet()) {
            String name;
            String thisRead;
            sequence = sequences.get(read);
            if (hapName.startsWith("DPB1-exon2")) {
                if (sequence.indexOf(DPB1_DROP_CASE1) <= -1 && sequence.indexOf(DPB1_DROP_CASE2) <= -1 && sequence.indexOf(DPB1_DROP_CASE3) <= -1) continue;
                thisRead = ConvertFastaQdataMiSeq.generateName(read);
                name = thisRead.substring(0, thisRead.length() - 2);
                alleleDropOffLog.addNamesDPBdrop(name);
                if (sequence.indexOf(DPB1_DROP_GROUP1) > -1) {
                    alleleDropOffLog.addNamesDPBdropGroup1(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP2) > -1) {
                    alleleDropOffLog.addNamesDPBdropGroup2(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP1) > -1) {
                    alleleDropOffLog.addNamesDPBdropSpecial1(name);
                }
                if (sequence.indexOf(DPB1_DROP_GROUP1) <= -1) continue;
                alleleDropOffLog.addNamesDPBdropSpecial2(name);
                continue;
            }
            if (!hapName.startsWith("DRB1345-exon2") || sequence.indexOf(DRB1_07_SPECIFIC) <= -1) continue;
            thisRead = ConvertFastaQdataMiSeq.generateName(read);
            name = thisRead.substring(0, thisRead.length() - 2);
            alleleDropOffLog.addNamesDRB07(name);
            if (sequence.indexOf(DRB1_07_SPECIFIC2) <= -1 || sequence.indexOf(DRB1_07_SPECIFIC3) <= -1) continue;
            alleleDropOffLog.addNameDRB07MoreCoverage(name);
        }
        if (alleleDropOffLog.getNamesDPBdrop().size() > 25) {
            alleleDropOffLog.setDPBdropPresent(true);
            System.out.println("find DPB1 DROP off " + alleleDropOffLog.getNamesDPBdrop().size());
            System.out.println("DPB short reads group 1=" + alleleDropOffLog.getNamesDPBdropGroup1().size());
            System.out.println("DPB short reads group 2=" + alleleDropOffLog.getNamesDPBdropGroup2().size());
            System.out.println("DPB short reads special 1=" + alleleDropOffLog.getNamesDPBdropSpecial1().size());
            System.out.println("DPB short reads special 2=" + alleleDropOffLog.getNamesDPBdropSpecial2().size());
        }
        if (alleleDropOffLog.getNamesDRB07().size() > 25) {
            alleleDropOffLog.setDRB107Present(true);
            System.out.println("find DRB1 07 DROP off " + alleleDropOffLog.getNamesDRB07().size());
        }
    }

    private static File getSequenceFromFastaAndMaskPrimer(File fastaFile, Map<String, String> inputSequences, boolean isPrimerMaskOff) throws Exception {
        File tmpFile = File.createTempFile("seq", "fa");
        tmpFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length - 1) {
            String line = lines[i].trim();
            if (lines[i].startsWith(">")) {
                builder.append(line);
                builder.append("\n");
                builder.append(isPrimerMaskOff ? ParseFastaByHapType7.maskOffPrimerSite(18, lines[i + 1].trim()) : lines[i + 1].trim());
                builder.append("\n");
                inputSequences.put(lines[i].trim().substring(1), isPrimerMaskOff ? ParseFastaByHapType7.maskOffPrimerSite(18, lines[i + 1].trim()) : lines[i + 1].trim());
            }
            ++i;
        }
        System.out.println("input size=" + inputSequences.size());
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    private static Map<String, Map<String, OneMatch>> getCrossMatchRecords(File fastaFile, File hapFile, MatchParameters mp, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, Map<String, String> inputSequences, String name) throws Exception {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        List<File> splitedFiles = ParseFastaByHapType7.splitFile(fastaFile);
        System.out.println("split into " + splitedFiles.size());
        long startTime = System.currentTimeMillis();
        for (File smallFile : splitedFiles) {
            File matchResult = ParseFastaByHapType7.runCrossMatch(smallFile, hapFile, mp);
            Map<String, List<String>> filteredResult = ParseFastaByHapType7.filterResult(matchResult, mp, name);
            System.out.println("done filteredResult... " + filteredResult.size());
            ParseFastaByHapType7.ParseResult(result, matchResult, filteredResult, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, smallFile, inputSequences);
            System.out.println("done ParseResult...");
        }
        for (File smallFile : splitedFiles) {
            smallFile.delete();
        }
        ParseFastaByHapType7.logMethodTime("Done crossmatch and parsing ...", System.currentTimeMillis() - startTime);
        return result;
    }

    private static List<File> splitFile(File fastaFile) {
        File[] files;
        ArrayList<File> splitedFiles = new ArrayList<File>();
        String namePrefix = String.valueOf(fastaFile.getName()) + "sp";
        String cmd = "split -l 10000 " + fastaFile.getAbsolutePath() + " " + namePrefix;
        String[] commandArray2 = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray2, fastaFile.getParentFile(), true);
        command.makeItSo();
        System.out.println(String.valueOf(cmd) + " " + command.getExitValue());
        File[] fileArray = files = fastaFile.getParentFile().listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().startsWith(String.valueOf(namePrefix) + "a")) {
                splitedFiles.add(file);
            }
            ++n2;
        }
        return splitedFiles;
    }

    private static String maskOffPrimerSite(int primerSize, String originalSeq) {
        String nString = "";
        int i = 0;
        while (i < primerSize) {
            nString = String.valueOf(nString) + "N";
            ++i;
        }
        return String.valueOf(nString) + originalSeq.substring(primerSize);
    }

    protected static void logMethodTime(String message, long time) {
        Calendar deltaCalendar = Calendar.getInstance();
        deltaCalendar.setTimeInMillis(time);
        deltaCalendar.add(10, -4);
        System.out.println(String.valueOf(message) + deltaCalendar.get(10) + ":" + deltaCalendar.get(12) + ":" + deltaCalendar.get(13));
    }

    private static void gatherDPB1DropTypes(Map<String, String> sequences, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types) {
        for (String name : sequences.keySet()) {
            String seq = sequences.get(name);
            if (seq.indexOf(DPB1_DROP_CASE1) > -1 || seq.indexOf(DPB1_DROP_CASE2) > -1 || seq.indexOf(DPB1_DROP_CASE3) > -1) {
                DPBdropTypes.add(name);
            }
            if (seq.indexOf(DPB1_DROP_GROUP1) > -1) {
                DPBdropGroup1Types.add(name);
                continue;
            }
            if (seq.indexOf(DPB1_DROP_GROUP2) <= -1) continue;
            DPBdropGroup2Types.add(name);
        }
    }

    private static Map<String, List<String>> filterResult(File matchResult, MatchParameters mp, String name) throws Exception {
        HashMap<String, Map<String, Integer>> readsMap = new HashMap<String, Map<String, Integer>>();
        BufferedReader indexReader = new BufferedReader(new FileReader(matchResult));
        try {
            String line;
            int lineCount = 0;
            while ((line = indexReader.readLine()) != null) {
                String[] items;
                ++lineCount;
                if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12 || !ParseFastaByHapType7.misMatchBelowThreshHold(Double.valueOf((items = line.trim().split("\\s+"))[1]), Double.valueOf(items[2]), Double.valueOf(items[3]), mp.getMismatchAllowed(), name)) continue;
                ParseFastaByHapType7.updateReadMap(readsMap, items);
            }
        }
        finally {
            indexReader.close();
        }
        HashMap<String, List<String>> readsMatches = new HashMap<String, List<String>>();
        for (String readName : readsMap.keySet()) {
            readsMatches.put(readName, ParseFastaByHapType7.getBestMatchingTypes((Map)readsMap.get(readName)));
        }
        return readsMatches;
    }

    private static List<String> getBestMatchingTypes(Map<String, Integer> allMap) {
        HashMap mapByScore = new HashMap();
        for (String type : allMap.keySet()) {
            if (!mapByScore.containsKey(allMap.get(type))) {
                mapByScore.put(allMap.get(type), new ArrayList());
            }
            ((List)mapByScore.get(allMap.get(type))).add(type);
        }
        ArrayList<String> results = new ArrayList<String>();
        Object[] num = mapByScore.keySet().toArray();
        Arrays.sort(num);
        results.addAll((Collection)mapByScore.get(num[num.length - 1]));
        return results;
    }

    private static void updateReadMap(Map<String, Map<String, Integer>> readsMap, String[] items) {
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String type = isRevComp ? items[9].trim() : items[8].trim();
        Integer score = Integer.valueOf(items[0].trim());
        if (!readsMap.containsKey(name)) {
            readsMap.put(name, new HashMap());
        }
        if (!readsMap.get(name).containsKey(type)) {
            readsMap.get(name).put(type, 0);
        }
        int newScore = readsMap.get(name).get(type) + score;
        readsMap.get(name).put(type, newScore);
    }

    private static boolean diffOnlyByBoundary(List<String> list, List<String> list2) {
        String[] items1 = list.get(0).trim().split("\\s+");
        String[] items2 = list2.get(0).trim().split("\\s+");
        int start1 = 0;
        int end1 = 0;
        int start2 = 0;
        int end2 = 0;
        boolean isRevComp = items1[8].trim().equals("C");
        double dis1 = Double.valueOf(items1[1]) + Double.valueOf(items1[2]) + Double.valueOf(items1[3]);
        double dis2 = Double.valueOf(items2[1]) + Double.valueOf(items2[2]) + Double.valueOf(items2[3]);
        if (dis2 > dis1) {
            return false;
        }
        if (isRevComp) {
            start1 = Integer.valueOf(items1[12].trim());
            end1 = Integer.valueOf(items1[11].trim());
            start2 = Integer.valueOf(items2[12].trim());
            end2 = Integer.valueOf(items2[11].trim());
        } else {
            start1 = Integer.valueOf(items1[9].trim());
            end1 = Integer.valueOf(items1[10].trim());
            start2 = Integer.valueOf(items2[9].trim());
            end2 = Integer.valueOf(items2[10].trim());
        }
        return true;
    }

    private static boolean isMatchWithinBoundary(List<String> list) {
        for (String line : list) {
            String[] items = line.trim().split("\\s+");
            boolean isRevComp = items[8].trim().equals("C");
            int start = 0;
            int end = 0;
            if (isRevComp) {
                start = Integer.valueOf(items[12].trim());
                end = Integer.valueOf(items[11].trim());
            } else {
                start = Integer.valueOf(items[9].trim());
                end = Integer.valueOf(items[10].trim());
            }
            if ((start <= 270 || end <= 270) && (start > 270 || end > 270)) continue;
            return true;
        }
        return false;
    }

    public static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        tmpFn.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        return tmpFn;
    }

    public static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum, StringBuilder builder, int exonSize, File outputImage, StringBuilder resultSummary, String locus, String sample, Map<String, String> inputSequences, Map<String, String> sequences, MatchParameters mp, AlleleDropOffLog alleleDropOffLog) {
        HashMap orgnizedTypes = new HashMap();
        HashMap<String, ArrayList<OneMatch>> effectiveMatchesByType = new HashMap<String, ArrayList<OneMatch>>();
        HashMap<String, MatchStatistics> matchStatisticsList = new HashMap<String, MatchStatistics>();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            int perfectCount = 0;
            int bridgeCount = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    if (match.getForDiscrepencies().size() == 0 && match.getRevDiscrepencies().size() == 0) {
                        ++perfectCount;
                    }
                    if (match.getForwardTargetStart() <= 100 || match.getForwardTargetStart() >= 150 || match.getReverseTargetEnd() <= 400 || match.getReverseTargetEnd() >= 450) continue;
                    ++bridgeCount;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            matchStatisticsList.put(type, ParseFastaByHapType7.fillMatchStatistics(effectiveMatches, sequences.get(type).length(), roundNum));
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsSupport(count);
            ((MatchStatistics)matchStatisticsList.get(type)).setNumPairsPerfect(perfectCount);
            ((MatchStatistics)matchStatisticsList.get(type)).setBridgeCount(bridgeCount);
            int firmPosCount = ((MatchStatistics)matchStatisticsList.get(type)).getNumPosGoodCoverage();
            if (!orgnizedTypes.containsKey(firmPosCount)) {
                orgnizedTypes.put(firmPosCount, new ArrayList());
            }
            ((List)orgnizedTypes.get(firmPosCount)).add(type);
        }
        List<String> outputTypes = ParseFastaByHapType7.summaryResult(resultSummary, matchStatisticsList, exonSize, locus, sample, alleleDropOffLog, sequences);
        if (mp.isAlignType() && outputTypes.size() > 0) {
            ParseFastaByHapType7.outputAlignments(outputTypes, sequences, matchStatisticsList, locus, resultSummary);
        }
        if (mp.isDrawImage()) {
            int imageCount = 0;
            BufferedImage bufferedImage = ParseFastaByHapType7.initializeBufferedImage(exonSize);
            Graphics2D graphics2D = ParseFastaByHapType7.initializeGraphics2D(bufferedImage);
            for (String t : outputTypes) {
                if (imageCount > IMAGE_TO_DRAW) break;
                ParseFastaByHapType7.drawImage(t, (MatchStatistics)matchStatisticsList.get(t), (List)effectiveMatchesByType.get(t), 0, sequences.get(t).length(), bufferedImage, graphics2D, imageCount, inputSequences, sequences, mp);
                ++imageCount;
            }
            ParseFastaByHapType7.writeImageToFile(bufferedImage, outputImage);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int outputCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (outputCount >= 20 || ((List)orgnizedTypes.get(c)).size() > 20) break;
            for (String t : (List)orgnizedTypes.get(c)) {
                String info;
                if (((MatchStatistics)matchStatisticsList.get(t)).getNumPairsSupport() < 10) continue;
                if (roundNum == 0) {
                    info = String.valueOf(t) + "\t" + ((MatchStatistics)matchStatisticsList.get(t)).getNumPairsSupport() + "\t" + ((MatchStatistics)matchStatisticsList.get(t)).getNumPairsPerfect();
                    builder.append(info);
                    builder.append(ParseFastaByHapType7.getStatistics((MatchStatistics)matchStatisticsList.get(t)));
                    builder.append("\t").append(outputCount + 1);
                    builder.append("\n");
                    ++outputCount;
                    continue;
                }
                info = String.valueOf(t) + "\t" + c;
                builder.append(info);
                builder.append(ParseFastaByHapType7.getStatistics((MatchStatistics)matchStatisticsList.get(t)));
                builder.append("\t").append(outputCount + 1);
                builder.append("\n");
                ++outputCount;
            }
            --i;
        }
        return false;
    }

    private static boolean isBridgingReads(OneMatch match) {
        return match.isForwardExist() && match.isReverseExist() && match.getForwardTargetStart() > 100 && match.getForwardTargetStart() < 200 && match.getReverseTargetEnd() > 400 && match.getReverseTargetEnd() < 500 && match.getReverseTargetStart() > match.getForwardTargetEnd();
    }

    private static void drawImage(String hap, MatchStatistics matchStatistics, List<OneMatch> list, int rountNum, int exonSize, BufferedImage bufferedImage, Graphics2D graphics2D, int imageCount, Map<String, String> inputSequences, Map<String, String> sequences, MatchParameters mp) {
        String label = " Support Reads Pairs =" + matchStatistics.getNumPairsSupport();
        label = String.valueOf(label) + ", #pos with >= 8x coverage =" + matchStatistics.getNumPosGoodCoverage() + " ";
        label = String.valueOf(label) + ", pos with >30% mismatch =" + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos()) + " ";
        label = String.valueOf(label) + ", number of pairs complete covered exon =" + matchStatistics.getNumPairsCompletelyCoverExon();
        ParseFastaByHapType7.drawSequence(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, hap);
        ParseFastaByHapType7.drawDeepth(matchStatistics.getPosCount(), exonSize, imageCount, bufferedImage, graphics2D, label);
        ParseFastaByHapType7.drawAmplicons(list, exonSize, imageCount, bufferedImage, graphics2D, inputSequences, sequences.get(hap), mp);
    }

    private static void outputAlignments(List<String> outputTypes, Map<String, String> sequences, Map<String, MatchStatistics> matchStatisticsList, String locus, StringBuilder resultSummary) {
        int i;
        resultSummary.append("\n");
        String anchorName = null;
        String anchor = null;
        Iterator<String> iterator = sequences.keySet().iterator();
        if (iterator.hasNext()) {
            String name;
            anchorName = name = iterator.next();
            anchor = sequences.get(name);
        }
        resultSummary.append(anchorName).append("\t").append(anchor).append("\n");
        for (String type : outputTypes) {
            String seq = sequences.get(type);
            resultSummary.append(type).append("\t");
            i = 0;
            while (i < anchor.length()) {
                if (locus.indexOf("DQA1-exon2") >= 0 && ParseFastaByHapType7.isSpecialDQA1exon2Type(type)) {
                    if (i < 152) {
                        if (seq.charAt(i) == anchor.charAt(i)) {
                            resultSummary.append("-");
                        } else {
                            resultSummary.append(seq.charAt(i));
                        }
                    } else if (i >= 152 && i <= 154) {
                        resultSummary.append(".");
                    } else if (i > 154) {
                        if (i >= seq.length() + 3) break;
                        if (seq.charAt(i - 3) == anchor.charAt(i)) {
                            resultSummary.append("-");
                        } else {
                            resultSummary.append(seq.charAt(i - 3));
                        }
                    }
                } else {
                    if (i >= seq.length()) break;
                    if (seq.charAt(i) == anchor.charAt(i)) {
                        resultSummary.append("-");
                    } else {
                        resultSummary.append(seq.charAt(i));
                    }
                }
                ++i;
            }
            resultSummary.append("\n");
        }
        for (String type : outputTypes) {
            MatchStatistics stats = matchStatisticsList.get(type);
            resultSummary.append(type).append("\t");
            i = 0;
            while (i < anchor.length()) {
                int coverage;
                if (locus.indexOf("DQA1-exon2") >= 0 && ParseFastaByHapType7.isSpecialDQA1exon2Type(type)) {
                    if (i < 152) {
                        if (stats.getPosCount().get(i + 1) >= COVERAGE_CUTOFF) {
                            coverage = stats.getPosCount().get(i + 1) / COVERAGE_CUTOFF;
                            resultSummary.append(Math.min(coverage, 9));
                        } else {
                            resultSummary.append("0");
                        }
                    } else if (i >= 152 && i <= 154) {
                        resultSummary.append(".");
                    } else if (i > 154) {
                        if (i >= stats.getPosCount().size() + 3) break;
                        if (stats.getPosCount().get(i + 1 - 3) >= COVERAGE_CUTOFF) {
                            coverage = stats.getPosCount().get(i + 1 - 3) / COVERAGE_CUTOFF;
                            resultSummary.append(Math.min(coverage, 9));
                        } else {
                            resultSummary.append("0");
                        }
                    }
                } else {
                    if (i >= stats.getPosCount().size()) break;
                    if (stats.getPosCount().get(i + 1) >= COVERAGE_CUTOFF) {
                        coverage = stats.getPosCount().get(i + 1) / COVERAGE_CUTOFF;
                        resultSummary.append(Math.min(coverage, 9));
                    } else {
                        resultSummary.append("0");
                    }
                }
                ++i;
            }
            resultSummary.append("\n");
        }
    }

    public static boolean isSpecialDQA1exon2Type(String type) {
        return type.indexOf("DQA1*01") < 0 && type.indexOf("DQA1*03") < 0;
    }

    private static boolean misMatchBelowThreshHold(double sub, double ins, double del, double cutoff, String name) {
        double threshold = cutoff;
        if (name.indexOf("DRB1345-exon3") > -1) {
            threshold *= 2.0;
        }
        return !(sub + ins + del > threshold);
    }

    private static List<String> summaryResult(StringBuilder resultSummary, Map<String, MatchStatistics> matchStatisticsList, int exonSize, String locus, String sample, AlleleDropOffLog alleleDropOffLog, Map<String, String> sequences) {
        ArrayList<String> result = new ArrayList<String>();
        HashMap orgnizedByExonCoverageTypes = new HashMap();
        for (String type : matchStatisticsList.keySet()) {
            MatchStatistics matchStatistics = matchStatisticsList.get(type);
            int unCoveredPos = matchStatistics.getPosCount().size() - matchStatistics.getNumPosGoodCoverage();
            if (!orgnizedByExonCoverageTypes.containsKey(unCoveredPos)) {
                orgnizedByExonCoverageTypes.put(unCoveredPos, new ArrayList());
            }
            ((List)orgnizedByExonCoverageTypes.get(unCoveredPos)).add(type);
        }
        int count = 0;
        Object[] num = orgnizedByExonCoverageTypes.keySet().toArray();
        Arrays.sort(num);
        int i = 0;
        while (i < num.length) {
            int c = (Integer)num[i];
            if (c >= exonSize || (result.size() >= IMAGE_TO_DRAW && c != 0 || (double)c > 0.15 * (double)exonSize) && result.size() > 0 && ParseFastaByHapType7.resultContainsLocus(result)) break;
            HashMap orgnizedByAmpliconSizeTypes = new HashMap();
            for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                if (!orgnizedByAmpliconSizeTypes.containsKey(matchStatisticsList.get(t).getNumPairsSupport())) {
                    orgnizedByAmpliconSizeTypes.put(matchStatisticsList.get(t).getNumPairsSupport(), new ArrayList());
                }
                ((List)orgnizedByAmpliconSizeTypes.get(matchStatisticsList.get(t).getNumPairsSupport())).add(t);
            }
            Object[] num3 = orgnizedByAmpliconSizeTypes.keySet().toArray();
            Arrays.sort(num3);
            int j = num3.length - 1;
            while (j >= 0) {
                int z = (Integer)num3[j];
                for (Object tt : (List)orgnizedByAmpliconSizeTypes.get(z)) {
                    if (c != 0) {
                        ParseFastaByHapType7.getNewAllele((String)tt, matchStatisticsList.get(tt), sequences.get(tt));
                    }
                    resultSummary.append(sample).append("\t").append(locus).append("\t").append((String)tt).append("\t").append(matchStatisticsList.get(tt).format()).append("\t").append(count + 1).append("\n");
                    result.add((String)tt);
                    ++count;
                }
                --j;
            }
            ++i;
        }
        if (alleleDropOffLog.isDRB107Present()) {
            boolean findDropOffType = false;
            for (String type : result) {
                if (type.indexOf("DRB1*07") <= -1) continue;
                findDropOffType = true;
                break;
            }
            if (!findDropOffType) {
                int i2 = num.length - 1;
                while (i2 >= 0) {
                    int c = (Integer)num[i2];
                    if (c == 0) break;
                    boolean isFind = false;
                    HashMap orgnizedByAmpliconSizeTypes = new HashMap();
                    for (String t : (List)orgnizedByExonCoverageTypes.get(c)) {
                        if (!orgnizedByAmpliconSizeTypes.containsKey(matchStatisticsList.get(t).getNumPairsSupport())) {
                            orgnizedByAmpliconSizeTypes.put(matchStatisticsList.get(t).getNumPairsSupport(), new ArrayList());
                        }
                        ((List)orgnizedByAmpliconSizeTypes.get(matchStatisticsList.get(t).getNumPairsSupport())).add(t);
                    }
                    Object[] num3 = orgnizedByAmpliconSizeTypes.keySet().toArray();
                    Arrays.sort(num3);
                    int j = num3.length - 1;
                    while (j >= 0) {
                        int z = (Integer)num3[j];
                        for (String tt : (List)orgnizedByAmpliconSizeTypes.get(z)) {
                            if (tt.indexOf("DRB1*07") <= -1) continue;
                            System.out.println("force " + tt + " into result!!!");
                            resultSummary.append(sample).append("\t").append(locus).append("\t").append(tt).append("\t").append(matchStatisticsList.get(tt).format()).append("\t").append(count + 1).append("\t").append("dropOff").append("\n");
                            result.add(tt);
                            isFind = true;
                        }
                        if (isFind) break;
                        --j;
                    }
                    if (isFind) break;
                    --i2;
                }
            }
        }
        if (result.size() == 0) {
            resultSummary.append(sample).append("\t").append(locus).append("\t").append("No Result").append("\n");
        }
        return result;
    }

    private static char[] getNewAllele(String type, MatchStatistics matchStatistics, String sequence) {
        System.out.println("-----------allele: " + type);
        String newType = "";
        int i = 0;
        while (i < sequence.length()) {
            newType = matchStatistics.getActualBaseMap().containsKey(i + 1) ? String.valueOf(newType) + matchStatistics.getActualBaseMap().get(i + 1).toLowerCase() : String.valueOf(newType) + sequence.charAt(i);
            ++i;
        }
        System.out.println(newType);
        for (Integer pos : matchStatistics.getActualBaseMap().keySet()) {
            System.out.print(pos + "=" + matchStatistics.getActualBaseMap().get(pos) + ",");
        }
        System.out.println();
        return null;
    }

    private static boolean resultContainsLocus(List<String> result) {
        for (String t : result) {
            if (t.startsWith("DRB3") || t.startsWith("DRB4") || t.startsWith("DRB5")) continue;
            return true;
        }
        return false;
    }

    private static MatchStatistics fillMatchStatistics(List<OneMatch> list, int exonSize, int rountNum) {
        MatchStatistics matchStatistics = new MatchStatistics();
        int totalSize = 0;
        int totalCount = 0;
        int pairsWithCompleteCoverage = 0;
        Map<Integer, Integer> posCount = ParseFastaByHapType7.initMap(exonSize);
        HashMap<Integer, Integer> misMatchPosCount = new HashMap<Integer, Integer>();
        HashMap<Integer, Map<String, Integer>> misMatchPosRecord = new HashMap<Integer, Map<String, Integer>>();
        HashMap<Integer, String> actualBaseMap = new HashMap<Integer, String>();
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            if (fstart > match.getReverseTargetStart()) {
                fstart = match.getReverseTargetStart();
                fend = match.getReverseTargetEnd();
                rstart = match.getForwardTargetStart();
                rend = match.getForwardTargetEnd();
            }
            int size = 0;
            if (rountNum == 0) {
                if (fend >= rstart) {
                    size = Math.max(rend, fend) - fstart + 1;
                    ParseFastaByHapType7.addToPosCount(posCount, fstart, Math.max(rend, fend));
                    if (fstart == 1 && rend == exonSize) {
                        ++pairsWithCompleteCoverage;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    ParseFastaByHapType7.addToPosCount(posCount, fstart, fend);
                    ParseFastaByHapType7.addToPosCount(posCount, rstart, rend);
                }
                ParseFastaByHapType7.addInDiscrepenies(match.getForDiscrepencies(), posCount, misMatchPosCount, misMatchPosRecord, false);
                ParseFastaByHapType7.addInDiscrepenies(match.getRevDiscrepencies(), posCount, misMatchPosCount, misMatchPosRecord, true);
                match.setCoverageSize(size);
                totalSize += size;
                ++totalCount;
                continue;
            }
            int thisSize = 0;
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                ParseFastaByHapType7.addToPosCount(posCount, fstart, fend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            if (match.isReverseExist()) {
                size = rend - rstart + 1;
                ParseFastaByHapType7.addToPosCount(posCount, rstart, rend);
                totalSize += size;
                thisSize += size;
                ++totalCount;
            }
            match.setCoverageSize(thisSize);
        }
        matchStatistics.setAverageAmpliconSize(totalSize / totalCount);
        ArrayList<Integer> firmPos = new ArrayList<Integer>();
        for (int pos : posCount.keySet()) {
            if (posCount.get(pos) >= COVERAGE_CUTOFF) {
                firmPos.add(pos);
                continue;
            }
            String actual = ParseFastaByHapType7.getActualBase((Map)misMatchPosRecord.get(pos));
            if (actual.equals("N")) continue;
            actualBaseMap.put(pos, actual);
        }
        ArrayList<Integer> questionPos = new ArrayList<Integer>();
        Iterator iterator = misMatchPosCount.keySet().iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            if ((Integer)misMatchPosCount.get(pos) <= posCount.get(pos) || posCount.get(pos) < COVERAGE_CUTOFF) continue;
            questionPos.add(pos);
            String actual = ParseFastaByHapType7.getActualBase((Map)misMatchPosRecord.get(pos));
            if (actual.equals("N")) continue;
            actualBaseMap.put(pos, actual);
        }
        matchStatistics.setMisMatchPosCount(misMatchPosCount);
        matchStatistics.setPosCount(posCount);
        matchStatistics.setQuestionPos(questionPos);
        matchStatistics.setNumPosGoodCoverage(firmPos.size());
        matchStatistics.setNumPairsCompletelyCoverExon(pairsWithCompleteCoverage);
        matchStatistics.setExonSize(exonSize);
        matchStatistics.setActualBaseMap(actualBaseMap);
        return matchStatistics;
    }

    private static String getActualBase(Map<String, Integer> baseMap) {
        if (baseMap == null) {
            return "N";
        }
        int count = 0;
        String base = "N";
        for (String b : baseMap.keySet()) {
            if (baseMap.get(b) <= count) continue;
            base = b;
            count = baseMap.get(b);
        }
        return base;
    }

    public static void addInDiscrepenies(List<Discrepancy> discrepencies, Map<Integer, Integer> posCount, Map<Integer, Integer> misMatchPosCount, Map<Integer, Map<String, Integer>> misMatchPosRecord, boolean recomp) {
        for (Discrepancy d : discrepencies) {
            String base;
            if (!posCount.containsKey(d.getTargetPosition()) || d.getQueryPosition() <= 18) continue;
            int count = posCount.get(d.getTargetPosition()) - 1;
            posCount.put(d.getTargetPosition(), count);
            if (!misMatchPosCount.containsKey(d.getTargetPosition())) {
                misMatchPosCount.put(d.getTargetPosition(), 0);
                misMatchPosRecord.put(d.getTargetPosition(), ParseFastaByHapType7.initBaseMap());
            }
            count = misMatchPosCount.get(d.getTargetPosition()) + 1;
            misMatchPosCount.put(d.getTargetPosition(), count);
            String string = base = recomp ? StringUtils.revCompSeq(d.getQueryBase()).toUpperCase() : d.getQueryBase().toUpperCase();
            if (!base.equals("A") && !base.equals("T") && !base.equals("G") && !base.equals("C")) continue;
            int baseCount = misMatchPosRecord.get(d.getTargetPosition()).get(base) + 1;
            misMatchPosRecord.get(d.getTargetPosition()).put(base, baseCount);
        }
    }

    private static Map<String, Integer> initBaseMap() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("A", 0);
        map.put("C", 0);
        map.put("G", 0);
        map.put("T", 0);
        return map;
    }

    private static String getStatistics(MatchStatistics matchStatistics) {
        String output = "\t" + matchStatistics.getAverageAmpliconSize();
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPosGoodCoverage();
        output = String.valueOf(output) + "\t" + matchStatistics.formatQuestionPostion(matchStatistics.getQuestionPos());
        output = String.valueOf(output) + "\t" + matchStatistics.getNumPairsCompletelyCoverExon();
        return output;
    }

    public static String getSeqFromFile(String hap, Map<String, String> inputSequences) {
        return inputSequences.get(hap);
    }

    private static void drawAmplicons(List<OneMatch> alllist, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, Map<String, String> inputSequences, String hapSeq, MatchParameters mp) {
        int length = exonSize;
        Color[] colors = new Color[]{Color.DARK_GRAY, Color.LIGHT_GRAY};
        List<OneMatch> list = ParseFastaByHapType7.orgnizeMatches(alllist, exonSize);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        int index = 1;
        for (OneMatch match : list) {
            int x0;
            int x2;
            int y1;
            int x1;
            Color c = colors[index % 2];
            graphics2D.setColor(c);
            if (match.isForwardExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetStart() - match.getForwardStart() + 1)).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getForwardTargetEnd() + mp.getReadSize() - match.getForwardEnd())).floatValue());
                if (mp.isPrimerMaskOff()) {
                    x0 = x1 + Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * 18.0).floatValue());
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawLine(x1, y1, x0, y1);
                    graphics2D.setColor(c);
                    graphics2D.drawLine(x0, y1, x2, y1);
                } else {
                    graphics2D.drawLine(x1, y1, x2, y1);
                }
            }
            if (match.isReverseExist()) {
                x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetStart() - mp.getReadSize() + match.getReverseEnd())).floatValue());
                y1 = yBase - 424 + index * 4;
                x2 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)(match.getReverseTargetEnd() + match.getReverseStart() - 1)).floatValue());
                if (mp.isPrimerMaskOff()) {
                    x0 = x2 - Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * 18.0).floatValue());
                    graphics2D.setColor(c);
                    graphics2D.drawLine(x1, y1, x0, y1);
                    graphics2D.setColor(Color.YELLOW);
                    graphics2D.drawLine(x0, y1, x2, y1);
                } else {
                    graphics2D.drawLine(x1, y1, x2, y1);
                }
            }
            ParseFastaByHapType7.drawMismatchPos(yBase, exonSize, bufferedImage, match, graphics2D, index, inputSequences, hapSeq, mp);
            if (++index > 100) break;
        }
    }

    private static void drawMismatchPos(int yBase, int exonSize, BufferedImage bufferedImage, OneMatch match, Graphics2D graphics2D, int index, Map<String, String> inputSequences, String hapSeq, MatchParameters mp) {
        int y1 = yBase - 424 + index * 4;
        if (match.isForwardExist() && match.isReverseExist()) {
            int x1 = match.getForwardStart();
            int x2 = match.getForwardEnd();
            int x3 = match.getReverseStart();
            int x4 = match.getReverseEnd();
            if (x1 == x2 || x3 == x4) {
                return;
            }
            String forwardSeq = ParseFastaByHapType7.getSeqFromFile(match.getForwardFullName(), inputSequences);
            String reverseSeq = ParseFastaByHapType7.getSeqFromFile(match.getReverseFullName(), inputSequences);
            int t1 = match.getForwardTargetStart();
            int t2 = match.getForwardTargetEnd();
            int t3 = match.getReverseTargetStart();
            int t4 = match.getReverseTargetEnd();
            LinkedHashMap<Integer, String> misMatches = new LinkedHashMap<Integer, String>();
            ParseFastaByHapType7.findMismatches(misMatches, forwardSeq, hapSeq, x1, x2, t1, t2, false, mp, t3, t4);
            ParseFastaByHapType7.findMismatches(misMatches, reverseSeq, hapSeq, x3, x4, t3, t4, true, mp, t1, t2);
            ParseFastaByHapType7.addMismatches(misMatches, match.getForDiscrepencies(), false);
            ParseFastaByHapType7.addMismatches(misMatches, match.getRevDiscrepencies(), true);
            for (Integer pos : misMatches.keySet()) {
                int y = yBase - 424 + index * 4;
                int x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(exonSize) * (double)pos.intValue()).floatValue());
                graphics2D.setColor(ParseFastaByHapType7.getBaseColor((String)misMatches.get(pos)));
                graphics2D.drawLine(x, y - 1, x, y + 1);
            }
        }
    }

    private static void addMismatches(Map<Integer, String> misMatches, List<Discrepancy> forDiscrepencies, boolean isRevComp) {
        for (Discrepancy d : forDiscrepencies) {
            if (isRevComp) {
                misMatches.put(d.getTargetPosition(), StringUtils.revCompSeq(d.getQueryBase()));
                continue;
            }
            misMatches.put(d.getTargetPosition(), d.getQueryBase());
        }
    }

    private static boolean isInMatchRegion(Integer pos, OneMatch match) {
        int t1 = match.getForwardTargetStart();
        int t2 = match.getForwardTargetEnd();
        int t3 = match.getReverseTargetStart();
        int t4 = match.getReverseTargetEnd();
        if (pos > t1 && pos < t2) {
            return true;
        }
        return pos > t3 && pos < t4;
    }

    private static Color getBaseColor(String base) {
        if (base.equals("A")) {
            return Color.GREEN;
        }
        if (base.equals("T")) {
            return Color.RED;
        }
        if (base.equals("C")) {
            return Color.BLUE;
        }
        if (base.equals("G")) {
            return Color.ORANGE;
        }
        return Color.LIGHT_GRAY;
    }

    private static void findMismatches(Map<Integer, String> misMatches, String seq, String hapSeq, int x1, int x2, int t1, int t2, boolean isReverseComp, MatchParameters mp, int t3, int t4) {
        if (!isReverseComp) {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = seq.charAt(i);
                targetIndex = t1 - x1 + i;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType7.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < mp.getReadSize()) {
                s = seq.charAt(i);
                targetIndex = t2 + (i - x2);
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType7.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        } else {
            char h;
            int targetIndex;
            char s;
            int i = 0;
            while (i < x1 - 1) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t2 + (x1 - i) - 2;
                if (targetIndex <= hapSeq.length() - 1 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType7.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
            i = x2;
            while (i < mp.getReadSize()) {
                s = StringUtils.revCompSeq(String.valueOf(seq.charAt(i))).charAt(0);
                targetIndex = t1 - (i - x2) - 2;
                if (targetIndex >= 0 && s != (h = hapSeq.charAt(targetIndex)) && s != 'N' && h != 'N' && ParseFastaByHapType7.outsideOtherStrandsMatchRegion(targetIndex, t3, t4)) {
                    misMatches.put(targetIndex + 1, String.valueOf(s));
                }
                ++i;
            }
        }
    }

    private static boolean outsideOtherStrandsMatchRegion(int targetIndex, int t3, int t4) {
        return targetIndex < t3 - 1 || targetIndex > t4 - 1;
    }

    private static List<OneMatch> orgnizeMatches(List<OneMatch> list, int exonSize) {
        HashMap sortedMatches = new HashMap();
        ArrayList<OneMatch> sortedList = new ArrayList<OneMatch>();
        int count = 0;
        for (OneMatch match : list) {
            int size = match.getCoverageSize();
            if (!sortedMatches.containsKey(size)) {
                sortedMatches.put(size, new ArrayList());
            }
            ((List)sortedMatches.get(size)).add(match);
            if (++count > 100) break;
        }
        Object[] num = sortedMatches.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            sortedList.addAll((Collection)sortedMatches.get(num[i]));
            --i;
        }
        return sortedList;
    }

    public static void drawDeepth(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String output) {
        int length = exonSize;
        int countMax = ParseFastaByHapType7.getCountMax(posCount);
        double depthUnit = 0.0;
        depthUnit = (double)countMax > 50.0 ? new Double(400.0) / new Double((double)countMax * 1.5) : new Double(400.0) / new Double(75.0);
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        for (int pos : posCount.keySet()) {
            int x1 = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * (double)pos).floatValue());
            int y1 = yBase - 450 - 10;
            int y2 = Math.round(new Float(depthUnit * (double)posCount.get(pos).intValue()).floatValue());
            graphics2D.drawLine(x1, y1 - y2, x1, y1);
        }
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawString(" coverage max=" + countMax, 1, yBase - 650);
        graphics2D.drawString(output, 1, yBase - 650 + 10);
    }

    public static int getCountMax(Map<Integer, Integer> posCount) {
        int max = 0;
        for (Integer count : posCount.values()) {
            if (count <= max) continue;
            max = count;
        }
        return max;
    }

    public static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            if (posCount.get(i) != null) {
                int count = posCount.get(i) + 1;
                posCount.put(i, count);
            }
            ++i;
        }
    }

    public static Map<Integer, Integer> initMap(int exonSize) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i, 0);
            ++i;
        }
        return posCount;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).trim().split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static void ParseResult(Map<String, Map<String, OneMatch>> result, File matchResult, Map<String, List<String>> filteredResult, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, File fastaFile, Map<String, String> inputSequences) throws Exception {
        Object names07 = null;
        Object name07MoreCoverage = null;
        Object namesDPBdrop = null;
        ArrayList namesDPBdropGroup1 = new ArrayList();
        ArrayList namesDPBdropGroup2 = new ArrayList();
        ArrayList namesDPBdropSpecial1 = new ArrayList();
        ArrayList namesDPBdropSpecial2 = new ArrayList();
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        int lineCount = 0;
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                if (ParseFastaByHapType7.isInFilteredResult(filteredResult, items)) {
                    startRecord = true;
                    fullName = items[4].trim();
                    aMatch = ParseFastaByHapType7.populateAmatch(fastaFile, result, alleleDropOffLog, DPBdropTypes, DPBdropGroup1Types, DPBdropGroup2Types, line, inputSequences);
                } else {
                    startRecord = false;
                    aMatch = null;
                    fullName = null;
                }
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                ParseFastaByHapType7.populateDiscrepency(aMatch, line, fullName);
            }
            ++n2;
        }
    }

    private static boolean isInFilteredResult(Map<String, List<String>> filteredResult, String[] items) {
        String type;
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        return filteredResult.containsKey(name) && filteredResult.get(name).contains(type);
    }

    private static Discrepancy generateDiscrepancy(String[] item) {
        int count = 1;
        if (item[0].trim().length() > 1) {
            count = new Integer(item[0].trim().substring(2));
        }
        String base = item[2].trim().substring(0, item[2].indexOf("("));
        int qual = new Integer(item[2].trim().substring(item[2].indexOf("(") + 1, item[2].indexOf(")")));
        Discrepancy dis = new Discrepancy(item[0].charAt(0), count, new Integer(item[1]), base, qual, new Integer(item[3]), item[4].trim());
        return dis;
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        Discrepancy dis = ParseFastaByHapType7.generateDiscrepancy(items);
        if (match.getForwardFullName() != null && match.getForwardFullName().equals(fullName)) {
            match.addForDiscrepencies(dis);
        } else if (match.getReverseFullName() != null && match.getReverseFullName().equals(fullName)) {
            match.addRevDiscrepencies(dis);
        } else {
            System.out.println("error in parsing discrep !!!!!!!!!!!!");
        }
    }

    private static OneMatch populateAmatch(File fastaFile, Map<String, Map<String, OneMatch>> result, AlleleDropOffLog alleleDropOffLog, List<String> DPBdropTypes, List<String> DPBdropGroup1Types, List<String> DPBdropGroup2Types, String line, Map<String, String> inputSequences) {
        OneMatch aMatch;
        Map<String, OneMatch> matches;
        String type;
        String[] items = line.trim().split("\\s+");
        String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
        String name = thisRead.substring(0, thisRead.length() - 2);
        String fullName = items[4].trim();
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        if (!result.containsKey(type)) {
            result.put(type, new HashMap());
        }
        if (!(matches = result.get(type)).containsKey(name)) {
            aMatch = new OneMatch();
            aMatch.setName(name);
            matches.put(name, aMatch);
        }
        aMatch = matches.get(name);
        if (isRevComp) {
            String forwardSeq;
            aMatch.setReverseExist(true);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            if (alleleDropOffLog.isDPBdropPresent() && alleleDropOffLog.getNamesDPBdrop().contains(name) && DPBdropTypes.contains(type) && !aMatch.isForwardExist() && (alleleDropOffLog.getNamesDPBdropGroup1().contains(name) && DPBdropGroup1Types.contains(type) || alleleDropOffLog.getNamesDPBdropGroup2().contains(name) && DPBdropGroup2Types.contains(type))) {
                aMatch.setForwardScore(30);
                aMatch.setForwardTargetStart(1);
                aMatch.setForwardTargetEnd(30);
                aMatch.setForwardExist(true);
                aMatch.setForwardFullName(String.valueOf(fullName.substring(0, fullName.length() - 1)) + (fullName.charAt(fullName.length() - 1) == '1' ? 2 : 1));
                forwardSeq = ParseFastaByHapType7.getSeqFromFile(aMatch.getForwardFullName(), inputSequences);
                aMatch.setForwardStart(forwardSeq.indexOf(DPB1_DROP_STABLE) - 12);
                aMatch.setForwardEnd(aMatch.getForwardStart() + 29);
            }
            if (alleleDropOffLog.isDRB107Present() && alleleDropOffLog.getNamesDRB07().contains(name) && type.indexOf("DRB1*07") > -1) {
                aMatch.setForwardExist(true);
                aMatch.setForwardScore(alleleDropOffLog.getNameDRB07MoreCoverage().contains(name) && !ParseFastaByHapType7.inExcludingList(type) ? 47 : 22);
                aMatch.setForwardTargetStart(1);
                aMatch.setForwardTargetEnd(alleleDropOffLog.getNameDRB07MoreCoverage().contains(name) && !ParseFastaByHapType7.inExcludingList(type) ? 47 : 22);
                aMatch.setForwardFullName(String.valueOf(fullName.substring(0, fullName.length() - 1)) + (fullName.charAt(fullName.length() - 1) == '1' ? 2 : 1));
                forwardSeq = ParseFastaByHapType7.getSeqFromFile(aMatch.getForwardFullName(), inputSequences);
                aMatch.setForwardStart(forwardSeq.indexOf(DRB1_07_SPECIFIC) - 5 + 1);
                if (aMatch.getForwardScore() == 47) {
                    aMatch.setForwardEnd(aMatch.getForwardStart() + 47 - 1);
                } else {
                    aMatch.setForwardEnd(aMatch.getForwardStart() + 22 - 1);
                }
            }
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
        }
        return aMatch;
    }

    private static boolean inExcludingList(String type) {
        int i = 0;
        while (i < DRB1_07_SPECIFIC23_EXCLUDING.length) {
            if (type.equals(DRB1_07_SPECIFIC23_EXCLUDING[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static List<String> addDRB107SpecificReads(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(line.trim().substring(1));
                String name = thisRead.substring(0, thisRead.length() - 2);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static List<String> addDPBdropTypes(String[] log) {
        ArrayList<String> names = new ArrayList<String>();
        String[] stringArray = log;
        int n = log.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().startsWith(">")) {
                String name = line.trim().substring(1);
                names.add(name);
            }
            ++n2;
        }
        return names;
    }

    private static File runCrossMatch(File fastaFile, File hapFile, MatchParameters mp) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -masklevel 101 -minscore " + mp.getMatchMinScore() + " -discrep_lists " + " -penalty " + mp.misPenalty + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        System.out.println("running cross_match...");
        command.makeItSo();
        System.out.println("done cross_match...");
        return tmpFile;
    }

    public static void excuteCommand(String[] cmd) {
        Object data = null;
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            proc.waitFor();
            proc = null;
        }
        catch (IOException ioe) {
            System.err.println("an I/O error occurs" + ioe.toString());
            System.exit(1);
        }
        catch (InterruptedException e) {
            System.err.println("Interrupted waiting for process!");
            System.exit(1);
        }
    }

    public static BufferedImage initializeBufferedImage(int exonSize) {
        BufferedImage bufferedImage = new BufferedImage(1000, 1000 * IMAGE_TO_DRAW, 9);
        return bufferedImage;
    }

    /*
     * Unable to fully structure code
     */
    public static double getUnit(int length) {
        num = length;
        i = 0;
        if (!((double)length <= 5.0)) ** GOTO lbl6
        return 1.0;
lbl-1000:
        // 1 sources

        {
            num = new Double((double)length / Math.pow(10.0, ++i));
lbl6:
            // 2 sources

            ** while (num > 10.0)
        }
lbl7:
        // 1 sources

        if (num > 5.0) {
            return Math.pow(10.0, i);
        }
        j = 1;
        while (num * (double)j * 2.0 < 5.0) {
            ++j;
        }
        return Math.pow(10.0, i) / new Double(j * 2);
    }

    public static Graphics2D initializeGraphics2D(BufferedImage bufferedImage) {
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setBackground(Color.white);
        graphics2D.clearRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setClip(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics2D;
    }

    public static void drawSequence(Map<Integer, Integer> posCount, int exonSize, int count, BufferedImage bufferedImage, Graphics2D graphics2D, String hap) {
        int length = exonSize;
        graphics2D.setColor(Color.LIGHT_GRAY);
        int yBase = bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000;
        graphics2D.draw3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.fill3DRect(0, yBase - 450, 1000, 10, true);
        graphics2D.setColor(Color.BLACK);
        graphics2D.drawLine(1, yBase - 450, 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString("1 " + hap, 1, yBase - 424);
        graphics2D.drawLine(bufferedImage.getWidth() - 1, yBase - 450, bufferedImage.getWidth() - 1, bufferedImage.getHeight() - (IMAGE_TO_DRAW - count - 1) * 1000 - 450 + 10);
        graphics2D.drawString(new Integer(length).toString(), bufferedImage.getWidth() - new Integer(length).toString().length() * 8, yBase - 424);
        double unit = ParseFastaByHapType7.getUnit(exonSize);
        int num = new Double((double)exonSize / unit).intValue();
        int x = 0;
        String index = null;
        int i = 1;
        while (i <= num) {
            x = Math.round(new Float(new Double(bufferedImage.getWidth()) / new Double(length) * unit * (double)i).floatValue());
            index = String.valueOf(new Double(unit * (double)i).intValue());
            graphics2D.drawLine(x, yBase - 450, x, yBase - 450 + 10);
            if (i < num || i == num && (double)length - unit * (double)num >= unit / 2.0) {
                graphics2D.drawString(index, x, yBase - 424);
            }
            ++i;
        }
    }

    public static void writeImageToFile(BufferedImage bufferedImage, File imageFile) {
        FileImageOutputStream fileImageOutputStream = null;
        ImageWriter imageWriter = null;
        try {
            try {
                fileImageOutputStream = new FileImageOutputStream(imageFile);
                imageWriter = ImageIO.getImageWritersByFormatName("jpg").next();
                imageWriter.setOutput(fileImageOutputStream);
                imageWriter.write(bufferedImage);
            }
            catch (IOException e) {
                e.printStackTrace();
                if (fileImageOutputStream != null) {
                    try {
                        fileImageOutputStream.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                if (imageWriter != null) {
                    imageWriter.dispose();
                }
            }
        }
        finally {
            if (fileImageOutputStream != null) {
                try {
                    fileImageOutputStream.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (imageWriter != null) {
                imageWriter.dispose();
            }
        }
    }
}

