/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class ParseFastaByHapType2 {
    private static final int MIN_HIT = 10;
    static int MIN_SCORE = 80;
    static String LABEL = "000000000";
    static String HAP_AMB_TXT = "-hap-amb.txt";
    static int COVERAGE_CUTOFF = 8;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeRoot = new File(args[1]);
        File outputFile = new File(args[2]);
        ParseFastaByHapType2.startType(fastaFile, hapTypeRoot, outputFile);
    }

    public static void startType(File fastaFile, File hapTypeRoot, File outputFile) throws Exception {
        File[] hapFiles;
        StringBuilder builder = new StringBuilder();
        File[] fileArray = hapFiles = hapTypeRoot.listFiles();
        int n = hapFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File hapFile = fileArray[n2];
            if (hapFile.getName().endsWith("fa")) {
                Map<String, Map<String, OneMatch>> result;
                boolean needMoreTyping;
                File hapAmbFile = new File(hapTypeRoot, String.valueOf(hapFile.getName().substring(0, hapFile.getName().length() - 3)) + HAP_AMB_TXT);
                HashMap<String, String> hapNames = new HashMap<String, String>();
                if (hapAmbFile.exists()) {
                    System.out.println("parse hap amb file " + hapAmbFile.getName());
                    ParseFastaByHapType2.populateHapAmbNames(hapNames, hapAmbFile);
                }
                builder.append("---------").append(hapFile.getName());
                File tmpFile = ParseFastaByHapType2.organizeFastaByHap(hapNames, hapFile, builder);
                int exonSize = FileManager.readTextFile(tmpFile).split("\n")[1].trim().length();
                builder.append(" exon size=").append(exonSize).append("\n");
                String matchResult = ParseFastaByHapType2.runCrossMatch(fastaFile, tmpFile);
                if (hapFile.getName().startsWith("kir")) {
                    Map<String, Map<String, OneMatch>> map = ParseFastaByHapType2.ParseKirResult(matchResult);
                }
                if (needMoreTyping = ParseFastaByHapType2.output(result = ParseFastaByHapType2.ParseResult(matchResult), hapFile, 0, builder, exonSize)) {
                    builder.append("******* further typing based on single direction match \n");
                    ParseFastaByHapType2.output(result, hapFile, 1, builder, exonSize);
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(outputFile, builder.toString(), true);
    }

    private static File organizeFastaByHap(Map<String, String> hapAmbNames, File fastaFile, StringBuilder log) throws Exception {
        File tmpFn = File.createTempFile("seq", "fasta");
        StringBuilder builder = new StringBuilder();
        ArrayList<String> existAmbTypes = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                if (!hapAmbNames.containsKey(name)) {
                    builder.append(lines[i].trim()).append("\n");
                    builder.append(sequence).append("\n");
                } else {
                    String gname = hapAmbNames.get(name);
                    if (!existAmbTypes.contains(gname)) {
                        builder.append(">").append(gname).append("\n");
                        builder.append(sequence).append("\n");
                        existAmbTypes.add(gname);
                    }
                }
            }
            ++i;
        }
        FileManager.writeTextFile(tmpFn, builder.toString(), true);
        System.out.println(tmpFn.getAbsolutePath());
        return tmpFn;
    }

    private static void populateHapAmbNames(Map<String, String> hapNames, File hapAmbFile) {
        String[] lines;
        String[] stringArray = lines = FileManager.readTextFile(hapAmbFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split("\\s+");
                String gname = items[0].trim();
                int i = 1;
                while (i < items.length) {
                    hapNames.put(items[i].trim(), gname);
                    ++i;
                }
            }
            ++n2;
        }
    }

    private static boolean output(Map<String, Map<String, OneMatch>> result, File hapFile, int roundNum, StringBuilder builder, int exonSize) {
        HashMap orgnizedTypes = new HashMap();
        HashMap effectiveMatchesByType = new HashMap();
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (roundNum == 0 && match.isForwardExist() && match.isReverseExist()) {
                    effectiveMatches.add(match);
                    ++count;
                    continue;
                }
                if (roundNum <= 0 || !match.isForwardExist() && !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 5) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    String info;
                    if (roundNum == 0) {
                        info = "\t" + t + " : " + c + " pairs perfect match, ";
                        builder.append(info);
                        builder.append(ParseFastaByHapType2.getStatistics((List)effectiveMatchesByType.get(t), 0, exonSize));
                        builder.append("\n");
                        continue;
                    }
                    info = "\t" + t + " : " + c + " single direction perfect match ";
                    builder.append(info);
                    builder.append(ParseFastaByHapType2.getStatistics((List)effectiveMatchesByType.get(t), 1, exonSize));
                    builder.append("\n");
                }
            }
            --i;
        }
        return num.length == 0 || (Integer)num[num.length - 1] < 10;
    }

    private static String getStatistics(List<OneMatch> list, int rountNum, int exonSize) {
        int totalSize = 0;
        int totalCount = 0;
        int pairsWithCompleteCoverage = 0;
        Map<Integer, Integer> posCount = ParseFastaByHapType2.initMap(exonSize);
        for (OneMatch match : list) {
            int fstart = match.getForwardTargetStart();
            int fend = match.getForwardTargetEnd();
            int rstart = match.getReverseTargetStart();
            int rend = match.getReverseTargetEnd();
            int size = 0;
            if (rountNum == 0) {
                if (fend >= rstart) {
                    size = rend - fstart + 1;
                    ParseFastaByHapType2.addToPosCount(posCount, fstart, rend);
                    if (fstart == 1 && rend == exonSize) {
                        ++pairsWithCompleteCoverage;
                    }
                } else {
                    size = fend - fstart + 1 + (rend - rstart + 1);
                    ParseFastaByHapType2.addToPosCount(posCount, fstart, fend);
                    ParseFastaByHapType2.addToPosCount(posCount, rstart, rend);
                }
                totalSize += size;
                ++totalCount;
                continue;
            }
            if (match.isForwardExist()) {
                size = fend - fstart + 1;
                ParseFastaByHapType2.addToPosCount(posCount, fstart, fend);
                totalSize += size;
                ++totalCount;
            }
            if (!match.isReverseExist()) continue;
            size = rend - rstart + 1;
            ParseFastaByHapType2.addToPosCount(posCount, rstart, rend);
            totalSize += size;
            ++totalCount;
        }
        String output = " average match size =" + totalSize / totalCount;
        ArrayList<Integer> firmPos = new ArrayList<Integer>();
        for (int pos : posCount.keySet()) {
            if (posCount.get(pos) < COVERAGE_CUTOFF) continue;
            firmPos.add(pos);
        }
        output = String.valueOf(output) + ", positions with over 8x coverage =" + firmPos.size() + " ";
        return output;
    }

    private static void addToPosCount(Map<Integer, Integer> posCount, int start, int end) {
        int i = start;
        while (i < end + 1) {
            int count = posCount.get(i) + 1;
            posCount.put(i, count);
            ++i;
        }
    }

    private static Map<Integer, Integer> initMap(int exonSize) {
        LinkedHashMap<Integer, Integer> posCount = new LinkedHashMap<Integer, Integer>();
        int i = 1;
        while (i < exonSize + 1) {
            posCount.put(i, 0);
            ++i;
        }
        return posCount;
    }

    private static Object getName(String t, Map<String, String> types) {
        for (String name : types.keySet()) {
            if (!types.get(name).equals(t)) continue;
            return name;
        }
        return null;
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).trim().split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, Map<String, OneMatch>> ParseKirResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && Integer.valueOf((items = line.trim().split("\\s+"))[0]) > 50) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && (items = line.trim().split("\\s+"))[1].equals("0.00") && items[2].equals("0.00") && items[3].equals("0.00")) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                    aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                    aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                    aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
                    aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 60 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }
}

