/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class ParseCount {
    public static void main(String[] args) throws Exception {
        File countFile = new File(args[0]);
        File output = new File(args[1]);
        StringBuilder sb = new StringBuilder();
        String[] lines = FileManager.readTextFile(countFile).split("\n");
        String sample = null;
        HashMap sampleExonCount = new HashMap();
        HashMap<String, Integer> totalReadCount = new HashMap<String, Integer>();
        HashMap<String, Integer> clusteredReadCount = new HashMap<String, Integer>();
        HashMap<String, Integer> unclusteredReadCount = new HashMap<String, Integer>();
        HashMap<String, Integer> clusteredAveQual = new HashMap<String, Integer>();
        HashMap<String, Integer> unclusteredAveQual = new HashMap<String, Integer>();
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0) {
                int total;
                String[] items;
                if (lines[i].startsWith("Sample")) {
                    items = lines[i].split("/");
                    sample = items[items.length - 1];
                    sampleExonCount.put(sample, new HashMap());
                } else if (lines[i].startsWith("Total")) {
                    items = lines[i].split("=");
                    total = Integer.valueOf(items[items.length - 1]);
                    totalReadCount.put(sample, total);
                } else if (lines[i].startsWith("Number of pairs clustered=")) {
                    items = lines[i].split("=");
                    total = Integer.valueOf(items[items.length - 1]);
                    clusteredReadCount.put(sample, total);
                } else if (lines[i].startsWith("Clustered average quality=")) {
                    items = lines[i].split("=");
                    total = Integer.valueOf(items[items.length - 1]);
                    clusteredAveQual.put(sample, total);
                } else if (lines[i].startsWith("Number of pairs unclustered=")) {
                    items = lines[i].split("=");
                    total = Integer.valueOf(items[items.length - 1]);
                    unclusteredReadCount.put(sample, total);
                } else if (lines[i].startsWith("Unclustered average quality=")) {
                    items = lines[i].split("=");
                    total = Integer.valueOf(items[items.length - 1]);
                    unclusteredAveQual.put(sample, total);
                } else if (!lines[i].startsWith("Primer") && !lines[i].startsWith("elapsed time")) {
                    items = lines[i].trim().split("\\s+");
                    System.out.println(String.valueOf(lines[i]) + " " + items.length);
                    if (items.length == 2) {
                        System.out.println(String.valueOf(items[0]) + " " + items[1]);
                        ((Map)sampleExonCount.get(sample)).put(items[0], Integer.valueOf(items[1]));
                        System.out.println("add " + items[0] + " " + Integer.valueOf(items[1]));
                    }
                }
            }
            ++i;
        }
        String[] exons = new String[]{"A-1", "A-2", "A-3", "A-23", "A-4", "A-5", "A-67", "A-68", "B-1", "B-2", "B-3", "B-23", "B-4", "B-5", "B-67", "C-1", "C-2", "C-3", "C-23", "C-4", "C-5", "C-67", "C-678", "DPA1-1", "DPA1-2", "DPA1-3", "DPA1-4", "DPB1-1", "DPB1-2", "DPB1-3", "DPB1-4", "DPB1-45", "DQA1-1", "DQA1-2", "DQA1-3", "DQA1-4", "DQB1-1", "DQB1-2", "DQB1-3", "DQB1-4", "DQB1-45", "DQB1-56", "DRB1-1", "DRB1-2", "DRB1-3", "DRB1-4"};
        sb.append("Sample").append("\t").append("TotalReadPairs").append("\t").append("Clustered").append("\t").append("ClusteredPercentage").append("\t").append("ClusteredAveQual").append("\t").append("unClustered").append("\t").append("unClusteredAveQual");
        String[] stringArray = exons;
        int n = exons.length;
        int n2 = 0;
        while (n2 < n) {
            String exon = stringArray[n2];
            sb.append("\t").append(exon);
            ++n2;
        }
        sb.append("\n");
        for (String sampleName : totalReadCount.keySet()) {
            sb.append(sampleName).append("\t").append(totalReadCount.get(sampleName)).append("\t").append(clusteredReadCount.get(sampleName)).append("\t").append((Integer)clusteredReadCount.get(sampleName) * 100 / (Integer)totalReadCount.get(sampleName)).append("\t").append(clusteredAveQual.get(sampleName)).append("\t").append(unclusteredReadCount.get(sampleName)).append("\t").append(unclusteredAveQual.get(sampleName));
            Map exonCount = (Map)sampleExonCount.get(sampleName);
            String[] stringArray2 = exons;
            int n3 = exons.length;
            int n4 = 0;
            while (n4 < n3) {
                String exon = stringArray2[n4];
                sb.append("\t").append(ParseCount.getCount(exonCount, exon));
                ++n4;
            }
            sb.append("\n");
        }
        FileManager.writeTextFile(output, sb.toString(), true);
    }

    private static Integer getCount(Map<String, Integer> exonCount, String exon) {
        if (exonCount.containsKey(exon)) {
            return exonCount.get(exon);
        }
        return 0;
    }
}

