/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.Discrepancy;
import fileOperation.OneMatch;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class LongSeqResloveAmbiguity {
    public static final String[] CI_LOCUS = new String[]{"A", "B", "C"};
    public static final String[] CII_LOCUS = new String[]{"DPB1", "DQB1"};
    public static int MATCH_MIN_SCORE = 2500;
    public static double PERCENT_MISMATCH = 0.2;
    static String LABEL = "Barcode";

    public static void main(String[] args) throws Exception {
        File inputFasta = new File(args[0]);
        File ruleSetFile = new File(args[1]);
        File alignmentDir = new File(args[2]);
        File outputFile = new File(args[3]);
        File rawTypeReport = new File(args[4]);
        Map<String, List<String>> rawTypes = LongSeqResloveAmbiguity.parseRawReport(rawTypeReport);
        StringBuilder resultBuilder = new StringBuilder();
        resultBuilder.append("Sample").append("\t").append("Locus").append("\t").append("Contig").append("\t").append("Type").append("\t").append("Score").append("\t").append("%MisMatch").append("\t").append("HaploidAmbiguity").append("\t").append("MismatchDetail").append("\n");
        Map<String, Map<String, String>> inputBySample = LongSeqResloveAmbiguity.getSequenceFromFasta(inputFasta);
        Map<String, Map<String, String>> inputQualityBySample = LongSeqResloveAmbiguity.getSequenceFromFasta(new File(String.valueOf(inputFasta.getAbsolutePath()) + ".qual"));
        for (String sample : inputBySample.keySet()) {
            Map<String, List<OneMatch>> SampleResult;
            String shortName = sample.replace("_s", "");
            if (rawTypes.containsKey(sample)) {
                System.out.println("start typing sample " + sample);
                SampleResult = LongSeqResloveAmbiguity.runTyping(sample, inputBySample.get(sample), inputQualityBySample.get(sample), ruleSetFile, rawTypes.get(sample), resultBuilder);
                LongSeqResloveAmbiguity.AnalyzeTypingResult(SampleResult, sample, resultBuilder, alignmentDir);
                continue;
            }
            if (rawTypes.containsKey(shortName)) {
                System.out.println("start typing sample " + sample);
                SampleResult = LongSeqResloveAmbiguity.runTyping(sample, inputBySample.get(sample), inputQualityBySample.get(sample), ruleSetFile, rawTypes.get(shortName), resultBuilder);
                LongSeqResloveAmbiguity.AnalyzeTypingResult(SampleResult, sample, resultBuilder, alignmentDir);
                continue;
            }
            System.out.println("skip " + sample);
        }
        FileManager.writeTextFile(outputFile, resultBuilder.toString(), true);
    }

    private static Map<String, List<String>> parseRawReport(File rawTypeReport) {
        HashMap<String, List<String>> rawTypes = new HashMap<String, List<String>>();
        String[] lines = FileManager.readTextFile(rawTypeReport).split("\n");
        boolean startRecord = false;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf("Sample ID") >= 0) {
                startRecord = true;
            } else if (startRecord && (items = line.split("\\s+")).length >= 2 && items[1].indexOf("-CIP_") <= 0) {
                String locus = items[1].trim();
                String name = LongSeqResloveAmbiguity.correctName(items[0].trim());
                if (!rawTypes.containsKey(name)) {
                    System.out.println(" rawTypes " + name);
                    rawTypes.put(name, new ArrayList());
                }
                if ((locus.equals("A") || locus.equals("B") || locus.equals("C")) && items.length >= 4) {
                    ((List)rawTypes.get(name)).add(items[2].trim());
                    String type2 = items[3].trim();
                    if (!((List)rawTypes.get(name)).contains(type2)) {
                        ((List)rawTypes.get(name)).add(type2);
                    }
                }
            }
            ++n2;
        }
        return rawTypes;
    }

    private static String correctName(String fullName) {
        return fullName.split("-")[0];
    }

    private static void AnalyzeTypingResult(Map<String, List<OneMatch>> sampleResult, String sample, StringBuilder resultBuilder, File alignmentDir) {
        List<OneMatch> matches;
        Map<String, List<OneMatch>> SampleResultByLocus = LongSeqResloveAmbiguity.initLocusResultMap();
        for (String seqName : sampleResult.keySet()) {
            matches = sampleResult.get(seqName);
            OneMatch bestTargetMatch = LongSeqResloveAmbiguity.getBestTarget(matches);
            if (!LongSeqResloveAmbiguity.passQcheck(bestTargetMatch)) continue;
            LongSeqResloveAmbiguity.checkHapAmbiguity(bestTargetMatch, alignmentDir);
            LongSeqResloveAmbiguity.addToResult(bestTargetMatch, SampleResultByLocus);
        }
        for (String locus : SampleResultByLocus.keySet()) {
            matches = SampleResultByLocus.get(locus);
            StringBuilder matchInfo = new StringBuilder();
            for (OneMatch match : matches) {
                String discrepencyOutput = LongSeqResloveAmbiguity.logDiscrepencies(match, alignmentDir);
                if (match.getHapAmbiguities() != null) {
                    String type = match.isForwardExist() ? match.getForwardType() : match.getReverseType();
                    LongSeqResloveAmbiguity.resetHapAmbiguity(match, type);
                }
                matchInfo.append(sample).append("\t");
                matchInfo.append(locus).append("\t");
                String contigFullName = match.isForwardExist() ? match.getForwardFullName() : match.getReverseFullName();
                matchInfo.append(LongSeqResloveAmbiguity.extractContig(contigFullName)).append("\t");
                matchInfo.append(match.isForwardExist() ? match.getForwardType() : match.getReverseType()).append("\t");
                matchInfo.append(match.isForwardExist() ? match.getForwardScore() : match.getReverseScore()).append("\t");
                matchInfo.append(match.isForwardExist() ? match.getForwardMisMatch() : match.getReverseMisMatch()).append("\t");
                matchInfo.append(match.getHapAmbiguities() == null ? "" : match.getHapAmbiguities()).append("\t");
                matchInfo.append(discrepencyOutput).append("\n");
            }
            if (matches.size() == 0) {
                resultBuilder.append(sample).append("\t");
                resultBuilder.append(locus).append("\n");
                resultBuilder.append(sample).append("\t");
                resultBuilder.append(locus).append("\n");
                continue;
            }
            if (matches.size() == 1) {
                resultBuilder.append(matchInfo.toString());
                continue;
            }
            resultBuilder.append(matchInfo.toString());
        }
    }

    private static Object extractContig(String contigFullName) {
        String[] items = contigFullName.split("_");
        return items[items.length - 1];
    }

    private static String logDiscrepencies(OneMatch match, File alignmentDir) {
        List<Discrepancy> discrepencies;
        List<Discrepancy> list = discrepencies = match.isForwardExist() ? match.getForDiscrepencies() : match.getRevDiscrepencies();
        if (discrepencies == null || discrepencies.size() == 0) {
            return "";
        }
        StringBuilder log = new StringBuilder();
        String type = match.isForwardExist() ? match.getForwardType() : match.getReverseType();
        File alignmentFile = LongSeqResloveAmbiguity.getLocusAlignmentFile(match, alignmentDir);
        for (Discrepancy d : discrepencies) {
            log.append(d.getType());
            log.append("(").append(d.getQueryQuality()).append(")");
            if (d.getCount() > 1) {
                log.append("-").append(d.getCount());
            }
            log.append("@").append(LongSeqResloveAmbiguity.findExonIntron(d.getTargetPosition(), type, alignmentFile));
            log.append("-").append(d.getTargetPosition());
            log.append(",");
        }
        return log.toString();
    }

    private static String findExonIntron(int targetPosition, String type, File alignmentFile) {
        Map<String, String> seqs = LongSeqResloveAmbiguity.loadGroupSequences(type, alignmentFile);
        String sequence = null;
        Iterator<String> iterator = seqs.values().iterator();
        if (iterator.hasNext()) {
            String seq;
            sequence = seq = iterator.next();
        }
        int spacerCount = 0;
        int deletionCount = 0;
        int i = 0;
        while (i < sequence.length()) {
            if (sequence.charAt(i) == '|') {
                ++spacerCount;
            } else if (sequence.charAt(i) == '.') {
                ++deletionCount;
            }
            if (i - spacerCount - deletionCount + 1 == targetPosition) break;
            ++i;
        }
        String exon = "";
        exon = LongSeqResloveAmbiguity.isCI(type) ? LongSeqResloveAmbiguity.getCIexon(spacerCount, type) : LongSeqResloveAmbiguity.getCIIexon(spacerCount, type);
        return exon;
    }

    private static String getCIIexon(int spacerCount, String type) {
        if (spacerCount == 0) {
            return "5'UTR";
        }
        if (spacerCount == 1) {
            return "exon1";
        }
        if (spacerCount == 2) {
            return "intron1";
        }
        if (spacerCount == 3) {
            return "exon2";
        }
        if (spacerCount == 4) {
            return "intron2";
        }
        if (spacerCount == 5) {
            return "exon3";
        }
        if (spacerCount == 6) {
            return "intron3";
        }
        if (spacerCount == 7) {
            return "exon4";
        }
        if (spacerCount == 8) {
            return "intron4";
        }
        if (spacerCount == 9) {
            return "exon5";
        }
        if (spacerCount == 10) {
            if (type.startsWith("DPB")) {
                return "3'UTR";
            }
            return "intron5";
        }
        if (spacerCount == 11) {
            return "exon6";
        }
        if (spacerCount == 12) {
            return "3'UTR";
        }
        return "";
    }

    private static String getCIexon(int spacerCount, String type) {
        if (spacerCount == 0) {
            return "5'UTR";
        }
        if (spacerCount == 1) {
            return "exon1";
        }
        if (spacerCount == 2) {
            return "intron1";
        }
        if (spacerCount == 3) {
            return "exon2";
        }
        if (spacerCount == 4) {
            return "intron2";
        }
        if (spacerCount == 5) {
            return "exon3";
        }
        if (spacerCount == 6) {
            return "intron3";
        }
        if (spacerCount == 7) {
            return "exon4";
        }
        if (spacerCount == 8) {
            return "intron4";
        }
        if (spacerCount == 9) {
            return "exon5";
        }
        if (spacerCount == 10) {
            return "intron5";
        }
        if (spacerCount == 11) {
            return "exon6";
        }
        if (spacerCount == 12) {
            return "intron6";
        }
        if (spacerCount == 13) {
            return "exon7";
        }
        if (spacerCount == 14) {
            if (type.startsWith("B")) {
                return "3'UTR";
            }
            return "intron7";
        }
        if (spacerCount == 15) {
            return "exon8";
        }
        if (spacerCount == 16) {
            return "3'UTR";
        }
        return "";
    }

    private static boolean isCI(String type) {
        return type.startsWith("A*") || type.startsWith("B*") || type.startsWith("C*");
    }

    private static File getLocusAlignmentFile(OneMatch match, File alignmentDir) {
        String type = match.isForwardExist() ? match.getForwardType() : match.getReverseType();
        String[] items = type.split("\\*");
        File alignmentFile = new File(alignmentDir, String.valueOf(items[0]) + ".fa");
        return alignmentFile;
    }

    private static void checkHapAmbiguity(OneMatch match, File alignmentDir) {
        String type = match.isForwardExist() ? match.getForwardType() : match.getReverseType();
        String[] items = type.split("\\*");
        String[] nameFields = items[1].split(":");
        if (nameFields.length == 4) {
            String gName = String.valueOf(items[0]) + "*" + nameFields[0] + ":" + nameFields[1] + ":" + nameFields[2];
            File alignmentFile = new File(alignmentDir, String.valueOf(items[0]) + ".fa");
            Map<String, String> seqs = LongSeqResloveAmbiguity.loadGroupSequences(gName, alignmentFile);
            System.out.println("\tcheck ambiguity for " + type + " -- memebers of " + gName + " -- " + seqs.keySet().toString());
            String anchorSeq = seqs.get(type);
            for (String typeName : seqs.keySet()) {
                if (typeName.equals(type)) continue;
                Map<Integer, String> difference = LongSeqResloveAmbiguity.loadSeqDiff(anchorSeq, seqs.get(typeName));
                System.out.println("\t\t" + typeName + " " + difference.keySet().toString());
                if (LongSeqResloveAmbiguity.matchRegionShowDifference(match, difference, anchorSeq, seqs.get(typeName))) continue;
                System.out.println("\t\t find hap ambiguity : " + typeName);
                if (match.getHapAmbiguities() == null) {
                    match.setHapAmbiguities(typeName);
                    continue;
                }
                match.setHapAmbiguities(String.valueOf(match.getHapAmbiguities()) + "," + typeName);
            }
        }
    }

    private static void resetHapAmbiguity(OneMatch match, String type) {
        String[] ambTypes;
        String minType = type;
        String[] stringArray = ambTypes = match.getHapAmbiguities().split(",");
        int n = ambTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String ambType = stringArray[n2];
            if (ambType.compareTo(minType) < 0) {
                minType = ambType;
            }
            ++n2;
        }
        if (!minType.equals(type)) {
            ArrayList<String> newAmbTypes = new ArrayList<String>();
            String[] stringArray2 = ambTypes;
            int n3 = ambTypes.length;
            n = 0;
            while (n < n3) {
                String ambType = stringArray2[n];
                if (!ambType.equals(minType)) {
                    newAmbTypes.add(ambType);
                }
                ++n;
            }
            newAmbTypes.add(type);
            Collections.sort(newAmbTypes);
            if (match.isForwardExist()) {
                match.setForwardType(minType);
            } else {
                match.setReverseType(minType);
            }
            match.setHapAmbiguities(null);
            for (String ambType : newAmbTypes) {
                if (match.getHapAmbiguities() == null) {
                    match.setHapAmbiguities(ambType);
                    continue;
                }
                match.setHapAmbiguities(String.valueOf(match.getHapAmbiguities()) + "," + ambType);
            }
        }
    }

    private static boolean matchRegionShowDifference(OneMatch match, Map<Integer, String> difference, String anchorSeq, String seq) {
        int targetStart = match.isForwardExist() ? match.getForwardTargetStart() : match.getReverseTargetStart();
        int targetEnd = match.isForwardExist() ? match.getForwardTargetEnd() : match.getReverseTargetEnd();
        List<Discrepancy> discrepencies = match.isForwardExist() ? match.getForDiscrepencies() : match.getRevDiscrepencies();
        System.out.println("\t\ttargetStart=" + targetStart + ", targetEnd=" + targetEnd);
        for (Integer pos : difference.keySet()) {
            int realPosition = LongSeqResloveAmbiguity.covertToRealPosition(anchorSeq, pos);
            if (realPosition + 1 < targetStart || realPosition + 1 > targetEnd || LongSeqResloveAmbiguity.inDiscrepancyList(realPosition, discrepencies)) continue;
            System.out.println("\t\tfindDiff at " + realPosition);
            return true;
        }
        return false;
    }

    private static boolean inDiscrepancyList(int realPosition, List<Discrepancy> discrepencies) {
        for (Discrepancy d : discrepencies) {
            if (d.getTargetPosition() != realPosition + 1) continue;
            return true;
        }
        return false;
    }

    private static int covertToRealPosition(String anchorSeq, Integer pos) {
        int paddingCount = 0;
        int i = 0;
        while (i < pos) {
            if (anchorSeq.charAt(i) == '.') {
                ++paddingCount;
            }
            ++i;
        }
        return pos - paddingCount;
    }

    private static Map<Integer, String> loadSeqDiff(String anchorSeq, String seq) {
        LinkedHashMap<Integer, String> difference = new LinkedHashMap<Integer, String>();
        int i = 0;
        while (i < anchorSeq.length()) {
            if (i >= seq.length()) break;
            if (anchorSeq.charAt(i) != '*' && seq.charAt(i) != '*' && anchorSeq.charAt(i) != seq.charAt(i)) {
                difference.put(i, String.valueOf(seq.charAt(i)));
            }
            ++i;
        }
        return difference;
    }

    private static Map<String, String> loadGroupSequences(String gName, File ruleSetFile) {
        LinkedHashMap<String, String> seqs = new LinkedHashMap<String, String>();
        boolean find = false;
        String[] lines = FileManager.readTextFile(ruleSetFile).split("\n");
        int i = 0;
        while (i < lines.length - 1) {
            if (lines[i].startsWith(">" + gName)) {
                seqs.put(lines[i].trim().substring(1), lines[i + 1].trim());
                find = true;
            }
            if (lines[i].startsWith(">") && !lines[i].startsWith(">" + gName) && find) break;
            ++i;
        }
        return seqs;
    }

    private static void addToResult(OneMatch bestTargetMatch, Map<String, List<OneMatch>> sampleResultByLocus) {
        String type = bestTargetMatch.isForwardExist() ? bestTargetMatch.getForwardType() : bestTargetMatch.getReverseType();
        String locus = type.split("\\*")[0];
        if (sampleResultByLocus.containsKey(locus)) {
            sampleResultByLocus.get(locus).add(bestTargetMatch);
        }
    }

    private static boolean passQcheck(OneMatch match) {
        double mismatch;
        int score = match.getForwardScore() > match.getReverseScore() ? match.getForwardScore() : match.getReverseScore();
        double d = mismatch = match.getForwardScore() > match.getReverseScore() ? match.getForwardMisMatch() : match.getReverseMisMatch();
        return score > MATCH_MIN_SCORE && mismatch <= PERCENT_MISMATCH;
    }

    private static OneMatch getBestTarget(List<OneMatch> matches) {
        OneMatch bestTarget = null;
        int score = 0;
        for (OneMatch match : matches) {
            if (match.isForwardExist() && match.getForwardScore() > score) {
                score = match.getForwardScore();
                bestTarget = match;
            }
            if (!match.isReverseExist() || match.getReverseScore() <= score) continue;
            score = match.getReverseScore();
            bestTarget = match;
        }
        return bestTarget;
    }

    private static Map<String, List<OneMatch>> initLocusResultMap() {
        String locus;
        LinkedHashMap<String, List<OneMatch>> SampleResultByLocus = new LinkedHashMap<String, List<OneMatch>>();
        String[] stringArray = CI_LOCUS;
        int n = CI_LOCUS.length;
        int n2 = 0;
        while (n2 < n) {
            locus = stringArray[n2];
            SampleResultByLocus.put(locus, new ArrayList());
            ++n2;
        }
        stringArray = CII_LOCUS;
        n = CII_LOCUS.length;
        n2 = 0;
        while (n2 < n) {
            locus = stringArray[n2];
            SampleResultByLocus.put(locus, new ArrayList());
            ++n2;
        }
        return SampleResultByLocus;
    }

    private static Map<String, List<OneMatch>> runTyping(String sample, Map<String, String> sequences, Map<String, String> qualities, File ruleSetFile, List<String> rawTypes, StringBuilder resultBuilder) throws Exception {
        String[] lines2;
        File tmpFile = LongSeqResloveAmbiguity.createQueryFile(sequences, qualities);
        File subRuleSetFile = LongSeqResloveAmbiguity.createSubRulesetFile(rawTypes, ruleSetFile);
        File matchResult = LongSeqResloveAmbiguity.runCrossMatch(tmpFile, subRuleSetFile);
        File detailMatchResult = LongSeqResloveAmbiguity.runDetailedCrossMatch(tmpFile, subRuleSetFile);
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        HashMap<String, List<OneMatch>> SampleResult = new HashMap<String, List<OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                startRecord = true;
                fullName = items[4].trim();
                aMatch = LongSeqResloveAmbiguity.populateAmatch(line);
                if (!SampleResult.containsKey(fullName)) {
                    SampleResult.put(fullName, new ArrayList());
                }
                ((List)SampleResult.get(fullName)).add(aMatch);
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                LongSeqResloveAmbiguity.populateDiscrepency(aMatch, line, fullName);
            }
            ++n2;
        }
        String[] stringArray2 = lines2 = FileManager.readTextFile(detailMatchResult).split("\n");
        int n3 = lines2.length;
        n = 0;
        while (n < n3) {
            String line = stringArray2[n];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                System.out.println(line);
            } else if (startRecord && line.trim().split("\\s+").length == 5) {
                System.out.println(line);
            }
            ++n;
        }
        return SampleResult;
    }

    private static File runDetailedCrossMatch(File fastaFile, File ruleSetFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -minmatch 200 -minscore 2500 -masklevel 101 -discrep_lists " + fastaFile.getAbsolutePath() + " " + ruleSetFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tmpFile;
    }

    private static File createSubRulesetFile(List<String> rawTypes, File ruleSetFile) throws Exception {
        LinkedHashMap<String, String> seqences = new LinkedHashMap<String, String>();
        for (String type : rawTypes) {
            LongSeqResloveAmbiguity.getAllMemeberSequences(ruleSetFile, type, seqences);
        }
        File tempRuleFile = LongSeqResloveAmbiguity.writeOutSequences(seqences);
        return tempRuleFile;
    }

    private static File writeOutSequences(Map<String, String> seqences) throws Exception {
        StringBuilder builder = new StringBuilder();
        File tmpFile = File.createTempFile("rule", "fa");
        tmpFile.deleteOnExit();
        for (String name : seqences.keySet()) {
            builder.append(">").append(name).append("\n");
            builder.append(seqences.get(name)).append("\n");
        }
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        return tmpFile;
    }

    private static void getAllMemeberSequences(File hapFile, String type, Map<String, String> seqences) {
        String[] lines = FileManager.readTextFile(hapFile).split("\n");
        boolean findType = false;
        int i = 0;
        while (i < lines.length) {
            String name = lines[i].substring(1);
            if (name.indexOf(type) == 0) {
                findType = true;
                seqences.put(name, lines[i + 1]);
            } else if (findType) break;
            ++i;
            ++i;
        }
    }

    private static void populateDiscrepency(OneMatch match, String line, String fullName) {
        System.out.println("--------" + line);
        String[] items = line.trim().split("\\s+");
        if (items[0].charAt(0) != 'S' && items[0].charAt(0) != 'I' && items[0].charAt(0) != 'D') {
            return;
        }
        Discrepancy dis = LongSeqResloveAmbiguity.generateDiscrepancy(items);
        if (match.getForwardFullName() != null && match.getForwardFullName().equals(fullName)) {
            System.out.println("-------- add to for " + line);
            match.addForDiscrepencies(dis);
        } else if (match.getReverseFullName() != null && match.getReverseFullName().equals(fullName)) {
            System.out.println("-------- add to rev " + line);
            match.addRevDiscrepencies(dis);
        } else {
            System.out.println("error in parsing discrep !!!!!!!!!!!!");
        }
    }

    private static OneMatch populateAmatch(String line) {
        String[] items = line.trim().split("\\s+");
        String fullName = items[4].trim();
        String sampleName = LongSeqResloveAmbiguity.getSampleName(fullName);
        boolean isRevComp = items[8].trim().equals("C");
        String type = isRevComp ? items[9].trim() : items[8].trim();
        OneMatch aMatch = new OneMatch();
        aMatch.setName(fullName);
        if (isRevComp) {
            aMatch.setReverseExist(true);
            aMatch.setReverseType(type);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim()));
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardType(type);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()) + Double.valueOf(items[2].trim()) + Double.valueOf(items[3].trim()));
        }
        return aMatch;
    }

    private static Discrepancy generateDiscrepancy(String[] item) {
        int count = 1;
        if (item[0].trim().length() > 1) {
            count = new Integer(item[0].trim().substring(2));
        }
        String base = item[2].trim().substring(0, item[2].indexOf("("));
        int qual = new Integer(item[2].trim().substring(item[2].indexOf("(") + 1, item[2].indexOf(")")));
        Discrepancy dis = new Discrepancy(item[0].charAt(0), count, new Integer(item[1]), base, qual, new Integer(item[3]), item[4].trim());
        return dis;
    }

    private static File runCrossMatch(File fastaFile, File ruleSetFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -minmatch 200 -discrep_lists " + fastaFile.getAbsolutePath() + " " + ruleSetFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        command.makeItSo();
        return tmpFile;
    }

    private static File createQueryFile(Map<String, String> sequences, Map<String, String> qualities) throws IOException {
        File tmpFile = File.createTempFile("seq", "fa");
        tmpFile.deleteOnExit();
        StringBuilder builder = new StringBuilder();
        for (String id : sequences.keySet()) {
            builder.append(">").append(id).append("\n");
            builder.append(sequences.get(id)).append("\n");
        }
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        File tmpQualityFile = new File(String.valueOf(tmpFile.getAbsolutePath()) + ".qual");
        tmpQualityFile.deleteOnExit();
        StringBuilder qbuilder = new StringBuilder();
        for (String id : qualities.keySet()) {
            qbuilder.append(">").append(id).append("\n");
            qbuilder.append(qualities.get(id)).append("\n");
        }
        FileManager.writeTextFile(tmpQualityFile, qbuilder.toString(), true);
        return tmpFile;
    }

    private static Map<String, Map<String, String>> getSequenceFromFasta(File fastaFile) {
        LinkedHashMap<String, Map<String, String>> inputBySample = new LinkedHashMap<String, Map<String, String>>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length - 1) {
            String line = lines[i].trim();
            if (line.startsWith(">")) {
                String id = line.substring(1);
                String sampleName = LongSeqResloveAmbiguity.getSampleName(id);
                if (!inputBySample.containsKey(sampleName)) {
                    inputBySample.put(sampleName, new LinkedHashMap());
                }
                ((Map)inputBySample.get(sampleName)).put(id, lines[i + 1].trim());
            }
            ++i;
        }
        System.out.println("sample size=" + inputBySample.size());
        return inputBySample;
    }

    private static String getSampleName(String id) {
        String name = id.split("--")[0].replace("Barcode", "");
        return name;
    }
}

