/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;

public class IndexGroup {
    public static void main(String[] args) throws Exception {
        File indexFile = new File(args[0]);
        BufferedReader indexReader = new BufferedReader(new FileReader(indexFile));
        try {
            String line;
            String name = null;
            String sequence = null;
            String qualityChars = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            String header = null;
            HashMap<String, Integer> countMap = new HashMap<String, Integer>();
            while ((line = indexReader.readLine()) != null) {
                if (++lineCount == 1) {
                    header = line.split(":")[0];
                    System.out.println("detect header : " + header);
                }
                if (line.startsWith(header)) {
                    name = line.trim().split("\\s+")[0];
                    isSeq = true;
                } else if (line.startsWith("+") && line.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence = line.trim();
                } else {
                    qualityChars = line.trim();
                }
                if (sequence == null || qualityChars == null) continue;
                if (!countMap.containsKey(sequence)) {
                    countMap.put(sequence, 0);
                }
                countMap.put(sequence, (Integer)countMap.get(sequence) + 1);
                ++count;
                sequence = null;
                qualityChars = null;
                name = null;
            }
            System.out.println("processed barcodes " + lineCount / 4);
            for (String seq : countMap.keySet()) {
                if ((Integer)countMap.get(seq) <= 500) continue;
                System.out.println(String.valueOf(seq) + " : " + countMap.get(seq));
            }
        }
        finally {
            indexReader.close();
        }
    }

    private static Map<String, Integer> initBarcodeCount(Map<String, String> barcodeMap) {
        HashMap<String, Integer> barcodeCount = new HashMap<String, Integer>();
        for (String barcode : barcodeMap.keySet()) {
            barcodeCount.put(barcode, 0);
        }
        return barcodeCount;
    }

    private static void appendToFile(BufferedReader readReader, File outputDir, String name) throws Exception {
        File targetFile = new File(outputDir, String.valueOf(name) + ".fq");
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        String[] nameLine = readReader.readLine().trim().split("\\s+");
        writer.write(nameLine[0].trim());
        writer.write("/");
        writer.write(nameLine[1].trim().charAt(0));
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.write(readReader.readLine().trim());
        writer.write("\n");
        writer.close();
    }

    private static void jumpLines(BufferedReader readReader, int step) throws Exception {
        int i = 0;
        while (i < step) {
            readReader.readLine();
            ++i;
        }
    }

    private static Map<String, String> initBarcodeMap(File barcodeFile) {
        String[] lines;
        HashMap<String, String> barcodeCount = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(barcodeFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split(",");
            String barcode = items[0].trim();
            String name = items[1].trim();
            barcodeCount.put(IndexGroup.revComp(barcode), name);
            ++n2;
        }
        System.out.println(String.valueOf(barcodeCount.size()) + " total barcodes");
        return barcodeCount;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(IndexGroup.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

