/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import misc.FileManager;

public class GenerateBridgeRuleset {
    static String BRIDGE23 = "bridge23";

    public static void main(String[] args) throws Exception {
        File inputFile = new File(args[0]);
        File outputDir = new File(args[1]);
        int leftTrim = new Integer(args[2]);
        int rightTrim = new Integer(args[3]);
        GenerateBridgeRuleset.generateRuleset(inputFile, outputDir, leftTrim, rightTrim);
    }

    private static void generateRuleset(File inputFile, File outputDir, int leftTrim, int rightTrim) {
        File bridgeFa = new File(outputDir, String.valueOf(inputFile.getName().split("-")[0]) + "-" + BRIDGE23 + ".fa");
        File bridgeAmb = new File(outputDir, String.valueOf(bridgeFa.getName().substring(0, bridgeFa.getName().length() - 3)) + "-hap-amb.txt");
        StringBuilder fa = new StringBuilder();
        LinkedHashMap seqMap = new LinkedHashMap();
        String[] lines = FileManager.readTextFile(inputFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1, lines[i].trim().length());
                fa.append(lines[i].trim()).append("\n");
                String seq = lines[i + 1].trim().substring(leftTrim, lines[i + 1].trim().length() - rightTrim);
                fa.append(seq).append("\n");
                if (!seqMap.containsKey(seq)) {
                    seqMap.put(seq, new ArrayList());
                }
                ((List)seqMap.get(seq)).add(name);
            }
            ++i;
        }
        FileManager.writeTextFile(bridgeFa, fa.toString(), true);
        int count = 0;
        StringBuilder amb = new StringBuilder();
        for (List names : seqMap.values()) {
            if (names.size() <= 1) continue;
            String gName = String.valueOf((String)names.get(0)) + "R";
            amb.append(gName).append("\t");
            for (String name : names) {
                amb.append(name).append("\t");
            }
            ++count;
            amb.append("\n");
        }
        System.out.println(count);
        FileManager.writeTextFile(bridgeAmb, amb.toString(), true);
    }
}

