/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class FindNewDiploidAmb {
    public static void main(String[] args) throws Exception {
        String[] lines;
        File ruleDir = new File(args[0]);
        File outFile = new File(args[1]);
        String locus = new String(args[2]);
        File testFile = new File(args[3]);
        File majorFaFile = null;
        File majorAmbFile = null;
        File minorFaFile = null;
        File minorAmbFile = null;
        majorFaFile = new File(ruleDir, String.valueOf(locus) + "-exon23.fa");
        majorAmbFile = new File(ruleDir, String.valueOf(locus) + "-exon23-hap-amb.txt");
        minorFaFile = new File(ruleDir, String.valueOf(locus) + "-bridge.fa");
        minorAmbFile = new File(ruleDir, String.valueOf(locus) + "-bridge-hap-amb.txt");
        File exon2FaFile = new File(ruleDir, String.valueOf(locus) + "-exon2.fa");
        File exon3FaFile = new File(ruleDir, String.valueOf(locus) + "-exon3.fa");
        Map<String, String> majorNameToGnameMap = FindNewDiploidAmb.parseAmbFile(majorAmbFile);
        StringBuilder sb = new StringBuilder();
        String[] stringArray = lines = FileManager.readTextFile(testFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String type2;
            String line = stringArray[n2];
            String[] items = line.split("\\s+");
            String type1 = items[2].trim();
            if (type1.equals(type2 = items[3].trim())) {
                sb.append(line.trim()).append("\t").append("homo").append("\n");
            } else {
                String t1 = FindNewDiploidAmb.getActualName(type1, majorAmbFile);
                String t2 = FindNewDiploidAmb.getActualName(type2, majorAmbFile);
                System.out.println(String.valueOf(type1) + " " + type2 + " " + t1 + " " + t2);
                String seq1 = FindNewDiploidAmb.getSeqFromFasta(t1, minorFaFile);
                String seq2 = FindNewDiploidAmb.getSeqFromFasta(t2, minorFaFile);
                if (!seq1.subSequence(140, 381).equals(seq2.subSequence(140, 381))) {
                    sb.append(line.trim()).append("\t").append("diffIntronPhased").append("\n");
                } else {
                    String exon2seq1 = FindNewDiploidAmb.getSeqFromFasta(t1, exon2FaFile);
                    String exon3seq1 = FindNewDiploidAmb.getSeqFromFasta(t1, exon3FaFile);
                    String exon2seq2 = FindNewDiploidAmb.getSeqFromFasta(t2, exon2FaFile);
                    String exon3seq2 = FindNewDiploidAmb.getSeqFromFasta(t2, exon3FaFile);
                    String newSeq1 = String.valueOf(seq1.substring(0, 140)) + seq2.substring(140);
                    String newSeq2 = String.valueOf(seq2.substring(0, 140)) + seq1.substring(140);
                    String newType1 = FindNewDiploidAmb.getSeqName(minorFaFile, newSeq1, exon2seq1, exon3seq2, exon2FaFile, exon3FaFile, majorNameToGnameMap, type1, type2);
                    String newType2 = FindNewDiploidAmb.getSeqName(minorFaFile, newSeq2, exon2seq2, exon3seq1, exon2FaFile, exon3FaFile, majorNameToGnameMap, type1, type2);
                    if (newType1 == null || newType2 == null) {
                        sb.append(line.trim()).append("\t").append("sameIntronOK").append("\n");
                    } else {
                        sb.append(line.trim()).append("\t").append("sameIntronAmb:").append(newType1).append("+").append(newType2).append("\n");
                    }
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(outFile, sb.toString(), true);
    }

    private static String getSeqName(File faFile, String newSeq, String exon2seq, String exon3seq, File exon2FaFile, File exon3FaFile, Map<String, String> majorNameToGnameMap, String type1, String type2) {
        String[] lines = FileManager.readTextFile(faFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (!line.startsWith(">") && line.equals(newSeq)) {
                String name = lines[i - 1].trim().substring(1, lines[i - 1].trim().length());
                String newSeq2 = FindNewDiploidAmb.getSeqFromFasta(name, exon2FaFile);
                String newSeq3 = FindNewDiploidAmb.getSeqFromFasta(name, exon3FaFile);
                if (newSeq2.equals(exon2seq) && newSeq3.equals(exon3seq)) {
                    String t1 = type1;
                    String t2 = type2;
                    String n = name;
                    if (majorNameToGnameMap.containsKey(type1)) {
                        t1 = majorNameToGnameMap.get(type1);
                    }
                    if (majorNameToGnameMap.containsKey(type2)) {
                        t2 = majorNameToGnameMap.get(type2);
                    }
                    if (majorNameToGnameMap.containsKey(name)) {
                        n = majorNameToGnameMap.get(name);
                    }
                    if (!n.equals(t1) && !n.equals(t2)) {
                        return name;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static String getSeqFromFasta(String typeName, File faFile) {
        String[] lines = FileManager.readTextFile(faFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith(">") && line.substring(1, line.length()).equals(typeName)) {
                return lines[i + 1].trim();
            }
            ++i;
        }
        return null;
    }

    private static String getActualName(String type, File ambFile) {
        String[] lines;
        if (!type.endsWith("G") && !type.endsWith("R")) {
            return type;
        }
        String[] stringArray = lines = FileManager.readTextFile(ambFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] names;
            String gName;
            String line = stringArray[n2];
            if (line.trim().length() != 0 && (gName = (names = line.trim().split("\\s+"))[0]).equals(type)) {
                return names[1];
            }
            ++n2;
        }
        return null;
    }

    private static Map<String, String> getHapAmbTypes(File ambFile, String locus) {
        String[] lines = FileManager.readTextFile(ambFile).split("\n");
        HashMap<String, String> nameToGnameMap = new HashMap<String, String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] names = line.trim().split("\\s+");
                String gName = names[0];
                int i = 1;
                while (i < names.length) {
                    String name = names[i].trim();
                    if (name.startsWith(locus) && !nameToGnameMap.containsKey(name)) {
                        nameToGnameMap.put(name, gName);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return nameToGnameMap;
    }

    private static List<List<String>> resolve(List<List<String>> possibleDiploidAmbPairs, Map<String, String> nameToGnameMap, List<String> unknownList) {
        ArrayList<List<String>> dipAmbs = new ArrayList<List<String>>();
        for (List<String> pairs : possibleDiploidAmbPairs) {
            String pair1 = pairs.get(0);
            String pair2 = pairs.get(1);
            String type1A = pair1.split("\\+")[0];
            String type1B = pair1.split("\\+")[1];
            String type2A = pair2.split("\\+")[0];
            String type2B = pair2.split("\\+")[1];
            if (type1A.equals(type2A) || type1A.equals(type2B) || type1B.equals(type2A) || type1B.equals(type2B)) continue;
            String gName1A = nameToGnameMap.get(type1A);
            String gName1B = nameToGnameMap.get(type1B);
            String gName2A = nameToGnameMap.get(type2A);
            String gName2B = nameToGnameMap.get(type2B);
            int missNum = FindNewDiploidAmb.getMissNumber(type1A, type1B, type2A, type2B, unknownList);
            if (missNum == 0) {
                if (gName1A == null || gName1B == null || gName2A == null || gName2B == null) continue;
                if (gName1A.equals(gName2A) && gName1B.equals(gName2B)) {
                    dipAmbs.add(pairs);
                    continue;
                }
                if (!gName1A.equals(gName2B) || !gName1B.equals(gName2A)) continue;
                dipAmbs.add(pairs);
                continue;
            }
            if (missNum == 1) continue;
            System.out.println("unknown " + pairs);
            dipAmbs.add(pairs);
        }
        return dipAmbs;
    }

    private static int getMissNumber(String type1a, String type1b, String type2a, String type2b, List<String> unknownList) {
        int ret = 0;
        if (unknownList.contains(type1a)) {
            ++ret;
        }
        if (unknownList.contains(type1b)) {
            ++ret;
        }
        if (unknownList.contains(type2a)) {
            ++ret;
        }
        if (unknownList.contains(type2b)) {
            ++ret;
        }
        return ret;
    }

    private static List<List<String>> checkPossibleDiploidAmb(List<String> startPairs, Map<String, String> nameToGnameMap) {
        ArrayList<List<String>> dipAmbs = new ArrayList<List<String>>();
        int i = 0;
        while (i < startPairs.size()) {
            String pair1 = startPairs.get(i);
            int j = i + 1;
            while (j < startPairs.size() - 1) {
                String pair2 = startPairs.get(j);
                if (FindNewDiploidAmb.possibleDiploidAmb(pair1, pair2, nameToGnameMap)) {
                    ArrayList<String> pairs = new ArrayList<String>();
                    pairs.add(pair1);
                    pairs.add(pair2);
                    dipAmbs.add(pairs);
                }
                ++j;
            }
            ++i;
        }
        System.out.println(dipAmbs.size());
        return dipAmbs;
    }

    private static boolean possibleDiploidAmb(String pair1, String pair2, Map<String, String> nameToGnameMap) {
        String type1A = pair1.split("\\+")[0];
        String type1B = pair1.split("\\+")[1];
        String type2A = pair2.split("\\+")[0];
        String type2B = pair2.split("\\+")[1];
        String gName1A = nameToGnameMap.get(type1A);
        String gName1B = nameToGnameMap.get(type1B);
        String gName2A = nameToGnameMap.get(type2A);
        String gName2B = nameToGnameMap.get(type2B);
        if (gName1A.equals(gName2A) && gName1B.equals(gName2B)) {
            return true;
        }
        return gName1A.equals(gName2B) && gName1B.equals(gName2A);
    }

    private static Map<String, List<String>> createHapAmb(File majorFaFile, File minorFaFile, List<String> unknownList, String locus, Map<String, String> currentHapAmbList) {
        HashMap<String, List<String>> ambs = new HashMap<String, List<String>>();
        Map<String, String> majorSeqs = FindNewDiploidAmb.getFastas(majorFaFile, locus);
        Map<String, String> minorSeqs = FindNewDiploidAmb.getFastas(minorFaFile, locus);
        HashMap seqToName = new HashMap();
        for (String name : majorSeqs.keySet()) {
            if (!currentHapAmbList.containsKey(name)) continue;
            String seq = majorSeqs.get(name);
            if (!minorSeqs.containsKey(name)) {
                unknownList.add(name);
                continue;
            }
            String fullSeq = String.valueOf(seq) + minorSeqs.get(name);
            if (!seqToName.containsKey(fullSeq)) {
                seqToName.put(fullSeq, new ArrayList());
            }
            ((List)seqToName.get(fullSeq)).add(name);
        }
        for (String type : unknownList) {
            System.out.println("unknown " + type);
        }
        for (List names : seqToName.values()) {
            if (names.size() <= 1) continue;
            String mName = String.valueOf((String)names.get(0)) + "m";
            ambs.put(mName, names);
            StringBuilder line = new StringBuilder();
            line.append(mName).append("\t");
            for (String name : names) {
                line.append(name).append("\t");
            }
            System.out.println(line.toString());
        }
        return ambs;
    }

    private static Map<String, String> getFastas(File fastaFile, String locus) {
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        LinkedHashMap<String, String> backboneMap = new LinkedHashMap<String, String>();
        int i = 0;
        while (i < lines.length) {
            String name;
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">") && (name = lines[i].trim().substring(1)).startsWith(locus)) {
                String sequence = lines[i + 1].trim();
                backboneMap.put(name, sequence);
            }
            ++i;
        }
        return backboneMap;
    }

    private static List<String> constructPairs(File ambFile, Map<String, List<String>> HapAmbNames, String locus, Map<String, String> nameToGnameMap) {
        ArrayList<String> pairs = new ArrayList<String>();
        for (String aname : nameToGnameMap.keySet()) {
            for (String bname : nameToGnameMap.keySet()) {
                String pair;
                if (nameToGnameMap.get(aname).equals(nameToGnameMap.get(bname)) || pairs.contains(pair = FindNewDiploidAmb.orderPair(aname, bname))) continue;
                pairs.add(pair);
            }
        }
        System.out.println(String.valueOf(pairs.size()) + " pairs");
        return pairs;
    }

    private static String orderPair(String aname, String bname) {
        if (aname.compareTo(bname) > 0) {
            return String.valueOf(bname) + "+" + aname;
        }
        return String.valueOf(aname) + "+" + bname;
    }

    private static Map<String, String> parseAmbFile(File ambFile) {
        String[] lines = FileManager.readTextFile(ambFile).split("\n");
        HashMap<String, String> nameToGnameMap = new HashMap<String, String>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] names = line.trim().split("\\s+");
                String gName = names[0];
                int i = 1;
                while (i < names.length) {
                    String name = names[i].trim();
                    if (!nameToGnameMap.containsKey(name)) {
                        nameToGnameMap.put(name, gName);
                    }
                    ++i;
                }
            }
            ++n2;
        }
        return nameToGnameMap;
    }

    private static String getAmbName(String name, Map<String, List<String>> hapAmbNames) {
        for (String gname : hapAmbNames.keySet()) {
            List<String> names = hapAmbNames.get(gname);
            for (String n : names) {
                if (!n.equals(name)) continue;
                return gname;
            }
        }
        return name;
    }
}

