/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class FilterDulipcates {
    private static int MATCH_CHUNK_MIN_PERCENT = 80;
    private static double MATCH_CHUNK_HIT_DISCREP_MAX = 0.5;

    public static void main(String[] args) throws Exception {
        File seqFile = new File(args[0]);
        File matchFile = new File(args[1]);
        File newSeqFile = new File(args[2]);
        File logFile = new File(args[3]);
        String name = new String(args[4]);
        Map<String, String> sequences = FilterDulipcates.getSequenceFromFasta(seqFile);
        HashMap<String, String> hits = new HashMap<String, String>();
        List<String> removeList = FilterDulipcates.parseMatch(matchFile, name, sequences, hits);
        StringBuilder out = new StringBuilder();
        for (String sName : sequences.keySet()) {
            if (removeList.contains(sName)) continue;
            out.append(">").append(sName).append("\n");
            out.append(sequences.get(sName)).append("\n");
        }
        StringBuilder log = new StringBuilder();
        for (String aName : hits.keySet()) {
            log.append(aName).append(",").append((String)hits.get(aName)).append("\n");
        }
        FileManager.writeTextFile(newSeqFile, out.toString(), true);
        FileManager.writeTextFile(logFile, log.toString(), true);
    }

    private static List<String> parseMatch(File matchFile, String name, Map<String, String> sequences, Map<String, String> hits) {
        String[] lines;
        ArrayList<String> removeList = new ArrayList<String>();
        String[] stringArray = lines = FileManager.readTextFile(matchFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] items = line.trim().split("\\s+");
            if (line.indexOf(String.valueOf(name) + "-") >= 0 && items.length >= 12) {
                String qname = items[4];
                String fname = items[8];
                if (items[8].equals("C")) {
                    fname = items[9];
                }
                FilterDulipcates.testMatch(items, removeList, sequences, hits);
            }
            ++n2;
        }
        return removeList;
    }

    public static Map<String, String> getSequenceFromFasta(File fastaFile) throws Exception {
        LinkedHashMap<String, String> sequences = new LinkedHashMap<String, String>();
        String[] lines = FileManager.readTextFile(fastaFile).split("\n");
        int i = 0;
        while (i < lines.length) {
            if (lines[i].trim().length() != 0 && lines[i].trim().startsWith(">")) {
                String name = lines[i].trim().substring(1);
                String sequence = lines[i + 1].trim();
                sequences.put(name, sequence);
            }
            ++i;
        }
        return sequences;
    }

    private static boolean testMatch(String[] items, List<String> removeList, Map<String, String> sequences, Map<String, String> hits) {
        int score = new Integer(items[0]);
        double sub = new Double(items[1]);
        double ins = new Double(items[2]);
        double del = new Double(items[3]);
        int qSize = sequences.get(items[4]).length();
        int tSize = 0;
        String qName = items[4];
        String tName = items[8];
        if (items[8].equals("C")) {
            tName = items[9];
            tSize = sequences.get(items[9]).length();
        } else {
            tSize = sequences.get(items[8]).length();
        }
        double diff = sub + ins + del;
        if (diff > MATCH_CHUNK_HIT_DISCREP_MAX) {
            return false;
        }
        if (score > MATCH_CHUNK_MIN_PERCENT * qSize / 100 || score > MATCH_CHUNK_MIN_PERCENT * tSize / 100) {
            if (tSize > qSize && !removeList.contains(tName) && !removeList.contains(qName)) {
                removeList.add(qName);
            }
            if (!hits.containsKey(tName) || !hits.get(tName).equals(qName)) {
                hits.put(qName, tName);
            }
            return true;
        }
        return false;
    }
}

