/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.LocusExon;
import fileOperation.LocusExonResult;
import fileOperation.SummarizeTypingResult;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class FilterAmbTypes {
    static String DPA1 = "DPA1";
    static String DPB1 = "DPB1";
    static String DQA1 = "DQA1";
    static String DQB1 = "DQB1";
    static String HLAA = "A";
    static String HLAB = "B";
    static String HLAC = "C";
    static String DRB1345 = "DRB1345";
    static String DRB1 = "DRB1";
    static String DRB345 = "DRB345";
    static String DRB3 = "DRB3";
    static String DRB4 = "DRB4";
    static String DRB5 = "DRB5";
    static String EXON2 = "exon2";
    static String EXON3 = "exon3";
    static String EXON4 = "exon4";
    static String EXON23 = "exon23";
    static String HAP_AMB_TXT = "-hap-amb.txt";

    public static void main(String[] args) throws Exception {
        File majorFile = new File(args[0]);
        File minorFile = new File(args[1]);
        File outputFile = new File(args[2]);
        File hapTypeRoot = new File(args[3]);
        Map<String, List<LocusExon>> allLocus = SummarizeTypingResult.initLocusMap();
        HashMap summaryMap = new HashMap();
        StringBuilder out = new StringBuilder();
        out.append("name\t").append("locue\t").append("exon\t").append("type1\t").append("type2\t").append("exon\t").append("type1\t").append("type2\t");
        out.append("CombinedExon\t").append("type1\t").append("type2\t").append("isConsistent\t").append("log\n");
        for (String locus : allLocus.keySet()) {
            Map<String, LocusExonResult> locusExonResultCombine;
            Map<String, LocusExonResult> locusExonResultMinor;
            Map<String, LocusExonResult> locusExonResultMajor;
            System.out.println("--------------process " + locus);
            summaryMap.put(locus, new HashMap());
            List<LocusExon> locusExons = allLocus.get(locus);
            if (locusExons.size() == 1) continue;
            File hapTypeFile1 = new File(hapTypeRoot, String.valueOf(locus) + "-" + locusExons.get(0).getExon() + ".fa");
            File hapAmbFile1 = new File(hapTypeRoot, String.valueOf(hapTypeFile1.getName().substring(0, hapTypeFile1.getName().length() - 3)) + HAP_AMB_TXT);
            File hapTypeFile2 = new File(hapTypeRoot, String.valueOf(locus) + "-" + locusExons.get(1).getExon() + ".fa");
            File hapAmbFile2 = new File(hapTypeRoot, String.valueOf(hapTypeFile2.getName().substring(0, hapTypeFile2.getName().length() - 3)) + HAP_AMB_TXT);
            if (locus.equals("DRB1345")) {
                locusExonResultMajor = FilterAmbTypes.getMajorResult(majorFile, "DRB1");
                locusExonResultMinor = FilterAmbTypes.getMinorResult(minorFile, "DRB1");
                locusExonResultCombine = FilterAmbTypes.combineResult(locusExonResultMajor, locusExonResultMinor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2);
                FilterAmbTypes.setOutput(out, locus, locusExons, locusExonResultMajor, locusExonResultMinor, locusExonResultCombine);
                locusExonResultMajor = FilterAmbTypes.getMajorResult(majorFile, "DRB345");
                locusExonResultMinor = FilterAmbTypes.getMinorResult(minorFile, "DRB345");
                locusExonResultCombine = FilterAmbTypes.combineResult(locusExonResultMajor, locusExonResultMinor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2);
                FilterAmbTypes.setOutput(out, locus, locusExons, locusExonResultMajor, locusExonResultMinor, locusExonResultCombine);
                continue;
            }
            locusExonResultMajor = FilterAmbTypes.getMajorResult(majorFile, locus);
            locusExonResultMinor = FilterAmbTypes.getMinorResult(minorFile, locus);
            locusExonResultCombine = FilterAmbTypes.combineResult(locusExonResultMajor, locusExonResultMinor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2);
            FilterAmbTypes.setOutput(out, locus, locusExons, locusExonResultMajor, locusExonResultMinor, locusExonResultCombine);
        }
        FileManager.writeTextFile(outputFile, out.toString(), true);
    }

    private static void setOutput(StringBuilder out, String locus, List<LocusExon> locusExons, Map<String, LocusExonResult> locusExonResultMajor, Map<String, LocusExonResult> locusExonResultMinor, Map<String, LocusExonResult> locusExonResultCombine) {
        for (String name : locusExonResultMajor.keySet()) {
            out.append(name).append("\t");
            out.append(locus).append("\t");
            out.append(locusExons.get(0).getExon()).append("\t");
            out.append(locusExonResultMajor.get(name).getType1()).append("\t");
            out.append(locusExonResultMajor.get(name).getType2()).append("\t");
            out.append(locusExons.get(1).getExon()).append("\t");
            if (locusExonResultMinor.get(name) == null) {
                out.append("?").append("\t");
                out.append("?").append("\t");
            } else {
                out.append(locusExonResultMinor.get(name).getType1()).append("\t");
                out.append(locusExonResultMinor.get(name).getType2()).append("\t");
            }
            out.append(String.valueOf(locusExons.get(0).getExon()) + "+" + locusExons.get(1).getExon()).append("\t");
            out.append(locusExonResultCombine.get(name).getType1() == null ? "?" : locusExonResultCombine.get(name).getType1()).append("\t");
            out.append(locusExonResultCombine.get(name).getType2() == null ? "?" : locusExonResultCombine.get(name).getType2()).append("\t");
            out.append(locusExonResultCombine.get(name).isFirm()).append("\t");
            if (locusExonResultCombine.get(name).getLog() == null) {
                out.append("").append("\n");
                continue;
            }
            out.append(locusExonResultCombine.get(name).getLog()).append("\n");
        }
    }

    private static Map<String, LocusExonResult> combineResult(Map<String, LocusExonResult> locusExonResultMajor, Map<String, LocusExonResult> locusExonResultMinor, File hapTypeFile1, File hapAmbFile1, File hapTypeFile2, File hapAmbFile2) {
        LinkedHashMap<String, LocusExonResult> locusExonResults = new LinkedHashMap<String, LocusExonResult>();
        for (String name : locusExonResultMajor.keySet()) {
            LocusExonResult major = locusExonResultMajor.get(name);
            LocusExonResult minor = null;
            if (locusExonResultMinor.containsKey(name)) {
                minor = locusExonResultMinor.get(name);
            }
            LocusExonResult combined = FilterAmbTypes.generateCombinedResult(major, minor, hapTypeFile1, hapAmbFile1, hapTypeFile2, hapAmbFile2, name);
            locusExonResults.put(name, combined);
        }
        return locusExonResults;
    }

    private static LocusExonResult generateCombinedResult(LocusExonResult major, LocusExonResult minor, File hapTypeFile1, File hapAmbFile1, File hapTypeFile2, File hapAmbFile2, String name) {
        List<String> allMajorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile1);
        List<String> allMinorHapTypes = SummarizeTypingResult.getAllTypes(hapTypeFile2);
        List<String> minorMissingTypes = SummarizeTypingResult.getMissTypes(allMajorHapTypes, allMinorHapTypes);
        Map<String, List<String>> majorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile1);
        Map<String, List<String>> minorAmbTypes = SummarizeTypingResult.getAmbTypes(hapAmbFile2);
        LocusExonResult sampleCombineExonResult = new LocusExonResult();
        String majorType1 = major.getType1();
        String majorType2 = major.getType2();
        String minorType1 = null;
        String minorType2 = null;
        if (minor != null) {
            minorType1 = minor.getType1();
            minorType2 = minor.getType2();
        }
        if (majorType1 == null || majorType2 == null) {
            sampleCombineExonResult.setType1("?");
            sampleCombineExonResult.setType2("?");
            System.out.println("no major result + " + name);
            return sampleCombineExonResult;
        }
        if (majorType1.equals("?") && majorType2.equals("?")) {
            sampleCombineExonResult.setType1("?");
            sampleCombineExonResult.setType2("?");
            return sampleCombineExonResult;
        }
        if (majorType1.equals("") && majorType2.equals("")) {
            sampleCombineExonResult.setType1("");
            sampleCombineExonResult.setType2("");
            return sampleCombineExonResult;
        }
        List<String> majorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(majorType1, majorAmbTypes);
        ArrayList<String> majorHapTypeGroup2 = new ArrayList();
        if (!majorType2.equals("")) {
            majorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(majorType2, majorAmbTypes);
        }
        if (minorType1 != null && minorType2 != null) {
            ArrayList<String> minorHapTypeGroup1 = new ArrayList();
            if (!minorType1.equals("")) {
                minorHapTypeGroup1 = SummarizeTypingResult.getExpandedHapType(minorType1, minorAmbTypes);
            }
            ArrayList<String> minorHapTypeGroup2 = new ArrayList();
            if (!minorType2.equals("")) {
                minorHapTypeGroup2 = SummarizeTypingResult.getExpandedHapType(minorType2, minorAmbTypes);
            }
            boolean common11 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup1);
            boolean common12 = SummarizeTypingResult.checkCommon(majorHapTypeGroup1, minorHapTypeGroup2);
            boolean common21 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup1);
            boolean common22 = SummarizeTypingResult.checkCommon(majorHapTypeGroup2, minorHapTypeGroup2);
            List<String> fileteredName1 = null;
            List<String> fileteredName2 = null;
            boolean isMajorHomo = major.getType1().equals(major.getType2());
            if (common11 && !common12 || common22 && !common21) {
                fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
            } else if (common12 && !common11 || common21 && !common22) {
                fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
            } else if (isMajorHomo) {
                fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup1, minorMissingTypes, sampleCombineExonResult);
                fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup2, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
            } else {
                fileteredName1 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup1, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                fileteredName2 = SummarizeTypingResult.filterWithMinorType(majorHapTypeGroup2, minorHapTypeGroup1, minorHapTypeGroup2, minorMissingTypes, sampleCombineExonResult);
                if (!minor.getType1().equals(minor.getType2())) {
                    SummarizeTypingResult.logForAmbiguities(fileteredName1, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, false);
                    SummarizeTypingResult.logForAmbiguities(fileteredName2, minorHapTypeGroup1, minorHapTypeGroup2, sampleCombineExonResult, false);
                }
            }
            sampleCombineExonResult.setType1(SummarizeTypingResult.format(fileteredName1, majorType1));
            sampleCombineExonResult.setType2(SummarizeTypingResult.format(fileteredName2, majorType2));
            if (sampleCombineExonResult.getType1() != null && sampleCombineExonResult.getType2() != null && sampleCombineExonResult.getType1().equals(sampleCombineExonResult.getType2())) {
                SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, false);
            } else {
                SummarizeTypingResult.logForUnknowns(fileteredName1, minorMissingTypes, sampleCombineExonResult, false);
                SummarizeTypingResult.logForUnknowns(fileteredName2, minorMissingTypes, sampleCombineExonResult, false);
            }
            if (fileteredName1.size() > 0 && fileteredName2.size() > 0) {
                sampleCombineExonResult.setFirm(true);
            }
        } else {
            sampleCombineExonResult.setType1(SummarizeTypingResult.format(majorHapTypeGroup1, majorType1));
            sampleCombineExonResult.setType2(SummarizeTypingResult.format(majorHapTypeGroup2, majorType2));
        }
        return sampleCombineExonResult;
    }

    private static Map<String, LocusExonResult> getMinorResult(File minorFile, String representString) {
        String[] lines = FileManager.readTextFile(minorFile).split("\n");
        LinkedHashMap<String, LocusExonResult> locusExonResults = new LinkedHashMap<String, LocusExonResult>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fields;
            String line = stringArray[n2];
            if (line.trim().length() != 0 && (fields = line.trim().split("\t"))[1].trim().equals(representString)) {
                String name = fields[0].trim();
                LocusExonResult locusExonResult = new LocusExonResult();
                if (fields.length <= 6 || fields[6].trim().length() == 0) {
                    locusExonResult.setType1("");
                } else {
                    locusExonResult.setType1(fields[6].trim());
                }
                if (fields.length <= 7 || fields[7].trim().length() == 0) {
                    locusExonResult.setType2("");
                } else {
                    locusExonResult.setType2(fields[7].trim());
                }
                locusExonResults.put(name, locusExonResult);
            }
            ++n2;
        }
        return locusExonResults;
    }

    private static Map<String, LocusExonResult> getMajorResult(File majorFile, String representString) {
        String[] lines = FileManager.readTextFile(majorFile).split("\n");
        LinkedHashMap<String, LocusExonResult> locusExonResults = new LinkedHashMap<String, LocusExonResult>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] fields;
            String line = stringArray[n2];
            if (line.trim().length() != 0 && (fields = line.trim().split("\t"))[1].trim().equals(representString)) {
                String name = fields[0].trim();
                LocusExonResult locusExonResult = new LocusExonResult();
                locusExonResult.setType1(fields[3].trim());
                if (fields[4].trim().length() == 0) {
                    locusExonResult.setType2("");
                } else {
                    locusExonResult.setType2(fields[4].trim());
                }
                locusExonResults.put(name, locusExonResult);
            }
            ++n2;
        }
        return locusExonResults;
    }
}

