/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import misc.FileManager;
import misc.StringUtils;

public class FakeR2 {
    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        int readlength = new Integer(args[2]);
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith(".fastq")) {
                File newFile = new File(outputDir, FakeR2.generateR2name(file.getName()));
                FakeR2.replaceR2(file, newFile, readlength);
            }
            ++n2;
        }
    }

    private static String generateR2name(String name) {
        return name.replace("R1_001", "R2_001");
    }

    private static void replaceR2(File file, File newFile, int len) {
        StringBuilder newLines = new StringBuilder();
        String[] lines = FileManager.readTextFile(file).split("\n");
        String r1 = null;
        String r2 = null;
        int i = 0;
        while (i < lines.length) {
            String line = lines[i].trim();
            if (line.startsWith("@") && line.length() < len) {
                r1 = lines[i + 1].trim();
                r2 = StringUtils.revCompSeq(r1);
                newLines.append(FakeR2.generateR2header(line)).append("\n");
                newLines.append(r2).append("\n");
                newLines.append("+").append("\n");
                newLines.append(lines[i + 3].trim()).append("\n");
            }
            ++i;
        }
        System.out.println(newFile.getName());
        FileManager.writeTextFile(newFile, newLines.toString(), true);
    }

    private static Object generateR2header(String line) {
        String[] items = line.split("\\s+");
        if (items.length != 2) {
            System.out.println("?? unexpected header line : " + line);
        }
        return String.valueOf(items[0]) + " 2" + items[1].substring(1);
    }
}

