/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ExtractProteinSeq {
    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File padFile = new File(args[2]);
        boolean doPadding = new Boolean(args[3]);
        Map<String, String> pad = ExtractProteinSeq.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().indexOf("-align.txt") >= 0) {
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                String locusName = ExtractProteinSeq.createLocusName(input.getName());
                ExtractProteinSeq.loadAllSequence(input, locusName, seq);
                Map<String, String> translatedSeq = ExtractProteinSeq.translateProteins(seq);
                if (doPadding) {
                    Map<String, String> paddedSeq = ExtractProteinSeq.padUnknown(translatedSeq, pad);
                    ExtractProteinSeq.writeSeqFiles(paddedSeq, outputDir, locusName);
                } else {
                    ExtractProteinSeq.writeSeqFiles(translatedSeq, outputDir, locusName);
                }
            }
            ++n2;
        }
    }

    private static void writeSeqFiles(Map<String, String> seq, File outputDir, String locusName) {
        StringBuilder builder = new StringBuilder();
        File output = new File(outputDir, String.valueOf(locusName) + ".fa");
        for (String name : seq.keySet()) {
            builder.append(">").append(name).append("\n");
            builder.append(seq.get(name)).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Map<String, String> padUnknown(Map<String, String> translatedSeq, Map<String, String> pad) {
        LinkedHashMap<String, String> paddedSeq = new LinkedHashMap<String, String>();
        for (String name : translatedSeq.keySet()) {
            String s = translatedSeq.get(name);
            if (s.indexOf("*") >= 0) {
                String newseq = "";
                String padSeqName = null;
                padSeqName = ExtractProteinSeq.findPaddingName(name, pad);
                if (padSeqName == null) {
                    System.out.println(String.valueOf(name) + " ???  no padding info ");
                }
                System.out.println(String.valueOf(name) + "," + padSeqName);
                String padSeq = translatedSeq.get(padSeqName);
                if (padSeq.indexOf("*") >= 0) {
                    System.out.println(String.valueOf(padSeqName) + " !!!! contains unknown");
                }
                int i = 0;
                while (i < s.length()) {
                    newseq = String.valueOf(newseq) + (s.charAt(i) == '*' ? padSeq.charAt(i) : s.charAt(i));
                    ++i;
                }
                paddedSeq.put(name, newseq);
                continue;
            }
            paddedSeq.put(name, s);
        }
        return paddedSeq;
    }

    private static String findPaddingName(String name, Map<String, String> pad) {
        String[] items = name.split(":");
        String gName = items[0];
        if (!pad.containsKey(gName) && gName.startsWith("DPB1")) {
            gName = "DPB1*allOther";
        }
        return pad.get(gName);
    }

    private static Map<String, String> translateProteins(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (seq.startsWith("-") || seq.startsWith("*")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                if (i >= rawSeq.length()) break;
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static String createLocusName(String name) {
        return name.replace("-align.txt", "");
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0 && (line.trim().startsWith(String.valueOf(header) + "*") || line.trim().startsWith("DRB"))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }
}

