/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConsensusSeq;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import misc.FileManager;

public class ExtractMajorSequence3 {
    static int sizeLimit = 5000;
    static int endCutSize = 500;

    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File assemblyRoot = new File(args[1]);
        File logFile = new File(args[2]);
        File outFile = new File(args[3]);
        int dbNumber = new Integer(args[4]);
        String[] lines = FileManager.readTextFile(input).split("\n");
        StringBuilder out = new StringBuilder();
        StringBuilder log = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() != 0) {
                String[] items = line.trim().split(",");
                File fosmidDir = new File(new File(new File(assemblyRoot, items[3].trim()), "temAssemblies"), items[2].trim());
                System.out.println(items[2].trim());
                String gName = items[0].trim();
                if (!(fosmidDir.exists() && fosmidDir.isDirectory() || (fosmidDir = new File(new File(new File(assemblyRoot, items[3].trim()), "temAssemblies"), "CII_" + items[2].trim())).exists() && fosmidDir.isDirectory())) {
                    System.out.println("skip " + line + " " + fosmidDir.getAbsolutePath());
                } else {
                    ExtractMajorSequence3.parseConsense(fosmidDir, items[2].trim(), line.trim(), log, out, gName, dbNumber);
                    ++dbNumber;
                }
            }
            ++n2;
        }
        FileManager.writeTextFile(logFile, log.toString(), true);
        FileManager.writeTextFile(outFile, out.toString(), true);
    }

    public static int parseConsense(File assemblyTopDir, String name, String line, StringBuilder log, StringBuilder out, String gName, int dbNumber) throws Exception {
        File aceFile = ExtractMajorSequence3.getLatestAceFile(new File(assemblyTopDir, "assembly"));
        if (aceFile == null) {
            System.out.println("assemblyTopDir.getName(), No Ace File");
            log.append(line).append(",").append("No Ace File").append("\n");
            return dbNumber;
        }
        List<ConsensusSeq> consensusSeqs = ExtractMajorSequence3.readAceFile(aceFile);
        if (consensusSeqs.size() == 0) {
            System.out.println(String.valueOf(assemblyTopDir.getName()) + "," + " No Big Contig");
            log.append(line).append(",").append(aceFile.getName()).append(",").append("No Big Contig").append("\n");
            return dbNumber;
        }
        int index = 1;
        for (ConsensusSeq consensusSeq : consensusSeqs) {
            log.append(line).append(",").append(aceFile.getName()).append(",");
            log.append(consensusSeq.getContig()).append(",");
            log.append(consensusSeq.getSequence().getPadded().length() - 2 * endCutSize).append(",");
            log.append(String.valueOf(name) + "_" + dbNumber + "-" + index).append("\n");
            out.append(">").append(String.valueOf(name) + "_" + dbNumber + "-" + index).append("\n");
            out.append(consensusSeq.getSequence().getPadded().substring(endCutSize, consensusSeq.getSequence().getPadded().length() - endCutSize)).append("\n");
            ++index;
        }
        return dbNumber++;
    }

    private static List<ConsensusSeq> readAceFile(File aceFile) {
        ArrayList<ConsensusSeq> sequences = new ArrayList<ConsensusSeq>();
        ArrayList<String> contigs = new ArrayList<String>();
        String[] lines = FileManager.readTextFile(aceFile).split("\n");
        String contig = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.startsWith("CO Contig") && Integer.valueOf((items = line.trim().split("\\s+"))[2]) >= sizeLimit + endCutSize * 2) {
                contig = items[1].trim();
                contigs.add(contig);
            }
            ++n2;
        }
        for (String con : contigs) {
            ConsensusSeq consensusSeq = ExtractMajorSequence3.getContig(lines, con);
            sequences.add(consensusSeq);
        }
        return sequences;
    }

    private static ConsensusSeq getContig(String[] lines, String contig) {
        ConsensusSeq consensusSeq = new ConsensusSeq();
        consensusSeq.setContig(contig);
        StringBuilder seq = new StringBuilder();
        StringBuilder qualSeq = new StringBuilder();
        boolean inParsingBlock = false;
        int i = 0;
        while (i < lines.length) {
            int j;
            if (lines[i].startsWith("CO " + contig + " ") && !inParsingBlock) {
                System.out.println("> " + contig);
                inParsingBlock = true;
                j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("BQ")) {
                        i = j - 1;
                        break;
                    }
                    seq.append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setPadded(seq.toString().replaceAll("\\*", ""));
            } else if (lines[i].trim().startsWith("BQ") && inParsingBlock) {
                j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("AF")) {
                        i = j - 1;
                        break;
                    }
                    qualSeq.append(" ").append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setQual(qualSeq.toString().trim().split("\\s+"));
            } else if (lines[i].startsWith("CO " + contig + " ") && inParsingBlock) break;
            ++i;
        }
        return consensusSeq;
    }

    public static File getLatestAceFile(File assemblyDir) {
        File[] afns = assemblyDir.listFiles();
        int index = 0;
        String name = null;
        File[] fileArray = afns;
        int n = afns.length;
        int n2 = 0;
        while (n2 < n) {
            int thisIndex;
            String[] items;
            File afn = fileArray[n2];
            if (afn.getName().indexOf(".fasta.screen.ace.") > -1 && !afn.getName().startsWith("mini") && (items = afn.getName().split("\\."))[items.length - 1].length() <= 2 && (thisIndex = Integer.valueOf(items[items.length - 1]).intValue()) > index) {
                index = thisIndex;
                name = items[0];
            }
            ++n2;
        }
        if (index == 0) {
            return null;
        }
        File lastestAce = new File(assemblyDir, String.valueOf(name) + ".fasta.screen.ace." + index);
        return lastestAce;
    }
}

