/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import misc.FileManager;

public class ExtractFullGenomicSeq {
    public static void main(String[] args) throws Exception {
        File[] files;
        File inputDir = new File(args[0]);
        File outputDir = new File(args[1]);
        File padFile = new File(args[2]);
        boolean doPadding = new Boolean(args[3]);
        Map<String, String> pad = ExtractFullGenomicSeq.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        File[] fileArray = files = inputDir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File input = fileArray[n2];
            if (input.getName().indexOf("_nuc.txt") >= 0) {
                LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
                String locusName = ExtractFullGenomicSeq.createLocusName(input.getName());
                ExtractFullGenomicSeq.loadAllSequence(input, locusName, seq);
                Map<String, String> translatedSeq = ExtractFullGenomicSeq.translateSequences(seq);
                Map<String, String> anchorSeqMap = ExtractFullGenomicSeq.initAnchorSeq();
                if (doPadding) {
                    Map<String, String> paddedSeq = ExtractFullGenomicSeq.padUnknown(translatedSeq, pad, anchorSeqMap, locusName);
                    ExtractFullGenomicSeq.writeSeqFiles(paddedSeq, outputDir, locusName, true);
                } else {
                    ExtractFullGenomicSeq.writeSeqFiles(translatedSeq, outputDir, locusName, false);
                }
            }
            ++n2;
        }
    }

    private static Map<String, String> initAnchorSeq() {
        HashMap<String, String> anchorSeqMap = new HashMap<String, String>();
        anchorSeqMap.put("A", "A*01:01:01:01");
        anchorSeqMap.put("B", "B*07:02:01:01");
        anchorSeqMap.put("C", "C*01:02:01:01");
        anchorSeqMap.put("DPA1", "DPA1*01:03:01:01");
        anchorSeqMap.put("DPB1", "DPB1*01:01:01:01");
        anchorSeqMap.put("DQA1", "DQA1*01:01:01:01");
        anchorSeqMap.put("DQB1", "DQB1*05:01:01:01");
        anchorSeqMap.put("DRB", "DRB1*01:01:01");
        return anchorSeqMap;
    }

    private static void writeSeqFiles(Map<String, String> seq, File outputDir, String locusName, boolean doReplace) {
        StringBuilder builder = new StringBuilder();
        File output = new File(outputDir, String.valueOf(locusName) + ".fa");
        for (String name : seq.keySet()) {
            String sequence;
            builder.append(">").append(name).append("\n");
            if (doReplace) {
                sequence = seq.get(name).replaceAll("\\|", "");
                builder.append(sequence.replaceAll("\\.", "")).append("\n");
                continue;
            }
            sequence = seq.get(name).replaceAll("\\|", "");
            builder.append(sequence).append("\n");
        }
        FileManager.writeTextFile(output, builder.toString(), true);
    }

    private static Map<String, String> padUnknown(Map<String, String> translatedSeq, Map<String, String> pad, Map<String, String> anchorSeqMap, String locusName) {
        LinkedHashMap<String, String> paddedSeq = new LinkedHashMap<String, String>();
        for (String name : translatedSeq.keySet()) {
            String s = translatedSeq.get(name);
            if (s.indexOf("*") >= 0) {
                String newseq = "";
                Map<String, String> padSeqs = ExtractFullGenomicSeq.findGroupPaddingName(name, translatedSeq, pad);
                if (padSeqs.size() == 0) {
                    System.out.println(String.valueOf(name) + " ???  no padding info ");
                } else {
                    System.out.println(String.valueOf(name) + " padding with " + padSeqs.keySet().toString());
                }
                String anchorSeq = translatedSeq.get(anchorSeqMap.get(locusName));
                int i = 0;
                while (i < s.length()) {
                    char c = s.charAt(i);
                    if (c == '*') {
                        char padChar;
                        c = padChar = ExtractFullGenomicSeq.getPadChar(i, padSeqs, anchorSeq);
                    }
                    newseq = String.valueOf(newseq) + c;
                    ++i;
                }
                paddedSeq.put(name, newseq);
                continue;
            }
            paddedSeq.put(name, s);
        }
        return paddedSeq;
    }

    private static char getPadChar(int i, Map<String, String> padSeqs, String anchorSeq) {
        for (String seq : padSeqs.values()) {
            if (seq.charAt(i) == '*') continue;
            return seq.charAt(i);
        }
        return anchorSeq.charAt(i);
    }

    private static Map<String, String> findGroupPaddingName(String name, Map<String, String> translatedSeq, Map<String, String> pad) {
        String[] items;
        LinkedHashMap<String, String> ret = new LinkedHashMap<String, String>();
        String gName = ExtractFullGenomicSeq.findPaddingName(name, pad);
        if (!translatedSeq.containsKey(gName)) {
            gName = String.valueOf(gName) + ":01";
        }
        if ((items = name.split(":")).length < 4) {
            ret.put(gName, translatedSeq.get(gName));
            return ret;
        }
        String basedName = name.substring(0, name.length() - items[3].length());
        for (String type : translatedSeq.keySet()) {
            if (type.equals(name) || type.indexOf(basedName) != 0) continue;
            ret.put(type, translatedSeq.get(type));
        }
        if (!ret.containsKey(gName)) {
            ret.put(gName, translatedSeq.get(gName));
        }
        return ret;
    }

    private static String findPaddingName(String name, Map<String, String> pad) {
        String[] items = name.split(":");
        String gName = items[0];
        return pad.get(gName);
    }

    private static Map<String, String> translateSequences(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (seq.startsWith("-") || seq.startsWith("*")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                if (i >= rawSeq.length()) break;
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((header.length() != 1 || line.trim().length() != 0 && line.trim().startsWith(String.valueOf(header) + "*")) && (header.length() != 4 || line.trim().length() != 0 && line.trim().startsWith(String.valueOf(header) + "*")) && (header.length() != 3 || line.trim().length() != 0 && line.trim().startsWith(header)) && (header.length() != 3 || line.trim().length() != 0 && !line.trim().startsWith("DRB2") && !line.trim().startsWith("DRB6") && !line.trim().startsWith("DRB7") && !line.trim().startsWith("DRB8") && !line.trim().startsWith("DRB9"))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }

    private static String createLocusName(String name) {
        return name.replace("_gen.txt", "").toUpperCase();
    }
}

