/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class ExtractFastaAllExon {
    public static void main(String[] args) throws Exception {
        File input = new File(args[0]);
        File outputDir = new File(args[1]);
        String header = args[2];
        File padFile = new File(args[3]);
        LinkedHashMap<String, String> seq = new LinkedHashMap<String, String>();
        Map<String, String> pad = ExtractFastaAllExon.getPadInfo(FileManager.readTextFile(padFile).split("\n"));
        ExtractFastaAllExon.loadAllSequence(input, header, seq);
        Map<String, String> actualSeq = ExtractFastaAllExon.translateExons(seq);
        ExtractFastaAllExon.writeSeqFiles(actualSeq, outputDir, pad, header);
    }

    private static void writeSeqFiles(Map<String, String> actualSeqs, File outputDir, Map<String, String> pad, String header) {
        String headerSeq = "";
        for (String type : actualSeqs.keySet()) {
            String seq = actualSeqs.get(type);
            if (!seq.startsWith("A") && !seq.startsWith("C") && !seq.startsWith("T") && !seq.startsWith("G")) continue;
            headerSeq = seq;
            break;
        }
        int exonCount = headerSeq.split("\\|").length;
        int exonNumber = 0;
        while (exonNumber < exonCount) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            ExtractFastaAllExon.writeExonFastaFile(actualSeqs, outputDir, pad, header, exonNumber, map);
            ++exonNumber;
        }
    }

    private static void writeExonAmbFile(File outputDir, String header, int exonNumber, Map<String, String> map) {
        File exonAmbFa = new File(outputDir, String.valueOf(header) + "-exon" + (exonNumber + 1) + "-hap-amb.txt");
        LinkedHashMap seqMap = new LinkedHashMap();
        StringBuilder ambBuilder = new StringBuilder();
        for (String name : map.keySet()) {
            String seq = map.get(name);
            if (!seqMap.containsKey(seq)) {
                seqMap.put(seq, new ArrayList());
            }
            ((List)seqMap.get(seq)).add(name);
        }
        for (List names : seqMap.values()) {
            if (names.size() <= 1) continue;
            ambBuilder.append(String.valueOf((String)names.get(0)) + "R\t");
            for (String name : names) {
                ambBuilder.append(name);
                ambBuilder.append("\t");
            }
            ambBuilder.append("\n");
        }
        FileManager.writeTextFile(exonAmbFa, ambBuilder.toString(), true);
    }

    public static void writeExonFastaFile(Map<String, String> actualSeqs, File outputDir, Map<String, String> pad, String header, int exonNumber, Map<String, String> map) {
        File exonFa = new File(outputDir, String.valueOf(header) + "-exon" + (exonNumber + 1) + ".fa");
        StringBuilder builder = new StringBuilder();
        System.out.println("----- contains N in exon" + (exonNumber + 1));
        for (String name : actualSeqs.keySet()) {
            String s;
            if (actualSeqs.get(name).split("\\|").length <= exonNumber) {
                System.out.println(String.valueOf(name) + " not exist exon " + exonNumber);
                System.out.println(actualSeqs.get(name));
            }
            if (ExtractFastaAllExon.allN(s = actualSeqs.get(name).split("\\|")[exonNumber].replaceAll("\\.", "").replaceAll("\\*", "N")) || ExtractFastaAllExon.mostlyN(s)) continue;
            builder.append(">").append(name).append("\n");
            if (s.indexOf("N") >= 0) {
                if (pad.containsKey(name)) {
                    s = actualSeqs.get(name).split("\\|")[exonNumber].replaceAll("\\*", "N");
                    String newseq = "";
                    if (actualSeqs.get(pad.get(name)) == null) {
                        System.out.println(String.valueOf(pad.get(name)) + " not exist ");
                    }
                    String padSeq = actualSeqs.get(pad.get(name)).split("\\|")[exonNumber].replaceAll("\\*", "N");
                    int i = 0;
                    while (i < s.length()) {
                        if (s.charAt(i) == 'N' && padSeq.charAt(i) == 'N') {
                            System.out.println(padSeq);
                            System.out.println(s);
                            System.out.println(String.valueOf(name) + " pad contains N in exon " + (exonNumber + 1));
                        }
                        newseq = String.valueOf(newseq) + (s.charAt(i) == 'N' ? padSeq.charAt(i) : s.charAt(i));
                        ++i;
                    }
                    builder.append(newseq.replaceAll("\\.", "")).append("\n");
                    map.put(name, newseq.replaceAll("\\.", ""));
                } else {
                    System.out.println(name);
                    builder.append(s).append("\n");
                    map.put(name, s);
                }
            } else {
                builder.append(s).append("\n");
                map.put(name, s);
            }
            if (map.get(name).indexOf("N") < 0) continue;
            builder.append(s).append("\n");
        }
        FileManager.writeTextFile(exonFa, builder.toString(), true);
    }

    private static boolean allN(String s) {
        return s.replaceAll("N", "").length() == 0;
    }

    private static boolean mostlyN(String s) {
        int len = s.length();
        return (double)s.replaceAll("N", "").length() <= 0.25 * (double)len;
    }

    private static Map<String, String> translateExons(Map<String, String> seqs) {
        LinkedHashMap<String, String> actualSeq = new LinkedHashMap<String, String>();
        String headerSeq = "";
        String anchorType = "";
        for (String type : seqs.keySet()) {
            String seq = seqs.get(type);
            if (!seq.startsWith("A") && !seq.startsWith("C") && !seq.startsWith("T") && !seq.startsWith("G")) continue;
            headerSeq = seq;
            anchorType = type;
            break;
        }
        for (String type : seqs.keySet()) {
            if (type.equals(anchorType)) {
                actualSeq.put(type, headerSeq);
                continue;
            }
            String rawSeq = seqs.get(type);
            String translatedSeq = "";
            int i = 0;
            while (i < headerSeq.length()) {
                translatedSeq = rawSeq.charAt(i) == '-' ? String.valueOf(translatedSeq) + headerSeq.charAt(i) : String.valueOf(translatedSeq) + rawSeq.charAt(i);
                ++i;
            }
            actualSeq.put(type, translatedSeq);
        }
        return actualSeq;
    }

    private static void loadAllSequence(File input, String header, Map<String, String> seq) {
        String[] data;
        String[] stringArray = data = FileManager.readTextFile(input).split("\n");
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (!(!header.equals("DRB") ? line.trim().length() == 0 || !line.trim().startsWith(String.valueOf(header) + "*") : line.trim().length() == 0 || !line.trim().startsWith(header))) {
                String[] info = line.trim().split("\\s+");
                String name = info[0].trim();
                if (!seq.containsKey(name)) {
                    seq.put(name, "");
                }
                String thisSeq = seq.get(name);
                int i = 1;
                while (i < info.length) {
                    thisSeq = String.valueOf(thisSeq) + info[i].trim();
                    ++i;
                }
                seq.put(name, thisSeq);
            }
            ++n2;
        }
    }

    private static Map<String, String> getPadInfo(String[] data) {
        LinkedHashMap<String, String> pad = new LinkedHashMap<String, String>();
        String[] stringArray = data;
        int n = data.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split("\\s+");
            pad.put(items[0].trim(), items[1].trim());
            ++n2;
        }
        return pad;
    }
}

