/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConsensusSeq;
import java.io.File;
import misc.FileManager;
import misc.SystemCommand;

public class ExtractContigSeq {
    public static void main(String[] args) throws Exception {
        File assemblyTopDir = new File(args[0]);
        File seqFile = new File(args[1]);
        File logFile = new File(args[2]);
        StringBuilder seqOut = new StringBuilder();
        StringBuilder logOut = new StringBuilder();
        logOut.append("index").append(",").append("Alleles").append(",").append("Flanking").append(",").append("ReportAllele").append("\n");
    }

    public static void parseConsense(File assemblyTopDir, File newAssemblyDir, String name) throws Exception {
        File phdDir = new File(newAssemblyDir, "phd_dir");
        File fastaDir = new File(newAssemblyDir, "fasta");
        File aceFile = ExtractContigSeq.getLatestAceFile(new File(assemblyTopDir, "assembly"));
        if (aceFile == null) {
            System.out.println("assemblyTopDir.getName(), No Ace File");
        }
        ConsensusSeq consensusSeq = ExtractContigSeq.readAceFile(aceFile);
        System.out.println(String.valueOf(assemblyTopDir.getName()) + " " + consensusSeq.getSequence().getPadded().length() + " " + consensusSeq.getReadSequences().size());
        ExtractContigSeq.writeSeq(consensusSeq, fastaDir, name);
        ExtractContigSeq.writePhd(consensusSeq, phdDir, name);
    }

    private static void writeSeq(ConsensusSeq consensusSeq, File fastaDir, String name) {
        if (!fastaDir.exists() || !fastaDir.isDirectory()) {
            fastaDir.mkdirs();
        }
        StringBuilder seqOut = new StringBuilder();
        seqOut.append(">").append(name).append("\n");
        seqOut.append(consensusSeq.getSequence().getPadded()).append("\n");
        FileManager.writeTextFile(new File(fastaDir, String.valueOf(name) + ".fa"), seqOut.toString(), true);
    }

    private static void writePhd(ConsensusSeq consensusSeq, File phdDir, String name) throws Exception {
        if (!phdDir.exists() || !phdDir.isDirectory()) {
            phdDir.mkdirs();
        }
        ExtractContigSeq.writePhdFile(phdDir, name, consensusSeq.getSequence().getPadded(), consensusSeq.getSequence().getQual());
    }

    public static int writePhdFile(File phdDir, String name, String sequence, String[] qualityChars) throws Exception {
        if (sequence.length() != qualityChars.length) {
            System.out.println("diff");
            System.out.println(String.valueOf(name) + " " + sequence.length() + " " + qualityChars.length);
        }
        File tmpFile = File.createTempFile("chromat", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(name).append("\n");
        builder.append(sequence);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        SystemCommand command = new SystemCommand("/usr/bin/perl /genome/bin/fasta2Phd.perl " + tmpFile.getAbsolutePath(), phdDir, false);
        command.makeItSo();
        File phdFile = new File(phdDir, String.valueOf(tmpFile.getName()) + ".phd.1");
        int beginDNA = 0;
        int endDNA = 0;
        StringBuilder out = new StringBuilder();
        String[] data = FileManager.readTextFile(phdFile).split("\n");
        int i = 0;
        while (i < data.length) {
            if (data[i].indexOf("BEGIN_DNA") >= 0) {
                beginDNA = i;
            }
            if (data[i].indexOf("END_DNA") >= 0) {
                endDNA = i;
            }
            ++i;
        }
        out.append("BEGIN_SEQUENCE " + name);
        i = 1;
        while (i <= beginDNA) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        i = beginDNA + 1;
        while (i < endDNA) {
            String[] info = data[i].trim().split("\\s+");
            out.append(info[0]).append(" ");
            String quality = qualityChars[i - beginDNA - 1];
            out.append(quality).append(" ");
            out.append(info[2]).append("\n");
            ++i;
        }
        i = endDNA;
        while (i < data.length) {
            out.append(data[i].trim()).append("\n");
            ++i;
        }
        FileManager.writeTextFile(phdFile, out.toString(), true);
        phdFile.renameTo(new File(phdDir, String.valueOf(name) + ".phd.1"));
        FileManager.delete(tmpFile);
        return 1;
    }

    private static ConsensusSeq readAceFile(File aceFile) {
        ConsensusSeq consensusSeq = new ConsensusSeq();
        String[] lines = FileManager.readTextFile(aceFile).split("\n");
        int size = 0;
        String contig = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.startsWith("CO Contig") && Integer.valueOf((items = line.trim().split("\\s+"))[2]) >= size) {
                size = Integer.valueOf(items[2]);
                contig = items[1].trim();
            }
            ++n2;
        }
        StringBuilder seq = new StringBuilder();
        StringBuilder qualSeq = new StringBuilder();
        boolean inParsingBlock = false;
        int i = 0;
        while (i < lines.length) {
            if (lines[i].startsWith("CO " + contig + " ") && !inParsingBlock) {
                System.out.println("> " + contig);
                inParsingBlock = true;
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("BQ")) {
                        i = j - 1;
                        break;
                    }
                    seq.append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setPadded(seq.toString().replaceAll("\\*", ""));
            } else if (lines[i].trim().startsWith("BQ") && inParsingBlock) {
                int j = i + 1;
                while (j < lines.length) {
                    if (lines[j].trim().startsWith("AF")) {
                        i = j - 1;
                        break;
                    }
                    qualSeq.append(" ").append(lines[j].trim());
                    ++j;
                }
                consensusSeq.getSequence().setQual(qualSeq.toString().trim().split("\\s+"));
            } else if (lines[i].startsWith("CO " + contig + " ") && inParsingBlock) break;
            ++i;
        }
        return consensusSeq;
    }

    public static File getLatestAceFile(File assemblyDir) {
        File[] afns = assemblyDir.listFiles();
        int index = 0;
        String name = null;
        File[] fileArray = afns;
        int n = afns.length;
        int n2 = 0;
        while (n2 < n) {
            int thisIndex;
            String[] items;
            File afn = fileArray[n2];
            if (afn.getName().indexOf(".fasta.screen.ace.") > -1 && (items = afn.getName().split("\\."))[items.length - 1].length() <= 2 && (thisIndex = Integer.valueOf(items[items.length - 1]).intValue()) > index) {
                index = thisIndex;
                name = items[0];
            }
            ++n2;
        }
        if (index == 0) {
            return null;
        }
        File lastestAce = new File(assemblyDir, String.valueOf(name) + ".fasta.screen.ace." + index);
        return lastestAce;
    }
}

