/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.CheckConsense;
import fileOperation.ConvertFastaQdataSelect;
import fileOperation.MergeAceFile;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import misc.OsHelper;

public class ExtendContig {
    public static void main(String[] args) throws Exception {
        File queryFile = new File(args[0]);
        File fastaFile = new File(args[1]);
        File fastaqFile = new File(args[2]);
        File mainFosmidDir = new File(args[3]);
        File vectorfn = new File(args[4]);
        String cmd = "/genome/bin/cross_match -minscore 35 -masklevel 101 " + queryFile.getAbsolutePath() + " " + fastaFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        int threshHold = ExtendContig.parseResult(data);
        if (threshHold == 0) {
            System.out.println("no reads qualify");
            return;
        }
        cmd = "/genome/bin/cross_match -masklevel 101 -minscore " + threshHold + " " + queryFile.getAbsolutePath() + " " + fastaFile.getAbsolutePath();
        data = OsHelper.excuteCommand(cmd);
        File outputRoot = new File(mainFosmidDir, "temp");
        File existPhdDir = new File(mainFosmidDir, "phd_dir");
        ConvertFastaQdataSelect.process(fastaqFile, outputRoot, data, existPhdDir, vectorfn, true);
        File smallFile = new File(outputRoot, "assembly/temp.fasta.screen.ace.1");
        if (!smallFile.exists()) {
            System.out.println("temp assembly not exist");
            return;
        }
        File mainFile = CheckConsense.getLatestAceFile(new File(mainFosmidDir, "assembly"));
        System.out.println("add to latest ace " + mainFile.getAbsolutePath());
        MergeAceFile.merge(mainFile, smallFile);
    }

    private static int parseResult(String crossmatchout) {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String[] result = crossmatchout.split("\n");
        boolean in = false;
        String[] stringArray = result;
        int n = result.length;
        int n2 = 0;
        while (n2 < n) {
            String[] data;
            String line = stringArray[n2];
            if (line.trim().startsWith("Maximal single base matches") && !in) {
                in = true;
            }
            if (line.trim().indexOf("matching entries") > 0) break;
            if (in && (data = line.trim().split("\\s+")).length >= 12) {
                int score = Integer.valueOf(data[0].trim());
                if (!map.containsKey(score)) {
                    map.put(score, 0);
                }
                map.put(score, (Integer)map.get(score) + 1);
            }
            ++n2;
        }
        Object[] num = map.keySet().toArray();
        Arrays.sort(num);
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if ((Integer)map.get(c) >= 5) {
                System.out.println("optimum score " + c + " count=" + map.get(c));
                return c;
            }
            --i;
        }
        return 0;
    }
}

