/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import misc.FileManager;

public class DemultiplexOne {
    public static void main(String[] args) throws Exception {
        File read1File = new File(args[0]);
        File read2File = new File(args[1]);
        File barcodeFile = new File(args[2]);
        File outputDir = new File(args[3]);
        boolean withLimit = new Boolean(args[4]);
        int limit = 100;
        int noMatchCount = 0;
        boolean noMatchCountB1 = false;
        boolean noMatchCountB2 = false;
        Map<String, String> barcodeMap = DemultiplexOne.initBarcodeMap(barcodeFile);
        Map<String, Integer> barcodeCount = DemultiplexOne.initBarcodeCount(barcodeMap);
        int barcodeLen = 0;
        Iterator<String> iterator = barcodeMap.keySet().iterator();
        if (iterator.hasNext()) {
            String code = iterator.next();
            barcodeLen = code.length();
        }
        BufferedReader read1Reader = new BufferedReader(new FileReader(read1File));
        BufferedReader read2Reader = new BufferedReader(new FileReader(read2File));
        try {
            String line2;
            String line1;
            String name1 = null;
            String name2 = null;
            String sequence1 = null;
            String sequence2 = null;
            String qualityChars1 = null;
            String qualityChars2 = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            String header = null;
            HashMap<String, Integer> noMatchBarcode = new HashMap<String, Integer>();
            while ((line1 = read1Reader.readLine()) != null && (line2 = read2Reader.readLine()) != null) {
                if (++lineCount == 1) {
                    header = line1.split(":")[0];
                    System.out.println("detect header : " + header);
                }
                if (line1.startsWith(header) && line2.startsWith(header)) {
                    name1 = line1.trim().split("\\s+")[0];
                    name2 = line2.trim().split("\\s+")[0];
                    isSeq = true;
                } else if (line1.startsWith("+") && line1.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence1 = line1.trim();
                    sequence2 = line2.trim();
                } else {
                    qualityChars1 = line1.trim();
                    qualityChars2 = line2.trim();
                }
                if (sequence1 != null && qualityChars1 != null) {
                    String barcode1 = sequence1.substring(sequence1.length() - barcodeLen, sequence1.length());
                    if (barcodeMap.keySet().contains(barcode1)) {
                        DemultiplexOne.appendToFile(sequence1.substring(0, sequence1.length() - barcodeLen), qualityChars1.substring(0, sequence1.length() - barcodeLen), name1, outputDir, barcodeMap.get(barcode1));
                        DemultiplexOne.appendToFile(sequence2.trim(), qualityChars2.trim(), name2, outputDir, barcodeMap.get(barcode1));
                        barcodeCount.put(barcode1, barcodeCount.get(barcode1) + 1);
                    } else {
                        if (withLimit) {
                            System.out.println("no " + barcode1);
                        }
                        if (!noMatchBarcode.containsKey(barcode1)) {
                            noMatchBarcode.put(barcode1, 0);
                        }
                        noMatchBarcode.put(barcode1, (Integer)noMatchBarcode.get(barcode1) + 1);
                        ++noMatchCount;
                    }
                    ++count;
                    sequence1 = null;
                    sequence2 = null;
                    qualityChars1 = null;
                    qualityChars2 = null;
                    name1 = null;
                    name2 = null;
                }
                if (count > limit && withLimit) break;
            }
            System.out.println("processed read pairs " + lineCount / 4);
            System.out.println("noMatch Count barcode: " + noMatchCount);
            for (String barcode : barcodeCount.keySet()) {
                System.out.println(String.valueOf(barcodeMap.get(barcode)) + " : " + barcode + " : " + barcodeCount.get(barcode));
            }
            System.out.println("noMatch barcode group > 500 count: ");
            for (String b : noMatchBarcode.keySet()) {
                if ((Integer)noMatchBarcode.get(b) <= 500) continue;
                System.out.println(String.valueOf(b) + " : " + noMatchBarcode.get(b));
            }
        }
        finally {
            read1Reader.close();
            read2Reader.close();
        }
    }

    private static Map<String, Integer> initBarcodeCount(Map<String, String> barcodeMap) {
        HashMap<String, Integer> barcodeCount = new HashMap<String, Integer>();
        for (String barcode : barcodeMap.keySet()) {
            barcodeCount.put(barcode, 0);
        }
        return barcodeCount;
    }

    private static void appendToFile(String sequence, String quality, String readName, File outputDir, String name) throws Exception {
        File targetFile = new File(outputDir, String.valueOf(name) + ".fq");
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(readName.trim());
        writer.write("\n");
        writer.write(sequence.trim());
        writer.write("\n");
        writer.write("+");
        writer.write("\n");
        writer.write(quality.trim());
        writer.write("\n");
        writer.close();
    }

    private static void jumpLines(BufferedReader readReader, int step) throws Exception {
        int i = 0;
        while (i < step) {
            readReader.readLine();
            ++i;
        }
    }

    private static Map<String, String> initBarcodeMap(File barcodeFile) {
        String[] lines;
        HashMap<String, String> barcodeCount = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(barcodeFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split(",");
            String barcode = items[0].trim();
            String name = items[1].trim();
            barcodeCount.put(barcode, name);
            ++n2;
        }
        System.out.println(String.valueOf(barcodeCount.size()) + " total barcodes");
        return barcodeCount;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(DemultiplexOne.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

