/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;

public class DemultiplexBoth2 {
    public static void main(String[] args) throws Exception {
        File read1File = new File(args[0]);
        File read2File = new File(args[1]);
        File barcodeFile = new File(args[2]);
        File outputDir = new File(args[3]);
        boolean withLimit = new Boolean(args[4]);
        int readLength = new Integer(args[5]);
        int barcodeLength = new Integer(args[6]);
        int limit = 200;
        int noMatchCount = 0;
        int noMatchCountB1 = 0;
        int noMatchCountB2 = 0;
        ArrayList<String> allBarcode1 = new ArrayList<String>();
        ArrayList<String> allBarcode2 = new ArrayList<String>();
        Map<String, String> barcodeMap = DemultiplexBoth2.initBarcodeMap(barcodeFile, allBarcode1, allBarcode2);
        Map<String, Integer> barcodeCount = DemultiplexBoth2.initBarcodeCount(barcodeMap);
        HashMap<String, Integer> unknownBarcodeCount = new HashMap<String, Integer>();
        BufferedReader read1Reader = new BufferedReader(new FileReader(read1File));
        BufferedReader read2Reader = new BufferedReader(new FileReader(read2File));
        try {
            String line2;
            String line1;
            String name1 = null;
            String name2 = null;
            String sequence1 = null;
            String sequence2 = null;
            String qualityChars1 = null;
            String qualityChars2 = null;
            boolean isSeq = false;
            int count = 0;
            int lineCount = 0;
            String header = null;
            while ((line1 = read1Reader.readLine()) != null && (line2 = read2Reader.readLine()) != null) {
                if (++lineCount == 1) {
                    header = line1.split(":")[0];
                    System.out.println("detect header : " + header);
                }
                if (line1.startsWith(header) && line2.startsWith(header)) {
                    name1 = line1.trim().split("\\s+")[0];
                    name2 = line2.trim().split("\\s+")[0];
                    isSeq = true;
                } else if (line1.startsWith("+") && line1.trim().length() == 1) {
                    isSeq = false;
                } else if (isSeq) {
                    sequence1 = line1.trim();
                    sequence2 = line2.trim();
                } else {
                    qualityChars1 = line1.trim();
                    qualityChars2 = line2.trim();
                }
                if (sequence1 != null && qualityChars1 != null) {
                    String barcode1 = sequence1.substring(readLength, readLength + barcodeLength);
                    String barcode2 = sequence1.substring(readLength + barcodeLength, readLength + barcodeLength * 2);
                    if (barcodeMap.keySet().contains(String.valueOf(barcode1) + barcode2)) {
                        DemultiplexBoth2.appendToFile(sequence1.substring(0, readLength), qualityChars1.substring(0, readLength), name1, outputDir, barcodeMap.get(String.valueOf(barcode1) + barcode2));
                        DemultiplexBoth2.appendToFile(sequence2, qualityChars2, name2, outputDir, barcodeMap.get(String.valueOf(barcode1) + barcode2));
                        barcodeCount.put(String.valueOf(barcode1) + barcode2, barcodeCount.get(String.valueOf(barcode1) + barcode2) + 1);
                    } else {
                        if (!allBarcode1.contains(barcode1)) {
                            ++noMatchCountB1;
                            if (withLimit) {
                                System.out.println("no " + barcode1 + " noMatchCountB1=" + noMatchCountB1);
                            }
                        }
                        if (!allBarcode2.contains(barcode2)) {
                            ++noMatchCountB2;
                            if (withLimit) {
                                System.out.println("no " + barcode2 + " noMatchCountB2=" + noMatchCountB2);
                            }
                        }
                        if (allBarcode1.contains(barcode1) && allBarcode2.contains(barcode2)) {
                            if (!unknownBarcodeCount.containsKey(String.valueOf(barcode1) + barcode2)) {
                                unknownBarcodeCount.put(String.valueOf(barcode1) + barcode2, 0);
                            }
                            unknownBarcodeCount.put(String.valueOf(barcode1) + barcode2, (Integer)unknownBarcodeCount.get(String.valueOf(barcode1) + barcode2) + 1);
                        }
                        ++noMatchCount;
                        if (withLimit) {
                            System.out.println("no combo noMatchCount=" + noMatchCount);
                        }
                    }
                    ++count;
                    sequence1 = null;
                    sequence2 = null;
                    qualityChars1 = null;
                    qualityChars2 = null;
                    name1 = null;
                    name2 = null;
                }
                if (count > limit && withLimit) break;
            }
            System.out.println("processed barcodes " + lineCount / 4);
            System.out.println("noMatch Count combined barcode: " + noMatchCount + "(" + DemultiplexBoth2.roundTwoDecimals(new Double(noMatchCount) / new Double(lineCount / 4)) + ")");
            System.out.println("noMatch Count barcode1: " + noMatchCountB1);
            System.out.println("noMatch Count barcode2: " + noMatchCountB2);
            System.out.println("both barcode exist but combination not expected (>=200): ");
            for (String barcode : unknownBarcodeCount.keySet()) {
                if ((Integer)unknownBarcodeCount.get(barcode) < 200) continue;
                System.out.println(unknownBarcodeCount.get(barcode) + " : " + barcode + " : " + unknownBarcodeCount.get(barcode));
            }
            for (String barcode : barcodeCount.keySet()) {
                System.out.println(String.valueOf(barcodeMap.get(barcode)) + " : " + barcode + " : " + barcodeCount.get(barcode));
            }
        }
        finally {
            read1Reader.close();
            read2Reader.close();
        }
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }

    private static Map<String, Integer> initBarcodeCount(Map<String, String> barcodeMap) {
        HashMap<String, Integer> barcodeCount = new HashMap<String, Integer>();
        for (String barcode : barcodeMap.keySet()) {
            barcodeCount.put(barcode, 0);
        }
        return barcodeCount;
    }

    private static void appendToFile(String sequence, String quality, String readName, File outputDir, String name) throws Exception {
        File targetFile = new File(outputDir, String.valueOf(name) + ".fq");
        BufferedWriter writer = new BufferedWriter(new FileWriter(targetFile, true));
        writer.write(readName.trim());
        writer.write("\n");
        writer.write(sequence.trim());
        writer.write("\n");
        writer.write("+");
        writer.write("\n");
        writer.write(quality.trim());
        writer.write("\n");
        writer.close();
    }

    private static void jumpLines(BufferedReader readReader, int step) throws Exception {
        int i = 0;
        while (i < step) {
            readReader.readLine();
            ++i;
        }
    }

    private static Map<String, String> initBarcodeMap(File barcodeFile, List<String> allBarcode1, List<String> allBarcode2) {
        String[] lines;
        HashMap<String, String> barcodeCount = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(barcodeFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.trim().length() == 0) break;
            String[] items = line.trim().split(",");
            String barcode1 = items[0].trim();
            String barcode2 = items[1].trim();
            String name = items[2].trim();
            if (barcodeCount.containsKey(String.valueOf(barcode1) + barcode2)) {
                System.out.println("duplicated index " + barcode1 + " + " + barcode2);
            }
            barcodeCount.put(String.valueOf(barcode1) + barcode2, name);
            if (!allBarcode1.contains(barcode1)) {
                allBarcode1.add(barcode1);
            }
            if (!allBarcode2.contains(barcode2)) {
                allBarcode2.add(barcode2);
            }
            ++n2;
        }
        System.out.println(String.valueOf(barcodeCount.size()) + " total barcodes");
        System.out.println(String.valueOf(allBarcode1.size()) + " total barcodes1");
        System.out.println(String.valueOf(allBarcode2.size()) + " total barcodes2");
        return barcodeCount;
    }

    private static String revComp(String seq) {
        StringBuilder builder = new StringBuilder();
        int i = seq.length() - 1;
        while (i >= 0) {
            builder.append(DemultiplexBoth2.complement(seq.charAt(i)));
            --i;
        }
        return builder.toString();
    }

    public static char complement(char base) {
        if (base == 'a' || base == 'A') {
            return 'T';
        }
        if (base == 't' || base == 'T') {
            return 'A';
        }
        if (base == 'c' || base == 'C') {
            return 'G';
        }
        if (base == 'g' || base == 'G') {
            return 'C';
        }
        if (base == 'n' || base == 'N') {
            return 'N';
        }
        return base;
    }
}

