/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class CrossmatchForQC {
    private static final int MIN_HIT = 10;
    private static final double TOTAL = 10000.0;
    static int MIN_SCORE = 50;
    static String LABEL = "M00116";

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapFile = new File(args[1]);
        CrossmatchForQC.startQC(fastaFile, hapFile);
    }

    public static void startQC(File fastaFile, File hapFile) {
        Map<String, String> types = CrossmatchForQC.getAllTypes(hapFile);
        String matchResult = CrossmatchForQC.runCrossMatch(fastaFile, hapFile);
        Map<String, Integer> result = CrossmatchForQC.ParseResult(matchResult, types);
        CrossmatchForQC.output(result);
    }

    private static void output(Map<String, Integer> result) {
        Object[] types = result.keySet().toArray();
        Arrays.sort(types);
        double total = 0.0;
        int matchedCount = 0;
        for (String typeName : result.keySet()) {
            double percent = (double)result.get(typeName).intValue() / 10000.0 * 100.0;
            total += percent;
            matchedCount += result.get(typeName).intValue();
            System.out.println(String.valueOf(typeName) + " : " + result.get(typeName) + " " + Math.round(percent) + "%");
        }
        System.out.println("unmatched : " + (10000.0 - (double)matchedCount) + " " + (100L - Math.round(total)) + "%");
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        String[] lines;
        HashMap<String, String> types = new HashMap<String, String>();
        String[] stringArray = lines = FileManager.readTextFile(hapFile).split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                String[] items = line.substring(1).split("\\s+");
                if (items.length == 1) {
                    types.put(items[0], items[0]);
                } else {
                    types.put(items[0], items[1]);
                }
            }
            ++n2;
        }
        return types;
    }

    private static Map<String, Integer> ParseResult(String matchResult, Map<String, String> types) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && Integer.valueOf((items = line.trim().split("\\s+"))[0]) > MIN_SCORE) {
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String type = isRevComp ? items[9].trim() : items[8].trim();
                String typeName = types.get(type);
                if (typeName.startsWith("DRB1")) {
                    typeName = "DRB1";
                } else if (typeName.startsWith("DRB3")) {
                    typeName = "DRB3";
                } else if (typeName.startsWith("DRB4")) {
                    typeName = "DRB4";
                } else if (typeName.startsWith("DRB5")) {
                    typeName = "DRB5";
                }
                if (!result.containsKey(typeName)) {
                    result.put(typeName, 0);
                }
                result.put(typeName, (Integer)result.get(typeName) + 1);
            }
            ++n2;
        }
        return result;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String[] items;
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12 && (items = line.trim().split("\\s+"))[1].equals("0.00") && items[2].equals("0.00") && items[3].equals("0.00")) {
                OneMatch aMatch;
                Map matches;
                String type;
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match -minmatch 25 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }
}

