/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;

public class CrossMatchHapTypeForQC {
    private static final int MIN_HIT = 10;
    static int MIN_GOOD_SIZE = 80;
    static double MIN_MISMATCH = 2.0;
    static int SMALL_SIZE = 50;
    static double BIG_MISMATCH = 5.0;
    static String LABEL = "M00116";
    static int TOTAL = 10000;

    public static void main(String[] args) throws Exception {
        File fastaFile = new File(args[0]);
        File hapTypeF = new File(args[1]);
        CrossMatchHapTypeForQC.startQC(fastaFile, hapTypeF);
    }

    public static void startQC(File fastaFile, File hapType) {
        String matchResult = CrossMatchHapTypeForQC.runCrossMatch(fastaFile, hapType);
        Map<String, Map<String, OneMatch>> result = CrossMatchHapTypeForQC.ParseResult(matchResult);
        CrossMatchHapTypeForQC.output(result, hapType);
    }

    private static void output(Map<String, Map<String, OneMatch>> result, File hapFile) {
        int matchCount = 0;
        int dpaCount = 0;
        int dpbCount = 0;
        int dqbCount = 0;
        int dpaGoodCount = 0;
        int dpaBadCount = 0;
        int dpbGoodCount = 0;
        int dpbBadCount = 0;
        int dqbGoodCount = 0;
        int dqbBadCount = 0;
        Map<String, String> types = CrossMatchHapTypeForQC.getAllTypes(hapFile);
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            for (OneMatch match : matches.values()) {
                if (match.isForwardExist()) {
                    ++matchCount;
                    if (types.get(type).startsWith("DPA1")) {
                        ++dpaCount;
                        if (match.getForwardMatchSize() >= MIN_GOOD_SIZE && match.getForwardMisMatch() <= MIN_MISMATCH) {
                            ++dpaGoodCount;
                        } else if (match.getForwardMatchSize() < SMALL_SIZE || match.getForwardMisMatch() > BIG_MISMATCH) {
                            ++dpaBadCount;
                        }
                    } else if (types.get(type).startsWith("DPB1")) {
                        ++dpbCount;
                        if (match.getForwardMatchSize() >= MIN_GOOD_SIZE && match.getForwardMisMatch() <= MIN_MISMATCH) {
                            ++dpbGoodCount;
                        } else if (match.getForwardMatchSize() < SMALL_SIZE || match.getForwardMisMatch() > BIG_MISMATCH) {
                            ++dpbBadCount;
                        }
                    } else if (types.get(type).startsWith("DQB1")) {
                        ++dqbCount;
                        if (match.getForwardMatchSize() >= MIN_GOOD_SIZE && match.getForwardMisMatch() <= MIN_MISMATCH) {
                            ++dqbGoodCount;
                        } else if (match.getForwardMatchSize() < SMALL_SIZE || match.getForwardMisMatch() > BIG_MISMATCH) {
                            ++dqbBadCount;
                        }
                    }
                }
                if (!match.isReverseExist()) continue;
                ++matchCount;
                if (types.get(type).startsWith("DPA1")) {
                    ++dpaCount;
                    if (match.getReverseMatchSize() >= MIN_GOOD_SIZE && match.getReverseMisMatch() <= MIN_MISMATCH) {
                        ++dpaGoodCount;
                        continue;
                    }
                    if (match.getReverseMatchSize() >= SMALL_SIZE && !(match.getReverseMisMatch() > BIG_MISMATCH)) continue;
                    ++dpaBadCount;
                    continue;
                }
                if (types.get(type).startsWith("DPB1")) {
                    ++dpbCount;
                    if (match.getReverseMatchSize() >= MIN_GOOD_SIZE && match.getReverseMisMatch() <= MIN_MISMATCH) {
                        ++dpbGoodCount;
                        continue;
                    }
                    if (match.getReverseMatchSize() >= SMALL_SIZE && !(match.getReverseMisMatch() > BIG_MISMATCH)) continue;
                    ++dpbBadCount;
                    continue;
                }
                if (!types.get(type).startsWith("DQB1")) continue;
                ++dqbCount;
                if (match.getReverseMatchSize() >= MIN_GOOD_SIZE && match.getReverseMisMatch() <= MIN_MISMATCH) {
                    ++dqbGoodCount;
                    continue;
                }
                if (match.getReverseMatchSize() >= SMALL_SIZE && !(match.getReverseMisMatch() > BIG_MISMATCH)) continue;
                ++dqbBadCount;
            }
        }
        System.out.println("\tTotal matched to Locus reads count " + matchCount + " out of " + TOTAL);
        System.out.println("\t\tDPA1 total=" + dpaCount + " good reads=" + dpaGoodCount + ", bad reads=" + dpaBadCount);
        System.out.println("\t\tDPB1 total=" + dpbCount + " good reads=" + dpbGoodCount + ", bad reads=" + dpbBadCount);
        System.out.println("\t\tDQB1 total=" + dqbCount + " good reads=" + dqbGoodCount + ", bad reads=" + dqbBadCount);
    }

    private static Map<String, String> getAllTypes(File hapFile) {
        HashMap<String, String> types = new HashMap<String, String>();
        String[] lines = FileManager.readTextFile(hapFile).split("\n");
        String name = null;
        String seq = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.startsWith(">")) {
                if (name != null) {
                    types.put(name, seq);
                }
                String[] items = line.trim().substring(1).split("\\s+");
                name = String.valueOf(items[0].trim()) + "_" + items[1].trim();
                seq = "";
            } else {
                seq = String.valueOf(seq) + line.trim();
            }
            ++n2;
        }
        types.put(name, seq);
        for (String n3 : types.keySet()) {
            System.out.println(String.valueOf(n3) + "\t" + (String)types.get(n3));
        }
        return types;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(String matchResult) {
        String[] lines = matchResult.split("\n");
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                OneMatch aMatch;
                Map matches;
                String type;
                String[] items = line.trim().split("\\s+");
                String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
                String name = thisRead.substring(0, thisRead.length() - 2);
                boolean isRevComp = items[8].trim().equals("C");
                String string = type = isRevComp ? items[9].trim() : items[8].trim();
                if (!result.containsKey(type)) {
                    result.put(type, new HashMap());
                }
                if (!(matches = (Map)result.get(type)).containsKey(name)) {
                    aMatch = new OneMatch();
                    aMatch.setName(name);
                    matches.put(name, aMatch);
                }
                aMatch = (OneMatch)matches.get(name);
                if (isRevComp) {
                    aMatch.setReverseExist(true);
                    aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                    aMatch.setReverseMatchSize(Integer.valueOf(items[6].trim()) - Integer.valueOf(items[5].trim()));
                    aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                } else {
                    aMatch.setForwardExist(true);
                    aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
                    aMatch.setForwardMatchSize(Integer.valueOf(items[6].trim()) - Integer.valueOf(items[5].trim()));
                    aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
                }
            }
            ++n2;
        }
        return result;
    }

    private static String runCrossMatch(File fastaFile, File hapFile) {
        String cmd = "/genome/bin/cross_match  " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath();
        String data = OsHelper.excuteCommand(cmd);
        return data;
    }
}

