/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.MatchUnit;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.OsHelper;
import primerDesign.GetBackbone;

public class CrossMatchForAssembly {
    static int SIZE = 25;
    static String KEY = "HIP09453_Target";

    public static void main(String[] args) throws Exception {
        File fullFasta;
        File backBones = new File(args[0]);
        File chromatRoot = new File(args[1]);
        File outputRoot = new File(args[2]);
        File phdRoot = new File(args[3]);
        File output = new File(args[4]);
        File fasta = new File(chromatRoot.getParent(), "fasta");
        if (fasta == null || !fasta.isDirectory()) {
            fasta.mkdir();
        }
        if ((fullFasta = new File(chromatRoot.getParent(), "fullFasta")) == null || !fullFasta.isDirectory()) {
            fullFasta.mkdir();
        }
        Map<String, String> chromatFastas = CrossMatchForAssembly.phredChromat(chromatRoot, fasta, " -trim_fasta -trim_alt 0.05");
        Map<String, String> chromatFullFastas = CrossMatchForAssembly.phredChromat(chromatRoot, fullFasta, "");
        ArrayList<String> lowQualityReads = new ArrayList<String>();
        HashMap<String, List<String>> matchedReads = new HashMap<String, List<String>>();
        ArrayList<String> noMatchReads = new ArrayList<String>();
        ArrayList<String> multipleMatchReads = new ArrayList<String>();
        HashMap<String, List<MatchUnit>> multipleMatchUnits = new HashMap<String, List<MatchUnit>>();
        StringBuilder outputBuilder = new StringBuilder();
        for (String chromatName : chromatFastas.keySet()) {
            String seq = chromatFastas.get(chromatName);
            String fullSeq = chromatFullFastas.get(chromatName);
            if (seq.length() < SIZE) {
                lowQualityReads.add(chromatName);
                continue;
            }
            CrossMatchForAssembly.crossMatchChromat(chromatName, seq, fullSeq, backBones, matchedReads, noMatchReads, multipleMatchReads, multipleMatchUnits, outputBuilder);
        }
        for (String backbone : matchedReads.keySet()) {
            File amplicon = new File(outputRoot, backbone);
            if (!amplicon.isDirectory()) {
                amplicon.mkdir();
            }
            File chromat_dir = new File(amplicon, "chromat_dir");
            File phd_dir = new File(amplicon, "phd_dir");
            File assembly = new File(amplicon, "assembly");
            if (!chromat_dir.isDirectory()) {
                chromat_dir.mkdir();
                phd_dir.mkdir();
                assembly.mkdir();
            }
            CrossMatchForAssembly.copyFiles(chromat_dir, (List)matchedReads.get(backbone), chromatRoot);
            FileManager.copyFile(new File(phdRoot, String.valueOf(backbone) + ".phd.1"), new File(phd_dir, "backbone.phd.1"), true);
            System.out.println("done for " + backbone);
        }
        CrossMatchForAssembly.copyReads(outputRoot, noMatchReads, "noMatch", chromatRoot);
        System.out.println("done for no match reads ");
        CrossMatchForAssembly.copyReads(outputRoot, multipleMatchReads, "multipleMatch", chromatRoot);
        CrossMatchForAssembly.fixAndCopy(outputRoot, multipleMatchUnits, "multipleMatchFix", chromatRoot);
        System.out.println("done for multipleMatchReads reads ");
        CrossMatchForAssembly.copyReads(outputRoot, lowQualityReads, "lowQuality", chromatRoot);
        System.out.println("done for lowQualityReads ");
        System.out.println("lowQualityReads " + lowQualityReads.size());
        System.out.println("noMatchReads " + noMatchReads.size());
    }

    private static void fixAndCopy(File outputRoot, Map<String, List<MatchUnit>> multipleMatchUnits, String name, File chromatRoot) {
        File amplicon = new File(outputRoot, name);
        if (!amplicon.isDirectory()) {
            amplicon.mkdir();
        }
        File chromat_dir = new File(amplicon, "chromat_dir");
        File phd_dir = new File(amplicon, "phd_dir");
        File assembly = new File(amplicon, "assembly");
        if (!chromat_dir.isDirectory()) {
            chromat_dir.mkdir();
            phd_dir.mkdir();
            assembly.mkdir();
        }
        for (String cname : multipleMatchUnits.keySet()) {
            int i = 0;
            while (i < multipleMatchUnits.get(cname).size()) {
                MatchUnit matchUnit = multipleMatchUnits.get(cname).get(i);
                String newName = String.valueOf(cname) + "-" + (i + 1);
                FileManager.copyFile(new File(chromatRoot, cname), new File(chromat_dir, newName), true);
                File phdSourceDir = new File(chromatRoot.getParentFile(), "phd_dir");
                File phdFile = new File(phdSourceDir, String.valueOf(cname) + ".phd.1");
                File newPhdFile = new File(phd_dir, String.valueOf(newName) + ".phd.1");
                FileManager.copyFile(phdFile, newPhdFile, true);
                CrossMatchForAssembly.fixFile(newPhdFile, cname, newName, matchUnit, i == 0, i == multipleMatchUnits.get(cname).size() - 1);
                ++i;
            }
        }
    }

    private static void fixFile(File newPhdFile, String cName, String newName, MatchUnit matchUnit, boolean is1st, boolean isLast) {
        StringBuilder data = new StringBuilder();
        String info = FileManager.readTextFile(newPhdFile).replaceAll(cName, newName);
        String[] lines = info.split("\n");
        if (!lines[18].trim().startsWith("BEGIN_DNA")) {
            System.out.println("wrong in phd file" + cName);
        }
        int start = matchUnit.getMatchStart();
        int end = matchUnit.getMatchEnd();
        int i = 0;
        while (i < 19) {
            data.append(lines[i].trim()).append("\n");
            ++i;
        }
        i = 19;
        while (i < lines.length) {
            String[] qs = lines[i].trim().split("\\s+");
            if (qs.length == 3) {
                if (i - 19 + 1 < start && !is1st) {
                    data.append("n ").append(qs[1]).append(" ").append(qs[2]).append("\n");
                } else if (i - 19 + 1 > end && !isLast) {
                    data.append("n ").append(qs[1]).append(" ").append(qs[2]).append("\n");
                } else {
                    data.append(lines[i].trim()).append("\n");
                }
            } else {
                data.append(lines[i].trim()).append("\n");
            }
            ++i;
        }
        FileManager.writeTextFile(newPhdFile, data.toString(), true);
    }

    private static void copyReads(File outputRoot, List<String> noMatchReads, String name, File chromatRoot) {
        File amplicon = new File(outputRoot, name);
        if (!amplicon.isDirectory()) {
            amplicon.mkdir();
        }
        File chromat_dir = new File(amplicon, "chromat_dir");
        File phd_dir = new File(amplicon, "phd_dir");
        File assembly = new File(amplicon, "assembly");
        if (!chromat_dir.isDirectory()) {
            chromat_dir.mkdir();
            phd_dir.mkdir();
            assembly.mkdir();
        }
        CrossMatchForAssembly.copyFiles(chromat_dir, noMatchReads, chromatRoot);
    }

    private static void copyFiles(File chromat_dir, List<String> list, File chromatRoot) {
        for (String name : list) {
            FileManager.copyFile(new File(chromatRoot, name), new File(chromat_dir, name), true);
        }
    }

    private static void crossMatchChromat(String chromatName, String sequence, String fullSequence, File backBones, Map<String, List<String>> matchedReads, List<String> noMatchReads, List<String> multipleMatchReads, Map<String, List<MatchUnit>> multipleMatchUnits, StringBuilder outputBuilder) throws Exception {
        File tmpFile = File.createTempFile("crossm", "fa");
        StringBuilder builder = new StringBuilder();
        builder.append(">").append(chromatName).append("\n");
        builder.append(sequence);
        FileManager.writeTextFile(tmpFile, builder.toString(), true);
        String cmd = "/genome/bin/cross_match -minscore 20 " + tmpFile.getAbsolutePath() + " " + backBones;
        String data = OsHelper.excuteCommand(cmd);
        if (data.indexOf("0 matching entries") > 0) {
            noMatchReads.add(chromatName);
            return;
        }
        if (data.indexOf("Maximal single base matches") < 0 || data.indexOf("1 matching entries") < 0) {
            System.out.println("unknown " + chromatName + " " + sequence);
            return;
        }
        int start = data.indexOf("Maximal single base matches");
        int end = data.indexOf("1 matching entries");
        String[] out = data.substring(start, end).split("\n");
        int count = 0;
        System.out.println("----------------");
        ArrayList<MatchUnit> matches = new ArrayList<MatchUnit>();
        int offset = fullSequence.indexOf(sequence);
        String[] stringArray = out;
        int n = out.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(chromatName) > 0) {
                System.out.println(line);
                outputBuilder.append(line);
                ++count;
                String[] items = line.split("\\s+");
                int index = 0;
                int i = 0;
                while (i < items.length) {
                    if (items[i].trim().equals(chromatName)) {
                        index = i;
                        break;
                    }
                    ++i;
                }
                MatchUnit matchUnit = new MatchUnit(Integer.valueOf(items[index + 1]) + offset, Integer.valueOf(items[index + 2]) + offset);
                matches.add(matchUnit);
            }
            ++n2;
        }
        if (count > 1) {
            multipleMatchReads.add(chromatName);
            multipleMatchUnits.put(chromatName, matches);
            System.out.println("multipleMatchReads");
        } else if (count == 1) {
            if (!matchedReads.containsKey(KEY)) {
                matchedReads.put(KEY, new ArrayList());
            }
            matchedReads.get(KEY).add(chromatName);
        }
    }

    private static Map<String, String> phredChromat(File chromatDir, File fasta, String option) {
        File[] fastaFiles;
        HashMap<String, String> fastaMap = new HashMap<String, String>();
        if (fasta.listFiles().length == 0) {
            String cmd = "/genome/bin/phred -id " + chromatDir.getAbsolutePath() + " -sd " + fasta.getAbsolutePath() + option;
            System.out.println(cmd);
            OsHelper.excuteCommand(cmd);
        }
        File[] fileArray = fastaFiles = fasta.listFiles();
        int n = fastaFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            String seq = GetBackbone.getSequenceFromFasta(file);
            fastaMap.put(file.getName().substring(0, file.getName().length() - 4), seq);
            ++n2;
        }
        return fastaMap;
    }
}

