/*
 * Decompiled with CFR 0.152.
 */
package fileOperation;

import fileOperation.ConvertFastaQdataMiSeq;
import fileOperation.OneMatch;
import fileOperation.ParseFastaByHapType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import misc.FileManager;
import misc.SystemCommand;

public class CrossMatchEndSeqCI {
    static int MIN_SCORE = 60;
    static String LABEL = "000000";
    private static final int MIN_NUM_PAIRS_OUTPUT = 10;

    public static void main(String[] args) throws Exception {
        File backBones = new File(args[0]);
        File miseqDir = new File(args[1]);
        File output = new File(args[2]);
        File fastaqRoot = new File(args[3]);
        File assemblyRoot = new File(args[4]);
        boolean doAssemble = new Boolean(args[5]);
        boolean isPairedReads = new Boolean(args[6]);
        StringBuilder outputBuilder = new StringBuilder();
        outputBuilder.append("Coord\t").append("prob\t").append("count\t").append("average mismatch\t").append("average score\t").append("shared count\n");
        File[] fileArray = miseqDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("fa")) {
                System.out.println(file.getName().substring(0, file.getName().length() - 9));
                File fastaq = new File(fastaqRoot, String.valueOf(file.getName().substring(0, file.getName().length() - 9)) + ".fq");
                File assemblyDir = new File(assemblyRoot, file.getName().substring(0, file.getName().length() - 9));
                File matchResult = CrossMatchEndSeqCI.runCrossMatch(file, backBones);
                Map<String, List<String>> filteredResult = CrossMatchEndSeqCI.filterResult(matchResult);
                System.out.println("after filteredResult " + filteredResult.size());
                HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
                CrossMatchEndSeqCI.ParseResult(result, matchResult, filteredResult, file);
                CrossMatchEndSeqCI.summarize(file, result, outputBuilder, fastaq, assemblyDir, doAssemble, isPairedReads);
            }
            ++n2;
        }
        FileManager.writeTextFile(output, outputBuilder.toString(), true);
    }

    private static boolean isInFilteredResult(Map<String, List<String>> filteredResult, String[] items) {
        String type;
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        return filteredResult.containsKey(name) && filteredResult.get(name).contains(type);
    }

    private static void ParseResult(Map<String, Map<String, OneMatch>> result, File matchResult, Map<String, List<String>> filteredResult, File fastaFile) throws Exception {
        String[] lines = FileManager.readTextFile(matchResult).split("\n");
        int lineCount = 0;
        boolean startRecord = false;
        OneMatch aMatch = null;
        String fullName = null;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++lineCount;
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                String[] items = line.trim().split("\\s+");
                if (CrossMatchEndSeqCI.isInFilteredResult(filteredResult, items)) {
                    startRecord = true;
                    fullName = items[4].trim();
                    aMatch = CrossMatchEndSeqCI.populateAmatch(fastaFile, result, line, CrossMatchEndSeqCI.isASharedMatch(filteredResult, items));
                } else {
                    startRecord = false;
                    aMatch = null;
                    fullName = null;
                }
            } else if (startRecord) {
                int cfr_ignored_0 = line.trim().split("\\s+").length;
            }
            ++n2;
        }
    }

    private static boolean isASharedMatch(Map<String, List<String>> filteredResult, String[] items) {
        String type;
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        return filteredResult.containsKey(name) && filteredResult.get(name).size() > 1;
    }

    private static OneMatch populateAmatch(File fastaFile, Map<String, Map<String, OneMatch>> result, String line, boolean isASharedMatch) {
        OneMatch aMatch;
        Map<String, OneMatch> matches;
        String type;
        String[] items = line.trim().split("\\s+");
        String thisRead = ConvertFastaQdataMiSeq.generateName(items[4].trim());
        String name = thisRead.substring(0, thisRead.length() - 2);
        String fullName = items[4].trim();
        boolean isRevComp = items[8].trim().equals("C");
        String string = type = isRevComp ? items[9].trim() : items[8].trim();
        if (!result.containsKey(type)) {
            result.put(type, new HashMap());
        }
        if (!(matches = result.get(type)).containsKey(name)) {
            aMatch = new OneMatch();
            if (isASharedMatch) {
                aMatch.setSharedMatch(true);
            }
            aMatch.setName(name);
            matches.put(name, aMatch);
        }
        aMatch = matches.get(name);
        if (isRevComp) {
            aMatch.setReverseExist(true);
            aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
            aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
            aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
            aMatch.setReverseFullName(fullName);
            aMatch.setReverseStart(Integer.valueOf(items[5].trim()));
            aMatch.setReverseEnd(Integer.valueOf(items[6].trim()));
            aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
        } else {
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardFullName(fullName);
            aMatch.setForwardStart(Integer.valueOf(items[5].trim()));
            aMatch.setForwardEnd(Integer.valueOf(items[6].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return aMatch;
    }

    private static File runCrossMatch(File fastaFile, File hapFile) throws Exception {
        File tmpFile = File.createTempFile("out", "txt");
        tmpFile.deleteOnExit();
        String cmd = "/genome/bin/cross_match -masklevel 101 -minmatch 30 -minscore " + MIN_SCORE + " " + fastaFile.getAbsolutePath() + " " + hapFile.getAbsolutePath() + " > " + tmpFile.getAbsolutePath();
        System.out.println(cmd);
        String[] commandArray = new String[]{"bash", "-c", cmd};
        SystemCommand command = new SystemCommand(commandArray, null, false);
        System.out.println("running cross_match...");
        command.makeItSo();
        System.out.println("done cross_match...");
        return tmpFile;
    }

    private static Map<String, List<String>> filterResult(File matchResult) throws Exception {
        HashMap<String, Map<String, Integer>> readsMap = new HashMap<String, Map<String, Integer>>();
        BufferedReader indexReader = new BufferedReader(new FileReader(matchResult));
        try {
            String line;
            int lineCount = 0;
            while ((line = indexReader.readLine()) != null) {
                ++lineCount;
                if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12) continue;
                String[] items = line.trim().split("\\s+");
                CrossMatchEndSeqCI.updateReadMap(readsMap, items);
            }
        }
        finally {
            indexReader.close();
        }
        HashMap<String, List<String>> readsMatches = new HashMap<String, List<String>>();
        for (String readName : readsMap.keySet()) {
            readsMatches.put(readName, CrossMatchEndSeqCI.getBestMatchingTypes((Map)readsMap.get(readName), readName));
        }
        return readsMatches;
    }

    private static List<String> getBestMatchingTypes(Map<String, Integer> allMap, String readName) {
        HashMap mapByScore = new HashMap();
        for (String type : allMap.keySet()) {
            if (!mapByScore.containsKey(allMap.get(type))) {
                mapByScore.put(allMap.get(type), new ArrayList());
            }
            ((List)mapByScore.get(allMap.get(type))).add(type);
        }
        ArrayList<String> results = new ArrayList<String>();
        Object[] num = mapByScore.keySet().toArray();
        Arrays.sort(num);
        results.addAll((Collection)mapByScore.get(num[num.length - 1]));
        if (((List)mapByScore.get(num[num.length - 1])).size() > 1) {
            System.out.println(String.valueOf(readName) + " best score on 2 types");
            for (String type : (List)mapByScore.get(num[num.length - 1])) {
                System.out.println(type);
            }
        }
        return results;
    }

    private static void updateReadMap(Map<String, Map<String, Integer>> readsMap, String[] items) {
        String name = items[4].trim().substring(0, items[4].trim().length() - 2);
        boolean isRevComp = items[8].trim().equals("C");
        String type = isRevComp ? items[9].trim() : items[8].trim();
        Integer score = Integer.valueOf(items[0].trim());
        if (!readsMap.containsKey(name)) {
            readsMap.put(name, new HashMap());
        }
        if (!readsMap.get(name).containsKey(type)) {
            readsMap.get(name).put(type, 0);
        }
        int newScore = readsMap.get(name).get(type) + score;
        readsMap.get(name).put(type, newScore);
    }

    private static List<String> filterResult(String matchResult) {
        String[] lines;
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = lines = matchResult.split("\n");
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.indexOf(LABEL) > 0 && line.trim().split("\\s+").length >= 12) {
                results.add(line);
            }
            ++n2;
        }
        return results;
    }

    private static Map<String, Map<String, OneMatch>> ParseResult(List<String> filteredResult) {
        HashMap<String, Map<String, OneMatch>> result = new HashMap<String, Map<String, OneMatch>>();
        for (String line : filteredResult) {
            OneMatch aMatch;
            Map matches;
            String type;
            if (line.indexOf(LABEL) <= 0 || line.trim().split("\\s+").length < 12) continue;
            String[] items = line.trim().split("\\s+");
            String name = items[4].trim().substring(0, items[4].trim().length() - 2);
            boolean isRevComp = items[8].trim().equals("C");
            String string = type = isRevComp ? items[9].trim() : items[8].trim();
            if (!result.containsKey(type)) {
                result.put(type, new HashMap());
            }
            if (!(matches = (Map)result.get(type)).containsKey(name)) {
                aMatch = new OneMatch();
                aMatch.setName(name);
                matches.put(name, aMatch);
            }
            aMatch = (OneMatch)matches.get(name);
            if (isRevComp) {
                aMatch.setReverseExist(true);
                aMatch.setReverseScore(Integer.valueOf(items[0].trim()));
                aMatch.setReverseTargetStart(Integer.valueOf(items[12].trim()));
                aMatch.setReverseTargetEnd(Integer.valueOf(items[11].trim()));
                aMatch.setReverseMisMatch(Double.valueOf(items[1].trim()));
                continue;
            }
            aMatch.setForwardExist(true);
            aMatch.setForwardScore(Integer.valueOf(items[0].trim()));
            aMatch.setForwardTargetStart(Integer.valueOf(items[9].trim()));
            aMatch.setForwardTargetEnd(Integer.valueOf(items[10].trim()));
            aMatch.setForwardMisMatch(Double.valueOf(items[1].trim()));
        }
        return result;
    }

    private static void summarize(File fasta, Map<String, Map<String, OneMatch>> result, StringBuilder builder, File fastaq, File assemblyDir, boolean doAssemble, boolean isPairedReads) throws Exception {
        HashMap effectiveMatchesByType = new HashMap();
        HashMap orgnizedTypes = new HashMap();
        int roundNum = 0;
        if (result.size() == 0) {
            builder.append(fasta.getName().substring(0, fasta.getName().length() - 9));
            builder.append("\n");
        }
        for (String type : result.keySet()) {
            Map<String, OneMatch> matches = result.get(type);
            ArrayList<OneMatch> effectiveMatches = new ArrayList<OneMatch>();
            int count = 0;
            for (OneMatch match : matches.values()) {
                if (!match.isForwardExist() || !match.isReverseExist()) continue;
                effectiveMatches.add(match);
                ++count;
            }
            if (count <= 0) continue;
            effectiveMatchesByType.put(type, effectiveMatches);
            if (!orgnizedTypes.containsKey(count)) {
                orgnizedTypes.put(count, new ArrayList());
            }
            ((List)orgnizedTypes.get(count)).add(type);
        }
        Object[] num = orgnizedTypes.keySet().toArray();
        Arrays.sort(num);
        int imageCount = 0;
        int i = num.length - 1;
        while (i >= 0) {
            int c = (Integer)num[i];
            if (c > 10) {
                for (String t : (List)orgnizedTypes.get(c)) {
                    File phdDir;
                    File typeDir;
                    String info;
                    if (roundNum == 0) {
                        info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                        builder.append(info);
                        builder.append(CrossMatchEndSeqCI.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                        builder.append("\t");
                        builder.append(CrossMatchEndSeqCI.getSharedCount((List)effectiveMatchesByType.get(t)));
                        builder.append("\n");
                        ++imageCount;
                        if (!doAssemble) continue;
                        typeDir = new File(assemblyDir, t);
                        phdDir = ParseFastaByHapType.makeDirs(typeDir);
                        ParseFastaByHapType.convert(phdDir, CrossMatchEndSeqCI.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                        continue;
                    }
                    info = String.valueOf(fasta.getName().substring(0, fasta.getName().length() - 9)) + "\t" + t + "\t" + c + "\t";
                    builder.append(info);
                    builder.append(CrossMatchEndSeqCI.getStatistics((List)effectiveMatchesByType.get(t), roundNum));
                    builder.append("\n");
                    ++imageCount;
                    if (!doAssemble) continue;
                    typeDir = new File(assemblyDir, t);
                    phdDir = ParseFastaByHapType.makeDirs(typeDir);
                    ParseFastaByHapType.convert(phdDir, CrossMatchEndSeqCI.toListOfNames((List)effectiveMatchesByType.get(t)), fastaq, null);
                }
            }
            --i;
        }
    }

    private static int getSharedCount(List<OneMatch> list) {
        int count = 0;
        for (OneMatch match : list) {
            if (!match.isSharedMatch()) continue;
            ++count;
        }
        return count;
    }

    private static List<String> toListOfNames(List<OneMatch> matches) {
        ArrayList<String> names = new ArrayList<String>();
        for (OneMatch matche : matches) {
            names.add(matche.getName());
            if (names.size() >= 300) break;
        }
        return names;
    }

    private static String getStatistics(List<OneMatch> list, int roundNum) {
        double mismatch = 0.0;
        int score = 0;
        for (OneMatch match : list) {
            if (roundNum == 0) {
                mismatch += match.getForwardMisMatch();
                mismatch += match.getReverseMisMatch();
                score += match.getForwardScore();
                score += match.getReverseScore();
                continue;
            }
            mismatch += match.isForwardExist() ? match.getForwardMisMatch() : match.getReverseMisMatch();
            score += match.isForwardExist() ? match.getForwardScore() : match.getReverseScore();
        }
        int total = list.size();
        if (roundNum == 0) {
            total += total;
        }
        String out = String.valueOf(CrossMatchEndSeqCI.roundTwoDecimals(mismatch / new Double(total))) + "\t";
        return String.valueOf(out) + score / total;
    }

    private static double roundTwoDecimals(double d) {
        DecimalFormat twoDForm = new DecimalFormat("#.##");
        return Double.valueOf(twoDForm.format(d));
    }
}

